/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import widex.utils.Dialogs;

public class Utils {
    private static ComponentOrientation componentOrientation = ComponentOrientation.LEFT_TO_RIGHT;
    private static FocusListener s_selectAllFocusListener = null;

    public static void init(ComponentOrientation co) {
        Utils.setComponentOrientation(co);
        if (!Utils.getOrientation().isLeftToRight()) {
            // empty if block
        }
    }

    public static void removeBinding(JComponent comp, String key) {
        InputMap map;
        KeyStroke ks = KeyStroke.getKeyStroke(key);
        if (ks == null) {
            throw new IllegalArgumentException("Unknown key name: " + key);
        }
        for (map = comp.getInputMap(0); map != null; map = map.getParent()) {
            map.remove(ks);
        }
        for (map = comp.getInputMap(2); map != null; map = map.getParent()) {
            map.remove(ks);
        }
        for (map = comp.getInputMap(1); map != null; map = map.getParent()) {
            map.remove(ks);
        }
    }

    public static void setComponentOrientation(ComponentOrientation co) {
        componentOrientation = co;
    }

    public static boolean isLocal() {
        return false;
    }

    public static boolean isGlobal() {
        return true;
    }

    public static void zzzzzzzzzToLocal() {
    }

    public static ComponentOrientation getOrientation() {
        return componentOrientation;
    }

    public static float getAlignmentX() {
        if (componentOrientation == ComponentOrientation.RIGHT_TO_LEFT) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static Properties getProps(String extraArgs) {
        Properties prp = new Properties();
        Vector<String> tokensVec = new Vector<String>();
        StringBuffer tokenBuf = new StringBuffer();
        char[] chars = extraArgs.toCharArray();
        int brackets = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{') {
                if (brackets > 0) {
                    tokenBuf.append(chars[i]);
                }
                ++brackets;
                continue;
            }
            if (chars[i] == '}') {
                if (--brackets > 0) {
                    tokenBuf.append(chars[i]);
                    continue;
                }
                tokensVec.add(tokenBuf.toString());
                tokenBuf.delete(0, tokenBuf.length());
                continue;
            }
            if (brackets <= 0) continue;
            tokenBuf.append(chars[i]);
        }
        String[] tokens = tokensVec.toArray(new String[0]);
        for (int i = 0; i < tokens.length; ++i) {
            int pos = tokens[i].indexOf("=");
            if (pos == -1) continue;
            prp.put(tokens[i].substring(0, pos), tokens[i].substring(pos + 1));
        }
        return prp;
    }

    public static String replace(String src, String substringOld, int substringNewInt) {
        return Utils.replace(src, substringOld, String.valueOf(substringNewInt));
    }

    public static String replace(String src, String substringOld, String substringNew) {
        StringBuffer buf = new StringBuffer();
        int startPos = 0;
        int endPos = src.indexOf(substringOld);
        int length = substringOld.length();
        while (endPos != -1) {
            buf.append(src.substring(startPos, endPos));
            buf.append(substringNew);
            startPos = endPos + length;
            endPos = src.indexOf(substringOld, startPos);
        }
        buf.append(src.substring(startPos));
        return buf.toString();
    }

    public static String commatize(int number) {
        return NumberFormat.getIntegerInstance().format(number);
    }

    public static void printTableColumnWidth(JTable table, String tableName) {
        JFrame x = new JFrame("Sizer for " + tableName);
        x.addComponentListener(new DevWindowAdapter(table, tableName));
        x.setBounds(0, 0, 250, 100);
        x.setDefaultCloseOperation(2);
        x.show();
    }

    public static String getWindowTitle(Window window) {
        if (window == null) {
            return null;
        }
        if (window instanceof JFrame) {
            return ((JFrame)window).getTitle();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getTitle();
        }
        return Utils.getWindowTitle(window.getOwner());
    }

    public static void setWindowTitle(Component component, String title) {
        Utils.setWindowTitle(Utils.windowForComponent(component), title);
    }

    public static void setWindowTitle(Window window, String title) {
        if (window == null) {
            return;
        }
        if (window instanceof JFrame) {
            ((JFrame)window).setTitle(title);
        } else if (window instanceof JDialog) {
            ((JDialog)window).setTitle(title);
        } else {
            Utils.setWindowTitle(window.getOwner(), title);
        }
    }

    public static JDialog createDialog(Component c, String title, boolean modal) {
        JDialog dialog = null;
        Window window = null;
        window = c instanceof Window ? (Window)c : Utils.windowForComponent(c);
        if (window == null) {
            if (title == null) {
                title = "";
            }
            dialog = new JDialog((Frame)null, title, modal);
        } else if (window instanceof Frame) {
            Frame frame = (Frame)window;
            if (title == null) {
                title = frame.getTitle();
            }
            dialog = new JDialog(frame, title, modal);
        } else {
            JDialog dlg = (JDialog)window;
            if (title == null) {
                title = dlg.getTitle();
            }
            dialog = new JDialog(dlg, title, modal);
        }
        return dialog;
    }

    public static String hourAsText(long l) {
        return Utils.hourAsText(new Date(l));
    }

    public static String hourAsText(Date date) {
        SimpleDateFormat x = new SimpleDateFormat("HH:mm");
        return x.format(date);
    }

    public static String dateAsText(long l) {
        return Utils.dateAsText(new Date(l));
    }

    public static String dateAsText(Date date) {
        SimpleDateFormat x = new SimpleDateFormat("dd/MM/yyyy");
        return x.format(date);
    }

    public static String lz(int num) {
        if (num < 10) {
            return "0" + num;
        }
        return num + "";
    }

    public static void makeHideOnEscape(JFrame fr) {
        Utils.addEscKeyFeature(fr, fr.getRootPane());
    }

    public static void makeHideOnEscape(JDialog dg) {
        Utils.addEscKeyFeature(dg, dg.getRootPane());
    }

    public static void makeHideOnEscape(JWindow wn) {
        Utils.addEscKeyFeature(wn, wn.getRootPane());
    }

    public static void addEscKeyFeature(Component c, JRootPane rootPane) {
        final Component fc = c;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                fc.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
    }

    public static void addEscKeyAction(JComponent c, ActionListener actionListener) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        c.registerKeyboardAction(actionListener, stroke, 2);
    }

    public static void fixCompHeight(JComponent jcomponent, int h) {
        int w1 = jcomponent.getPreferredSize().width;
        int w2 = jcomponent.getMaximumSize().width;
        int w3 = jcomponent.getMinimumSize().width;
        jcomponent.setPreferredSize(new Dimension(w1, h));
        jcomponent.setMaximumSize(new Dimension(w2, h));
        jcomponent.setMinimumSize(new Dimension(w3, h));
    }

    public static void fixCompWidth(JComponent jcomponent, int w) {
        int h1 = jcomponent.getPreferredSize().height;
        int h2 = jcomponent.getMaximumSize().height;
        int h3 = jcomponent.getMinimumSize().height;
        jcomponent.setPreferredSize(new Dimension(w, h1));
        jcomponent.setMaximumSize(new Dimension(w, h2));
        jcomponent.setMinimumSize(new Dimension(w, h3));
    }

    public static void fixCompSize(JComponent jcomponent, int w, int h) {
        Utils.fixCompSize(jcomponent, new Dimension(w, h));
    }

    public static void fixCompSize(JComponent jcomponent, Dimension dimension) {
        jcomponent.setPreferredSize(dimension);
        jcomponent.setMaximumSize(dimension);
        jcomponent.setMinimumSize(dimension);
    }

    public static boolean isTextFieldEmpty(JTextComponent textField, String errorMessage) {
        return Utils.isTextFieldEmpty(textField, errorMessage, null, true);
    }

    public static boolean isTextFieldEmpty(JTextComponent textField, String errorMessage, boolean req) {
        return Utils.isTextFieldEmpty(textField, errorMessage, null, req);
    }

    public static boolean isTextFieldEmpty(JTextComponent textField, String errorMessage, String dialogTitle, boolean req) {
        if (textField.getText().trim().equals("")) {
            Dialogs.showErrorDialog(textField, errorMessage, dialogTitle);
            if (req) {
                textField.requestFocusInWindow();
            }
            return true;
        }
        return false;
    }

    public static Color parseColor(String colorString) {
        if (colorString == null) {
            return null;
        }
        if ((colorString = colorString.trim()).equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (colorString.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (colorString.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (colorString.equalsIgnoreCase("dark_gray")) {
            return Color.DARK_GRAY;
        }
        if (colorString.equalsIgnoreCase("darkgray")) {
            return Color.darkGray;
        }
        if (colorString.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (colorString.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (colorString.equalsIgnoreCase("light_gray")) {
            return Color.LIGHT_GRAY;
        }
        if (colorString.equalsIgnoreCase("lightgray")) {
            return Color.lightGray;
        }
        if (colorString.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (colorString.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (colorString.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (colorString.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (colorString.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (colorString.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            int pos = colorString.indexOf(",");
            int red = Integer.parseInt(colorString.substring(0, pos).trim());
            int pos2 = colorString.indexOf(",", pos + 1);
            int green = Integer.parseInt(colorString.substring(pos + 1, pos2).trim());
            int blue = Integer.parseInt(colorString.substring(pos2 + 1).trim());
            return new Color(red, green, blue);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static Image makeColorTransparent(Image im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.deleteFile(files[i]);
            }
        }
        file.delete();
    }

    public static boolean onlyLeftButton(MouseEvent e) {
        int onmask = 1024;
        int offmask = 6144;
        return (e.getModifiersEx() & (onmask | offmask)) == onmask;
    }

    public static Point adjustPopupLocationToFitScreen(Component invoker, int xposition, int yposition) {
        Rectangle screenBounds;
        Insets screenInsets;
        Point p = new Point(xposition, yposition);
        if (GraphicsEnvironment.isHeadless()) {
            return p;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(p)) continue;
            gc = dgc;
            break;
        }
        if (gc == null && invoker != null) {
            gc = invoker.getGraphicsConfiguration();
        }
        if (gc != null) {
            screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
        } else {
            screenInsets = new Insets(0, 0, 0, 0);
            screenBounds = new Rectangle(toolkit.getScreenSize());
        }
        int scrWidth = screenBounds.width - Math.abs(screenInsets.left + screenInsets.right);
        int scrHeight = screenBounds.height - Math.abs(screenInsets.top + screenInsets.bottom);
        Dimension size = invoker.getPreferredSize();
        if (p.x + size.width > screenBounds.x + scrWidth) {
            p.x = screenBounds.x + scrWidth - size.width;
        }
        if (p.y + size.height > screenBounds.y + scrHeight) {
            p.y = screenBounds.y + scrHeight - size.height;
        }
        if (p.x < screenBounds.x) {
            p.x = screenBounds.x;
        }
        if (p.y < screenBounds.y) {
            p.y = screenBounds.y;
        }
        return p;
    }

    public static int getMaxWidth(JComponent c1, JComponent c2) {
        return Utils.getMaxWidth(new JComponent[]{c1, c2});
    }

    public static int getMaxWidth(JComponent c1, JComponent c2, JComponent c3) {
        return Utils.getMaxWidth(new JComponent[]{c1, c2, c3});
    }

    public static int getMaxWidth(JComponent[] comps) {
        int max = -1;
        for (int i = 0; i < comps.length; ++i) {
            max = Math.max(max, comps[i].getPreferredSize().width);
        }
        return max;
    }

    public static void sizeToMaxWidth(JComponent c1, JComponent c2) {
        Utils.sizeToMaxWidth(new JComponent[]{c1, c2});
    }

    public static void sizeToMaxWidth(JComponent c1, JComponent c2, JComponent c3) {
        Utils.sizeToMaxWidth(new JComponent[]{c1, c2, c3});
    }

    public static void sizeToMaxWidth(JComponent c1, JComponent c2, JComponent c3, JComponent c4) {
        Utils.sizeToMaxWidth(new JComponent[]{c1, c2, c3, c4});
    }

    public static void sizeToMaxWidth(JComponent c1, JComponent c2, JComponent c3, JComponent c4, JComponent c5) {
        Utils.sizeToMaxWidth(new JComponent[]{c1, c2, c3, c4, c5});
    }

    public static void sizeToMaxWidth(JComponent c1, JComponent c2, JComponent c3, JComponent c4, JComponent c5, JComponent c6) {
        Utils.sizeToMaxWidth(new JComponent[]{c1, c2, c3, c4, c5, c6});
    }

    public static void sizeToMaxWidth(JComponent[] comps) {
        int max = Utils.getMaxWidth(comps);
        for (int i = 0; i < comps.length; ++i) {
            Utils.fixCompWidth(comps[i], max);
        }
    }

    public static FocusListener getSelectAllFocusListener() {
        if (s_selectAllFocusListener == null) {
            s_selectAllFocusListener = new SelectAllFocusListener();
        }
        return s_selectAllFocusListener;
    }

    public static Window windowForComponent(Component c) {
        if (c instanceof Window) {
            return (Window)c;
        }
        if (c == null) {
            return null;
        }
        return SwingUtilities.windowForComponent(c);
    }

    public static class SelectAllFocusListener
    extends FocusAdapter {
        public void focusGained(FocusEvent e) {
            JTextComponent txt = (JTextComponent)e.getSource();
            txt.setCaretPosition(txt.getText().length());
            txt.selectAll();
        }
    }

    static class DevWindowAdapter
    implements ComponentListener {
        JTable table;
        String tableName;

        DevWindowAdapter(JTable _table, String _tableName) {
            this.table = _table;
            this.tableName = _tableName;
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
            this.pITman();
        }

        public void componentMoved(ComponentEvent e) {
            this.pITman();
        }

        public void componentResized(ComponentEvent e) {
            this.pITman();
        }

        void pITman() {
            System.out.println("\n------------------------------------------------------\n");
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                int size = this.table.getColumnModel().getColumn(i).getPreferredWidth();
                System.out.println(this.tableName + ".getColumnModel().getColumn(" + i + ").setPreferredWidth(" + size + ");");
            }
            System.out.println("\n------------------------------------------------------\n");
        }
    }
}

