/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.security.AccessController;
import java.util.Properties;
import sun.security.action.GetPropertyAction;

public class UIConstsParser {
    public static Properties parse(String fileName) throws IOException {
        return UIConstsParser.parse(new File(fileName));
    }

    public static Properties parse(File file) throws IOException {
        return UIConstsParser.parse(file.toURL());
    }

    public static Properties parse(URL url) throws IOException {
        return UIConstsParser.parse(url, "UTF-8");
    }

    public static Properties parse(URL url, String charset) throws IOException {
        InputStream inputStream = url.openStream();
        Properties pb = UIConstsParser.parse(inputStream, charset);
        inputStream.close();
        return pb;
    }

    public static Properties parse(InputStream inputStream) throws IOException {
        return UIConstsParser.parse(inputStream, "UTF-8");
    }

    public static Properties parse(InputStream inputStream, String charset) throws IOException {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        Properties pb = new Properties();
        InputStreamReader isr = charset != null ? new InputStreamReader(inputStream, charset) : new InputStreamReader(inputStream);
        BufferedReader in = new BufferedReader(isr);
        String line = in.readLine();
        while (line != null) {
            String val;
            String key;
            if ((line = line.trim()).startsWith("#")) {
                line = in.readLine();
                continue;
            }
            int pos = line.indexOf("=");
            if (pos == -1) {
                line = in.readLine();
                continue;
            }
            boolean isSingleRowValue = true;
            if (pos >= 2) {
                char mLetter = line.charAt(pos - 1);
                char space = line.charAt(pos - 2);
                if ((mLetter == 'M' || mLetter == 'm') && space == ' ') {
                    isSingleRowValue = false;
                }
            }
            if (isSingleRowValue) {
                key = line.substring(0, pos).trim().toLowerCase();
                val = UIConstsParser.checkQuotes(line.substring(pos + 1).trim());
                pb.put(key, val);
                line = in.readLine();
                continue;
            }
            key = line.substring(0, pos - 1).trim().toLowerCase();
            val = null;
            line = line.substring(pos + 1);
            while (line != null) {
                if ((line = line.trim()).length() == 0) {
                    line = in.readLine();
                    continue;
                }
                if (line.toUpperCase().equals("(MULTI-LINE-END)")) break;
                line = UIConstsParser.checkQuotes(line);
                val = val == null ? line : val + lineSeparator + line;
                line = in.readLine();
            }
            if (val == null) {
                val = "";
            }
            pb.put(key, val);
            if (line == null) continue;
            line = in.readLine();
        }
        in.close();
        return pb;
    }

    private static String checkQuotes(String val) {
        if (val.startsWith("\"") && val.endsWith("\"")) {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static void save(File file, String text) throws Exception {
        UIConstsParser.save(file, text, "UTF-8");
    }

    public static void save(File file, String text, String charset) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter out = null;
        out = charset == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, charset);
        out.write(text);
        ((Writer)out).flush();
        ((Writer)out).close();
    }
}

