/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ImageIcon;
import widex.utils.BMP;
import widex.utils.UIConstsParser;
import widex.utils.Utils;

public class UIConstsManager {
    public Properties pb = new Properties();
    private HashMap m_stringsCache = new HashMap();
    static /* synthetic */ Class class$widex$utils$UIConstsManager;

    public UIConstsManager() {
    }

    public UIConstsManager(String fileName) throws IOException {
        this(UIConstsManager.getURL(fileName));
    }

    public UIConstsManager(File file) throws IOException {
        this(UIConstsManager.getURL(file));
    }

    public UIConstsManager(URL url) throws IOException {
        this.pb = UIConstsParser.parse(url);
    }

    static URL getURL(File file) throws IOException {
        if (file == null) {
            throw new IOException("Cannot find resource " + file);
        }
        return file.toURL();
    }

    static URL getURL(String fileName) throws IOException {
        URL url = (class$widex$utils$UIConstsManager == null ? (class$widex$utils$UIConstsManager = UIConstsManager.class$("widex.utils.UIConstsManager")) : class$widex$utils$UIConstsManager).getClassLoader().getResource(fileName);
        if (url == null) {
            throw new IOException("Cannot find resource " + fileName);
        }
        return url;
    }

    public Properties getProperties() {
        return this.pb;
    }

    public String get(String key) {
        key = key.trim().toLowerCase();
        return this.pb.getProperty(key);
    }

    public String get(String key, String defStr) {
        String str = this.pb.getProperty(key = key.trim().toLowerCase());
        if (str == null) {
            return defStr;
        }
        return str;
    }

    public int getInt(String key) {
        key = key.trim().toLowerCase();
        key = this.pb.getProperty(key);
        return Integer.parseInt(key);
    }

    public int getInt(String key, int defInt) {
        key = key.trim().toLowerCase();
        key = this.pb.getProperty(key);
        try {
            return Integer.parseInt(key);
        }
        catch (Exception exp) {
            return defInt;
        }
    }

    public boolean getBoolean(String key, boolean defBoolean) {
        String b = this.pb.getProperty(key = key.trim().toLowerCase());
        if (b == null) {
            return defBoolean;
        }
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        if (b.equalsIgnoreCase("false")) {
            return false;
        }
        return defBoolean;
    }

    public char getChar(String key) {
        String value = this.get(key);
        if (value == null || value.length() == 0) {
            return '\u0000';
        }
        return value.charAt(0);
    }

    public char getChar(String key, char defVal) {
        String value = this.get(key);
        if (value == null || value.length() == 0) {
            return defVal;
        }
        return value.charAt(0);
    }

    public int getMnemonic(String key) {
        return this.getChar(key);
    }

    public Object getObject(String key) {
        key = key.trim().toLowerCase();
        return this.pb.get(key);
    }

    public boolean exist(String key) {
        key = key.trim().toLowerCase();
        return this.pb.containsKey(key);
    }

    public ImageIcon getIcon(String key) {
        String fileName = this.pb.getProperty(key = key.trim().toLowerCase(), "").trim();
        String fileNameUpperCased = fileName.toUpperCase();
        int pos = fileNameUpperCased.indexOf("<T>");
        if (pos == -1) {
            URL url = (class$widex$utils$UIConstsManager == null ? (class$widex$utils$UIConstsManager = UIConstsManager.class$("widex.utils.UIConstsManager")) : class$widex$utils$UIConstsManager).getClassLoader().getResource(fileName);
            if (url == null) {
                return new ImageIcon("");
            }
            if (fileNameUpperCased.endsWith(".BMP")) {
                return new ImageIcon(new BMP(url).getImage());
            }
            return new ImageIcon(url);
        }
        fileName = fileName.substring(0, pos).trim();
        URL url = (class$widex$utils$UIConstsManager == null ? (class$widex$utils$UIConstsManager = UIConstsManager.class$("widex.utils.UIConstsManager")) : class$widex$utils$UIConstsManager).getClassLoader().getResource(fileName);
        if (url == null) {
            return new ImageIcon("");
        }
        try {
            String colorString = fileNameUpperCased.substring(pos + 3, fileNameUpperCased.indexOf("</T>"));
            Color color = Utils.parseColor(colorString);
            ImageIcon iconBefore = null;
            iconBefore = fileName.toUpperCase().endsWith(".BMP") ? new ImageIcon(new BMP(url).getImage()) : new ImageIcon(url);
            Image imageAfter = Utils.makeColorTransparent(iconBefore.getImage(), color);
            return new ImageIcon(imageAfter);
        }
        catch (Exception exp) {
            System.out.println("Excetion while parsing Image : " + fileName);
            if (fileName.endsWith(".BMP")) {
                return new ImageIcon(new BMP(url).getImage());
            }
            return new ImageIcon(url);
        }
    }

    public ImageIcon getIcon(String key, ImageIcon defImageIcon) {
        key = key.trim().toLowerCase();
        ImageIcon ic = null;
        try {
            ic = this.getIcon(key);
            if (ic.getIconWidth() == -1) {
                return defImageIcon;
            }
            return ic;
        }
        catch (Exception exp) {
            return defImageIcon;
        }
    }

    public Color getColor(String key) {
        String value = this.get(key);
        return Utils.parseColor(value);
    }

    public Color getColor(String key, Color defColor) {
        Color c = this.getColor(key);
        if (c == null) {
            return defColor;
        }
        return c;
    }

    public String[] getStrings(String key) {
        if (this.m_stringsCache.containsKey(key = key.trim().toLowerCase())) {
            return (String[])this.m_stringsCache.get(key);
        }
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (this.pb.containsKey(key + i)) {
            strings.add(this.pb.getProperty(key + i));
            ++i;
        }
        String[] strs = strings.toArray(new String[0]);
        this.m_stringsCache.put(key, strs);
        return strs;
    }

    public String[] breakLines(String key) {
        if (key == null) {
            return new String[0];
        }
        key = key.trim().toLowerCase();
        String val = this.pb.getProperty(key, "").trim();
        return val.split("\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

