/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class TreeSelectionDelay {
    private Timer timer;
    private JTree tree;
    private TreeSelectionListener listener;
    private TreeSelectionEvent event;

    public static TreeSelectionDelay configureTree(JTree tree, TreeSelectionListener listener) {
        return new TreeSelectionDelay(tree, listener, 500);
    }

    public static TreeSelectionDelay configureTree(JTree tree, TreeSelectionListener listener, int delay) {
        return new TreeSelectionDelay(tree, listener, delay);
    }

    public TreeSelectionDelay(JTree tree, TreeSelectionListener listener) {
        this(tree, listener, 500);
    }

    public TreeSelectionDelay(JTree tree, TreeSelectionListener listener, int delay) {
        this.tree = tree;
        this.listener = listener;
        this.timer = new Timer(delay, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                TreeSelectionDelay.this.fireEvent();
            }
        });
        this.timer.setRepeats(false);
        final MyTreeSelectionListener selListener = new MyTreeSelectionListener();
        tree.addTreeSelectionListener(selListener);
        tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                selListener.enabled = true;
            }

            public void focusLost(FocusEvent e) {
                selListener.enabled = true;
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent ev) {
            }

            public void mousePressed(MouseEvent ev) {
                selListener.enabled = true;
                TreeSelectionDelay.this.fireEvent();
                TreeSelectionDelay.this.timer.stop();
            }
        });
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    private void fireEvent() {
        if (this.event != null) {
            this.listener.valueChanged(this.event);
        }
        this.event = null;
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        public boolean enabled = true;

        MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreeSelectionDelay.this.event = e;
            if (this.enabled) {
                TreeSelectionDelay.this.timer.restart();
            }
        }
    }
}

