/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableSelectionDelay {
    private Timer timer;
    private JTable table;
    private ListSelectionListener listener;
    private ListSelectionEvent event;

    public static TableSelectionDelay configureTable(JTable table, ListSelectionListener listener) {
        return new TableSelectionDelay(table, listener, 500);
    }

    public static TableSelectionDelay configureTable(JTable table, ListSelectionListener listener, int delay) {
        return new TableSelectionDelay(table, listener, delay);
    }

    public TableSelectionDelay(JTable table, ListSelectionListener listener) {
        this(table, listener, 500);
    }

    public TableSelectionDelay(JTable table, ListSelectionListener listener, int delay) {
        this.table = table;
        this.listener = listener;
        this.timer = new Timer(delay, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                TableSelectionDelay.this.fireEvent();
            }
        });
        this.timer.setRepeats(false);
        final MyListSelectionListener selListener = new MyListSelectionListener();
        table.getSelectionModel().addListSelectionListener(selListener);
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                selListener.enabled = true;
            }

            public void focusLost(FocusEvent e) {
                selListener.enabled = true;
            }
        });
        table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                selListener.enabled = false;
                TableSelectionDelay.this.timer.stop();
            }

            public void mouseReleased(MouseEvent ev) {
                selListener.enabled = true;
                TableSelectionDelay.this.fireEvent();
                TableSelectionDelay.this.timer.stop();
            }
        });
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    private void fireEvent() {
        if (this.event != null) {
            this.listener.valueChanged(this.event);
        }
        this.event = null;
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        public boolean enabled = true;

        MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            TableSelectionDelay.this.event = event;
            if (this.enabled) {
                TableSelectionDelay.this.timer.restart();
            }
        }
    }
}

