/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import widex.utils.Utils;

public class TableColumnHeader
extends DefaultTableCellRenderer {
    private static TableColumnHeader s_orientedHeader = null;
    private static TableColumnHeader s_headerCenter = null;
    private static TableColumnHeader s_headerLeft = null;
    private static TableColumnHeader s_headerRight = null;
    static Border wrapperBorder = new CompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), new EmptyBorder(0, 5, 0, 5));
    Border border = null;

    public static TableColumnHeader getOrientedHeader() {
        if (s_orientedHeader == null) {
            s_orientedHeader = new TableColumnHeader();
        }
        TableColumnHeader.s_orientedHeader.border = wrapperBorder;
        s_orientedHeader.applyComponentOrientation(Utils.getOrientation());
        s_orientedHeader.setHorizontalAlignment(10);
        return s_orientedHeader;
    }

    public static TableColumnHeader getHeader(int alignment) {
        if (alignment == 2) {
            return s_headerLeft;
        }
        if (alignment == 4) {
            return s_headerRight;
        }
        if (alignment == 0) {
            return s_headerCenter;
        }
        throw new IllegalArgumentException("alignment must be either JLabel.LEFT, RIGHT or CENTER");
    }

    public TableColumnHeader() {
        this.border = UIManager.getBorder("TableHeader.cellBorder");
        this.setHorizontalAlignment(0);
    }

    public TableColumnHeader(int alignment) {
        this.applyComponentOrientation(Utils.getOrientation());
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(this.border);
        return this;
    }

    static {
        s_headerCenter = new TableColumnHeader();
        s_headerLeft = new TableColumnHeader();
        s_headerRight = new TableColumnHeader();
        TableColumnHeader.s_headerLeft.border = wrapperBorder;
        TableColumnHeader.s_headerRight.border = wrapperBorder;
        s_headerLeft.setHorizontalAlignment(2);
        s_headerRight.setHorizontalAlignment(4);
        s_headerCenter.setHorizontalAlignment(0);
    }
}

