/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import widex.parsers.MissingPropertyException;
import widex.parsers.PropertyParser;
import widex.utils.UIConstsParser;

public class PropertyBag {
    Object lastVal;
    HashMap pb;
    File m_sourceFile;

    public PropertyBag() {
        this.pb = new HashMap();
        this.m_sourceFile = null;
    }

    public PropertyBag(String fileName) throws IOException {
        this(new File(fileName));
    }

    public PropertyBag(File file) throws IOException {
        this.pb = new HashMap();
        this.m_sourceFile = null;
        this.m_sourceFile = file;
        this.pb.putAll(UIConstsParser.parse(file));
        this.lastVal = this.pb.remove("*new*");
    }

    public PropertyBag(URL url) throws IOException {
        this(url, null);
    }

    public PropertyBag(URL url, String charset) throws IOException {
        this.pb = new HashMap();
        this.m_sourceFile = null;
        this.pb.putAll(UIConstsParser.parse(url));
        this.lastVal = this.pb.remove("*new*");
    }

    public PropertyBag(String fileName, boolean ignoreOnFileNotFound) {
        this(new File(fileName), ignoreOnFileNotFound);
    }

    public PropertyBag(File file, boolean ignoreOnFileNotFound) {
        block2: {
            this.pb = new HashMap();
            this.m_sourceFile = null;
            this.m_sourceFile = file;
            try {
                this.pb.putAll(UIConstsParser.parse(file));
                this.lastVal = this.pb.remove("*new*");
            }
            catch (IOException exp) {
                this.lastVal = "0";
                if (ignoreOnFileNotFound) break block2;
                throw new RuntimeException("Exception caught while reading " + file, exp);
            }
        }
    }

    public boolean containsKey(String key) {
        return this.pb.get(key.trim().toLowerCase()) != null;
    }

    public int getInt(String key) {
        Object o = this.pb.get(key.trim().toLowerCase());
        if (o == null) {
            throw new MissingPropertyException("Property not found: " + key);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return Integer.parseInt(o.toString());
    }

    public int getInt(String key, int defVal) {
        try {
            return this.getInt(key.trim().toLowerCase());
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public boolean getBool(String key) {
        Object o = this.pb.get(key.trim().toLowerCase());
        if (o == null) {
            throw new MissingPropertyException("Property not found: " + key);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.valueOf(o.toString());
    }

    public boolean getBool(String key, boolean defVal) {
        try {
            return this.getBool(key.trim().toLowerCase());
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public long getLong(String key) {
        Object o = this.pb.get(key);
        if (o == null) {
            throw new MissingPropertyException("Property not found: " + key);
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        return Long.parseLong(o.toString());
    }

    public long getLong(String key, long defVal) {
        try {
            return this.getLong(key);
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public float getFloat(String key) {
        Object o = this.pb.get(key.trim().toLowerCase());
        if (o == null) {
            throw new MissingPropertyException("Property not found: " + key);
        }
        if (o instanceof Integer) {
            return ((Float)o).floatValue();
        }
        return Float.parseFloat(o.toString());
    }

    public float getFloat(String key, float defVal) {
        try {
            return this.getFloat(key.trim().toLowerCase());
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public String get(String key) {
        Object o = this.pb.get(key.trim().toLowerCase());
        if (o == null) {
            throw new MissingPropertyException("Property not found: " + key);
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public String get(String key, String defVal) {
        try {
            return this.get(key.trim().toLowerCase());
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public void put(String key, int val) {
        this.pb.put(key.trim().toLowerCase(), new Integer(val));
    }

    public void put(String key, boolean val) {
        this.pb.put(key.trim().toLowerCase(), new Boolean(val));
    }

    public void put(String key, long val) {
        this.pb.put(key.trim().toLowerCase(), new Long(val));
    }

    public void put(String key, Object val) {
        this.pb.put(key.trim().toLowerCase(), val);
    }

    public Object remove(String key) {
        return this.pb.remove(key.trim().toLowerCase());
    }

    public void clear() {
        this.pb.clear();
    }

    public String[] getKeys() {
        TreeSet x = new TreeSet(new StringComparator());
        x.addAll(this.pb.keySet());
        return x.toArray(new String[0]);
    }

    public String[] getValues() {
        TreeSet x = new TreeSet(new StringComparator());
        x.addAll(this.pb.values());
        return x.toArray(new String[0]);
    }

    public Map.Entry[] getEntries() {
        TreeMap x = new TreeMap(new StringComparator());
        x.putAll(this.pb);
        return x.entrySet().toArray(new Map.Entry[0]);
    }

    public boolean isEmpty() {
        return this.pb.isEmpty();
    }

    public String[] getStrings(String key) {
        key = key.trim().toLowerCase();
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (this.pb.containsKey(key + i)) {
            String str = this.get(key + i);
            strings.add(str);
            ++i;
        }
        String[] strs = strings.toArray(new String[0]);
        return strs;
    }

    public String printContent() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer text = new StringBuffer(lineSeparator);
        Map.Entry[] map = this.getEntries();
        for (int i = 0; i < map.length; ++i) {
            text.append(map[i].getKey()).append("=").append(map[i].getValue()).append(lineSeparator);
        }
        return text.toString();
    }

    public boolean save() {
        return this.save(this.m_sourceFile);
    }

    public boolean save(String fileName) {
        return this.save(new File(fileName), "UTF-8");
    }

    public boolean save(String fileName, String charset) {
        return this.save(new File(fileName), charset);
    }

    public boolean save(File file) {
        return this.save(file, "UTF-8");
    }

    public boolean save(File file, String charset) {
        String text = this.printContent();
        try {
            UIConstsParser.save(file, text, charset);
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static PropertyBag xml(String fileName) {
        return PropertyParser.parse(fileName);
    }

    class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

