/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

public class PCBinaryOutputStream {
    DataOutputStream file;

    public PCBinaryOutputStream(File f) throws IOException {
        this.file = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
    }

    public PCBinaryOutputStream(URL url) throws IOException {
        this.file = new DataOutputStream(new BufferedOutputStream(url.openConnection().getOutputStream()));
    }

    public void writeInt(int i) throws IOException {
        int j = i << 24 | (i & 0xFF00) << 8 | (i & 0xFF0000) >>> 8 | i >>> 24;
        this.file.writeInt(j);
    }

    public void writeShort(short i) throws IOException {
        int j = i << 8 | i >>> 8;
        this.file.writeShort((short)j);
    }

    public void writeByte(byte i) throws IOException {
        this.file.writeByte(i);
    }

    public void writeByteArray(byte[] b) throws IOException {
        this.file.write(b);
    }

    public long getFilePointer() throws IOException {
        return this.file.size();
    }

    public long size() throws IOException {
        return this.file.size();
    }

    public void close() throws IOException {
        this.file.flush();
        this.file.close();
        this.file = null;
    }

    public void finalize() {
        if (this.file != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

