/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

public class PCBinaryInputStream {
    DataInputStream file;

    public PCBinaryInputStream(File f) throws IOException {
        this.file = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
    }

    public PCBinaryInputStream(URL url) throws IOException {
        this.file = new DataInputStream(new BufferedInputStream(url.openConnection().getInputStream()));
    }

    public int readInt() throws IOException {
        int i = this.file.readInt();
        return i << 24 | (i & 0xFF00) << 8 | (i & 0xFF0000) >>> 8 | i >>> 24;
    }

    public short readShort() throws IOException {
        int i = this.file.readUnsignedShort();
        return (short)(i << 8 | i >>> 8);
    }

    public byte readByte() throws IOException {
        return (byte)this.file.readUnsignedByte();
    }

    public void readByteArray(byte[] b) throws IOException {
        this.file.readFully(b);
    }

    public void skip(long nbytes) throws IOException {
        this.file.skip(nbytes);
    }

    public void close() throws IOException {
        this.file.close();
        this.file = null;
    }

    public void finalize() {
        if (this.file != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

