/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JLabel;
import widex.utils.IAttentive;

public class MessageRouter {
    static Hashtable m_subscribers;
    static JLabel m_debugJLabel;

    protected MessageRouter() throws Exception {
        m_subscribers = new Hashtable();
    }

    public static void subscribe(Class messageClass, IAttentive subscriber) {
        if (m_subscribers.containsKey(messageClass)) {
            ArrayList messageSubscribers = (ArrayList)m_subscribers.get(messageClass);
            if (!messageSubscribers.contains(subscriber)) {
                messageSubscribers.add(subscriber);
            }
        } else {
            ArrayList<IAttentive> messageSubscribers = new ArrayList<IAttentive>();
            messageSubscribers.add(subscriber);
            m_subscribers.put(messageClass, messageSubscribers);
        }
    }

    public static void attend(Object subject) {
        MessageRouter.attendClients(subject, subject);
    }

    private static void attendClients(Object message, Object subject) {
        Class<?> messageClass = message.getClass();
        if (m_subscribers.containsKey(messageClass)) {
            ArrayList messageSubscribers = (ArrayList)m_subscribers.get(messageClass);
            for (int i = 0; i < messageSubscribers.size(); ++i) {
                IAttentive subscriber = (IAttentive)messageSubscribers.get(i);
                try {
                    subscriber.attend(subject);
                    continue;
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }
    }

    static {
        m_debugJLabel = null;
        m_subscribers = new Hashtable();
    }
}

