/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelectionDelay {
    private Timer timer;
    private JList list;
    private ListSelectionListener listener;
    private ListSelectionEvent event;

    public static ListSelectionDelay configureList(JList list, ListSelectionListener listener) {
        return new ListSelectionDelay(list, listener, 500);
    }

    public static ListSelectionDelay configureList(JList list, ListSelectionListener listener, int delay) {
        return new ListSelectionDelay(list, listener, delay);
    }

    public ListSelectionDelay(JList list, ListSelectionListener listener) {
        this(list, listener, 500);
    }

    public ListSelectionDelay(JList list, ListSelectionListener listener, int delay) {
        this.list = list;
        this.listener = listener;
        this.timer = new Timer(delay, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ListSelectionDelay.this.fireEvent();
            }
        });
        this.timer.setRepeats(false);
        final MyListSelectionListener selListener = new MyListSelectionListener();
        list.addListSelectionListener(selListener);
        list.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                selListener.enabled = true;
            }

            public void focusLost(FocusEvent e) {
                selListener.enabled = true;
            }
        });
        list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                selListener.enabled = false;
                ListSelectionDelay.this.timer.stop();
            }

            public void mouseReleased(MouseEvent ev) {
                selListener.enabled = true;
                ListSelectionDelay.this.fireEvent();
                ListSelectionDelay.this.timer.stop();
            }
        });
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    private void fireEvent() {
        if (this.event != null) {
            this.listener.valueChanged(this.event);
        }
        this.event = null;
    }

    public static void main2(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JList<String> x = new JList<String>(new File("C:\\").list());
        new ListSelectionDelay(x, new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JOptionPane.showMessageDialog(null, ((JList)e.getSource()).getSelectedValue());
            }
        }, 500);
        JFrame fr = new JFrame("Hello");
        fr.getContentPane().setLayout(new GridLayout(1, 1));
        fr.getContentPane().add(x);
        fr.setDefaultCloseOperation(3);
        fr.setBounds(200, 300, 300, 300);
        fr.show();
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        public boolean enabled = true;

        MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            ListSelectionDelay.this.event = event;
            if (this.enabled) {
                ListSelectionDelay.this.timer.restart();
            }
        }
    }
}

