/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static void extractZipToDirectory(InputStream inputStream, File directory) throws IOException {
        FileUtils.extractZipToDirectory(inputStream, directory, false);
    }

    public static void extractZipToDirectory(InputStream inputStream, File directory, boolean verbose) throws IOException {
        ZipEntry entry;
        if (directory == null) {
            directory = new File(System.getProperty("user.dir", ""));
        }
        directory.mkdirs();
        int BUFFER = 1024;
        SimpleDateFormat sdf = null;
        BufferedOutputStream dest = null;
        ZipInputStream zis = new ZipInputStream(inputStream);
        if (verbose) {
            sdf = new SimpleDateFormat("mm:ss");
            System.out.println("Starting Time : " + sdf.format(new Date()));
        }
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            if (verbose) {
                System.out.println("Extracting: " + directory + "/" + entry);
            }
            byte[] data = new byte[1024];
            File entryFile = new File(directory, entry.getName());
            String name = entry.getName().trim();
            if (entry.isDirectory() || entryFile.isDirectory() || name.endsWith("/") || name.endsWith("\\")) {
                entryFile.mkdirs();
                continue;
            }
            entryFile.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(entryFile);
            dest = new BufferedOutputStream(fos, 1024);
            while ((count = zis.read(data, 0, 1024)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zis.close();
        if (verbose) {
            System.out.println("Ending Time : " + sdf.format(new Date()));
        }
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.deleteFile(files[i]);
            }
        }
        file.delete();
    }

    public static void writeBytesToFile(byte[] fileBytes, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(fileBytes);
        fos.flush();
        fos.close();
    }
}

