/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import widex.utils.Gaps;
import widex.utils.Utils;

public class Dialogs {
    public static final String YES = UIManager.getString("OptionPane.yesButtonText");
    public static final String NO = UIManager.getString("OptionPane.noButtonText");
    public static final String OK = UIManager.getString("OptionPane.okButtonText");
    public static final String CANCEL = UIManager.getString("OptionPane.cancelButtonText");
    public static final String CLOSED = "CLOSED";
    public static final int OPTION_OK = 0;
    public static final int OPTION_OK_CANCEL = 1;
    public static final int OPTION_YES_NO = 2;
    public static final int OPTION_YES_NO_CANCEL = 3;
    public static final int TYPE_ERROR = 0;
    public static final int TYPE_INFORMATION = 1;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_QUESTION = 3;
    private static int HGAP = 5;
    static JButton defaultButton = null;

    public static String showYesNoDialog(Component comp, String prompt, String title) {
        return Dialogs.showYesNoDialog(comp, prompt, title, NO);
    }

    public static String showYesNoDialog(Component comp, String prompt, String title, String defVal) {
        return Dialogs.showDialog(comp, prompt, title, 2, 3, defVal);
    }

    public static String showYesNoCancelDialog(Component comp, String prompt, String title) {
        return Dialogs.showYesNoCancelDialog(comp, prompt, title, CANCEL);
    }

    public static String showYesNoCancelDialog(Component comp, String prompt, String title, String defVal) {
        return Dialogs.showDialog(comp, prompt, title, 3, 3, defVal);
    }

    public static String showOKCancelDialog(Component comp, String prompt, String title) {
        return Dialogs.showOKCancelDialog(comp, prompt, title, CANCEL);
    }

    public static String showOKCancelDialog(Component comp, String prompt, String title, String defVal) {
        return Dialogs.showDialog(comp, prompt, title, 1, 3, defVal);
    }

    public static String showOKDialog(Component comp, String prompt, String title) {
        return Dialogs.showDialog(comp, prompt, title, 0, 1, OK);
    }

    public static String showErrorDialog(Component comp, String prompt, String title) {
        return Dialogs.showDialog(comp, prompt, title, 0, 0, OK);
    }

    public static String showDialog(Component comp, String prompt, String title, int optionType, int messageType, String defVal) {
        DialogListener listener = new DialogListener();
        MessagePanel mainPanel = Dialogs.createMessagePanel(prompt, optionType, messageType, defVal, listener);
        mainPanel.setBorder(new EmptyBorder(12, 12, 11, 11));
        JDialog dialog = Dialogs.createDialog(comp, title, messageType, mainPanel);
        dialog.addWindowListener(listener);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        dialog.getRootPane().registerKeyboardAction(listener, stroke, 2);
        dialog.show();
        dialog.dispose();
        return listener.getAnswer();
    }

    public static MessagePanel createMessagePanel(String prompt, int optionType, int messageType, String defVal, ActionListener listener) {
        ButtonsPanel buttonsPanel = Dialogs.createButtonPanel(optionType, listener, defVal);
        JLabel promptLabel = new JLabel(prompt, Dialogs.getIconForType(messageType), 10);
        promptLabel.setIconTextGap(15);
        promptLabel.setAlignmentX(Utils.getAlignmentX());
        buttonsPanel.setAlignmentX(Utils.getAlignmentX());
        MessagePanel mainPanel = new MessagePanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(promptLabel);
        mainPanel.add(Gaps.v(17));
        mainPanel.add(buttonsPanel);
        mainPanel.setButtonsPanel(buttonsPanel);
        return mainPanel;
    }

    public static JDialog createDialog(Component comp, String title, int messageType, JPanel mainPanel) {
        boolean supportsWindowDecorations;
        Window window = Utils.windowForComponent(comp);
        JDialog dialog = null;
        if (window == null) {
            if (title == null) {
                title = "";
            }
            dialog = new JDialog((Frame)null, title, true);
        } else if (window instanceof Frame) {
            Frame frame = (Frame)window;
            if (title == null) {
                title = frame.getTitle();
            }
            dialog = new JDialog(frame, title, true);
        } else {
            JDialog dlg = (JDialog)window;
            if (title == null) {
                title = dlg.getTitle();
            }
            dialog = new JDialog(dlg, title, true);
        }
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            int type = -1;
            if (messageType == 0) {
                type = 4;
            } else if (messageType == 1) {
                type = 3;
            } else if (messageType == 3) {
                type = 7;
            } else if (messageType == -1) {
                type = 2;
            }
            dialog.getRootPane().setWindowDecorationStyle(type);
        }
        if (mainPanel != null) {
            dialog.getContentPane().setLayout(new BorderLayout(5, 5));
            dialog.getContentPane().add(mainPanel);
        }
        dialog.applyComponentOrientation(Utils.getOrientation());
        dialog.pack();
        Dimension size = dialog.getSize();
        size.width = Math.max(200, size.width);
        dialog.setSize(size);
        dialog.setLocationRelativeTo(window);
        dialog.setDefaultCloseOperation(0);
        dialog.setResizable(false);
        return dialog;
    }

    static ButtonsPanel createButtonPanel(int type, ActionListener listener, String defVal) {
        ButtonsPanel panel = new ButtonsPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        panel.add(Box.createHorizontalGlue());
        panel.setComponentOrientation(Utils.getOrientation());
        if (type == 3) {
            JButton b1 = Dialogs.createButton(YES, listener);
            JButton b2 = Dialogs.createButton(NO, listener);
            JButton b3 = Dialogs.createButton(CANCEL, listener);
            panel.add(b1);
            panel.add(Gaps.h(HGAP));
            panel.add(b2);
            panel.add(Gaps.h(HGAP));
            panel.add(b3);
            Dialogs.updateButtonsWidths(b1, b2, b3);
        } else if (type == 2) {
            JButton b1 = Dialogs.createButton(YES, listener);
            JButton b2 = Dialogs.createButton(NO, listener);
            panel.add(b1);
            panel.add(Gaps.h(HGAP));
            panel.add(b2);
            Dialogs.updateButtonsWidths(b1, b2);
        } else if (type == 1) {
            JButton b1 = Dialogs.createButton(OK, listener);
            JButton b2 = Dialogs.createButton(CANCEL, listener);
            panel.add(b1);
            panel.add(Gaps.h(HGAP));
            panel.add(b2);
            Dialogs.updateButtonsWidths(b1, b2);
        } else if (type == 0) {
            panel.add(Dialogs.createButton(OK, listener));
        }
        Dialogs.determineDefault(panel, defVal);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private static void determineDefault(Container c, String defVal) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            JButton b;
            if (!(c.getComponent(i) instanceof JButton) || (b = (JButton)c.getComponent(i)).getActionCommand() != defVal) continue;
            defaultButton = b;
        }
    }

    public static JButton createButton(String text, ActionListener listener) {
        JButton cmd = new JButton(text);
        cmd.setActionCommand(text);
        cmd.addActionListener(listener);
        cmd.setDefaultCapable(true);
        FocusKeyListener l = new FocusKeyListener();
        cmd.addKeyListener(l);
        cmd.addFocusListener(l);
        return cmd;
    }

    protected static Icon getIconForType(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    private static void updateButtonsWidths(JButton b1, JButton b2) {
        JButton[] bs = new JButton[]{b1, b2};
        Dialogs.updateButtonsWidths(bs);
    }

    private static void updateButtonsWidths(JButton b1, JButton b2, JButton b3) {
        JButton[] bs = new JButton[]{b1, b2, b3};
        Dialogs.updateButtonsWidths(bs);
    }

    private static void updateButtonsWidths(JButton[] buttons) {
        int i;
        int max = -1;
        for (i = 0; i < buttons.length; ++i) {
            int w = buttons[i].getPreferredSize().width;
            if (max >= w) continue;
            max = w;
        }
        for (i = 0; i < buttons.length; ++i) {
            Utils.fixCompWidth(buttons[i], max);
        }
    }

    public static DefaultFocusHandler createDefaultFocusHandler(JButton b1, JButton b2, JButton defaultButton) {
        return Dialogs.createDefaultFocusHandler(new JButton[]{b1, b2}, defaultButton);
    }

    public static DefaultFocusHandler createDefaultFocusHandler(JButton b1, JButton b2, JButton b3, JButton defaultButton) {
        return Dialogs.createDefaultFocusHandler(new JButton[]{b1, b2, b3}, defaultButton);
    }

    public static DefaultFocusHandler createDefaultFocusHandler(JButton[] buttons, JButton defaultButton) {
        return new DefaultFocusHandler(buttons, defaultButton);
    }

    static class DefaultFocusHandler
    implements FocusListener {
        ArrayList bs = null;
        JButton defaultButton = null;

        public DefaultFocusHandler(JButton[] buttons, JButton defaultButton) {
            this.defaultButton = defaultButton;
            this.bs = new ArrayList<JButton>(Arrays.asList(buttons));
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i].addFocusListener(this);
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (this.bs.contains(e.getOppositeComponent())) {
                return;
            }
            if (this.defaultButton != null) {
                this.defaultButton.getRootPane().setDefaultButton(this.defaultButton);
            } else if (this.bs.size() > 0) {
                ((JButton)this.bs.get(0)).getRootPane().setDefaultButton(null);
            }
        }
    }

    public static class FocusKeyListener
    implements KeyListener,
    FocusListener {
        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            Component c = (Component)e.getSource();
            boolean isLTR = c.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT;
            if (e.getKeyCode() == 39) {
                if (isLTR) {
                    FocusManager.getCurrentManager().focusNextComponent(c);
                } else {
                    FocusManager.getCurrentManager().focusPreviousComponent(c);
                }
            } else if (e.getKeyCode() == 37) {
                if (isLTR) {
                    FocusManager.getCurrentManager().focusPreviousComponent(c);
                } else {
                    FocusManager.getCurrentManager().focusNextComponent(c);
                }
            }
        }

        public void focusGained(FocusEvent e) {
            JButton b = (JButton)e.getSource();
            b.getRootPane().setDefaultButton(b);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    public static class ButtonsPanel
    extends JPanel {
        public JButton getButton(String buttonCommand) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component comp = this.getComponent(i);
                if (!(comp instanceof JButton) || ((JButton)comp).getActionCommand() != buttonCommand) continue;
                return (JButton)comp;
            }
            return null;
        }
    }

    public static class MessagePanel
    extends JPanel {
        private ButtonsPanel m_buttonsPanel = null;

        public ButtonsPanel getButtonsPanel() {
            return this.m_buttonsPanel;
        }

        public void setButtonsPanel(ButtonsPanel buttonsPanel) {
            this.m_buttonsPanel = buttonsPanel;
        }
    }

    static class DialogListener
    extends WindowAdapter
    implements ActionListener {
        String m_answer;

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JRootPane) {
                this.m_answer = Dialogs.CLOSED;
                SwingUtilities.windowForComponent((JRootPane)e.getSource()).setVisible(false);
                return;
            }
            JButton button = (JButton)e.getSource();
            this.m_answer = button.getActionCommand();
            SwingUtilities.windowForComponent(button).setVisible(false);
        }

        public void windowClosing(WindowEvent e) {
            this.m_answer = Dialogs.CLOSED;
            e.getWindow().setVisible(false);
        }

        public void windowOpened(WindowEvent e) {
            defaultButton.requestFocus();
        }

        public String getAnswer() {
            return this.m_answer;
        }
    }
}

