/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class CardPanel
extends JPanel {
    String currentCardName = null;
    Component currentCard = null;

    public String getCurrentCardName() {
        return this.currentCardName;
    }

    public Component getCurrentCard() {
        return this.currentCard;
    }

    public CardPanel() {
        this.setLayout(new Layout());
    }

    private int getVisibleChildIndex() {
        int nChildren = this.getComponentCount();
        for (int i = 0; i < nChildren; ++i) {
            Component child = this.getComponent(i);
            if (!child.isVisible()) continue;
            return i;
        }
        return -1;
    }

    public Component showCard(Component card) {
        if (card.getParent() != this) {
            this.add(card);
        }
        if (card.equals(this.currentCard)) {
            return this.currentCard;
        }
        int index = this.getVisibleChildIndex();
        if (index != -1) {
            this.getComponent(index).setVisible(false);
        }
        this.currentCard = card;
        this.currentCardName = card.getName();
        card.setVisible(true);
        this.revalidate();
        this.repaint();
        return card;
    }

    public Component showCard(String name) {
        int nChildren = this.getComponentCount();
        for (int i = 0; i < nChildren; ++i) {
            Component child = this.getComponent(i);
            if (!child.getName().equals(name)) continue;
            return this.showCard(child);
        }
        return null;
    }

    public Component showNextCard() {
        if (this.getComponentCount() <= 0) {
            return null;
        }
        int index = this.getVisibleChildIndex();
        if (index == -1) {
            return this.showCard(this.getComponent(0));
        }
        if (index == this.getComponentCount() - 1) {
            return this.getCurrentCard();
        }
        return this.showCard(this.getComponent(index + 1));
    }

    public Component showPreviousCard() {
        if (this.getComponentCount() <= 0) {
            return null;
        }
        int index = this.getVisibleChildIndex();
        if (index == -1) {
            return this.showCard(this.getComponent(0));
        }
        if (index == 0) {
            return this.getCurrentCard();
        }
        return this.showCard(this.getComponent(index - 1));
    }

    public Component showFirstCard() {
        if (this.getComponentCount() <= 0) {
            return null;
        }
        return this.showCard(this.getComponent(0));
    }

    public Component showLastCard() {
        if (this.getComponentCount() <= 0) {
            return null;
        }
        return this.showCard(this.getComponent(this.getComponentCount() - 1));
    }

    class Layout
    implements LayoutManager {
        Layout() {
        }

        public void addLayoutComponent(String name, Component child) {
            if (name != null) {
                child.setName(name);
            }
            child.setVisible(child.getParent().getComponentCount() == 1);
            if (child.getParent().getComponentCount() == 1) {
                CardPanel.this.currentCard = child;
                CardPanel.this.currentCardName = child.getName();
            }
        }

        public void removeLayoutComponent(Component child) {
            Container parent;
            if (child.isVisible() && (parent = child.getParent()).getComponentCount() > 0) {
                parent.getComponent(0).setVisible(true);
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            for (int i = 0; i < nChildren; ++i) {
                Dimension d = parent.getComponent(i).getPreferredSize();
                if (d.width > width) {
                    width = d.width;
                }
                if (d.height <= height) continue;
                height = d.height;
            }
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            for (int i = 0; i < nChildren; ++i) {
                Dimension d = parent.getComponent(i).getMinimumSize();
                if (d.width > width) {
                    width = d.width;
                }
                if (d.height <= height) continue;
                height = d.height;
            }
            return new Dimension(0, 0);
        }

        public void layoutContainer(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            for (int i = 0; i < nChildren; ++i) {
                Component child = parent.getComponent(i);
                if (!child.isVisible()) continue;
                Rectangle r = parent.getBounds();
                int width = r.width - insets.left + insets.right;
                int height = r.height - insets.top + insets.bottom;
                child.setBounds(insets.left, insets.top, width, height);
                break;
            }
        }
    }
}

