/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import widex.utils.PCBinaryInputStream;
import widex.utils.PCBinaryOutputStream;

public class BMP {
    private Image image;
    private BmpFileheader bmp_fileheader = new BmpFileheader();
    private BmpInfoHeader bmp_infoheader = new BmpInfoHeader();
    private BmpPalette bmp_palette;
    private int width;
    private int height;

    public BMP(String fileName) {
        this(new File(fileName));
    }

    public BMP(File f) {
        PCBinaryInputStream file = null;
        try {
            file = new PCBinaryInputStream(f);
            this.read(file);
            try {
                file.close();
            }
            catch (Exception exp) {}
        }
        catch (IOException e) {
            System.err.println(e);
            try {
                file.close();
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
    }

    public BMP(URL url) {
        PCBinaryInputStream file = null;
        try {
            file = new PCBinaryInputStream(url);
            this.read(file);
            try {
                file.close();
            }
            catch (Exception exp) {}
        }
        catch (IOException e) {
            System.err.println(e);
            try {
                file.close();
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
    }

    public BMP(Image image) {
        this.image = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.bmp_infoheader.biWidth = (short)this.width;
        this.bmp_infoheader.biHeight = (short)this.height;
        this.bmp_infoheader.biBitCount = (short)24;
        this.bmp_infoheader.biClrUsed = 0;
    }

    public Image getImage() {
        return this.image;
    }

    public void write(File f) {
        try {
            PCBinaryOutputStream file = new PCBinaryOutputStream(f);
            this.write(file);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void write(URL url) {
        try {
            PCBinaryOutputStream file = new PCBinaryOutputStream(url);
            this.write(file);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void write(PCBinaryOutputStream file) {
        try {
            byte[] bitmap;
            int[] rawData = new int[this.width * this.height];
            PixelGrabber grabber = new PixelGrabber(this.image, 0, 0, this.width, this.height, rawData, 0, this.width);
            this.bmp_palette = new BmpPalette(grabber.getColorModel());
            try {
                grabber.grabPixels();
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
            ColorModel model = grabber.getColorModel();
            this.bmp_fileheader.bfOffBits = this.bmp_fileheader.getSize() + this.bmp_infoheader.getSize() + this.bmp_palette.getSize();
            int x = 0;
            int y = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            int w = this.width * 3;
            int h = this.height - 1;
            if (w % 4 != 0) {
                w += 4 - w % 4;
            }
            if (model instanceof IndexColorModel) {
                bitmap = new byte[this.width * this.bmp_infoheader.biHeight];
                for (y = h; y >= 0; --y) {
                    i = (h - y) * this.width;
                    j = y * this.width;
                    for (x = 0; x < this.width; ++x) {
                        bitmap[j++] = (byte)rawData[i + x];
                    }
                }
                this.bmp_fileheader.bfSize = this.bmp_fileheader.bfOffBits + this.width * this.bmp_infoheader.biHeight;
            } else {
                bitmap = new byte[w * this.bmp_infoheader.biHeight];
                for (y = 0; y < this.height; ++y) {
                    i = (h - y) * this.width;
                    j = y * w;
                    for (x = 0; x < this.width; ++x) {
                        k = i + x;
                        bitmap[j++] = (byte)(model.getBlue(rawData[k]) & 0xFF);
                        bitmap[j++] = (byte)(model.getGreen(rawData[k]) & 0xFF);
                        bitmap[j++] = (byte)(model.getRed(rawData[k]) & 0xFF);
                    }
                }
            }
            rawData = null;
            this.bmp_fileheader.bfSize = this.bmp_fileheader.bfOffBits + w * this.bmp_infoheader.biHeight;
            this.bmp_fileheader.write(file);
            this.bmp_infoheader.write(file);
            this.bmp_palette.write(file);
            file.writeByteArray(bitmap);
            bitmap = null;
            file.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void read(PCBinaryInputStream file) {
        int coloursUsed = 0;
        int scanlineSize = 0;
        int bitplaneSize = 0;
        byte[] rawData = null;
        try {
            this.bmp_fileheader.read(file);
            this.bmp_infoheader.read(file);
            if (this.bmp_infoheader.biClrUsed != 0) {
                coloursUsed = this.bmp_infoheader.biClrUsed;
            } else if (this.bmp_infoheader.biBitCount < 16) {
                coloursUsed = 1 << this.bmp_infoheader.biBitCount;
            }
            this.bmp_palette = new BmpPalette(coloursUsed);
            this.bmp_palette.read(file);
            long skip = this.bmp_fileheader.bfOffBits - (this.bmp_fileheader.getSize() + this.bmp_infoheader.getSize() + this.bmp_palette.getSize());
            if (skip > 0L) {
                file.skip(skip);
            }
            scanlineSize = (this.bmp_infoheader.biWidth * this.bmp_infoheader.biBitCount + 31) / 32 * 4;
            bitplaneSize = this.bmp_infoheader.biSizeImage != 0 ? this.bmp_infoheader.biSizeImage : scanlineSize * this.bmp_infoheader.biHeight;
            rawData = new byte[bitplaneSize];
            file.readByteArray(rawData);
            file.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        if (rawData != null) {
            this.image = this.bmp_infoheader.biBitCount > 8 ? this.unpack24(rawData, scanlineSize) : this.unpack08(rawData, scanlineSize);
        }
        rawData = null;
    }

    Image unpack24(byte[] rawData, int scanlineSize) {
        int b = 0;
        int k = 0;
        int x = 0;
        int y = 0;
        int[] data = new int[this.bmp_infoheader.biWidth * this.bmp_infoheader.biHeight];
        try {
            for (y = 0; y < this.bmp_infoheader.biHeight; ++y) {
                b = (this.bmp_infoheader.biHeight - 1 - y) * this.bmp_infoheader.biWidth;
                k = y * scanlineSize;
                for (x = 0; x < this.bmp_infoheader.biWidth; ++x) {
                    data[x + b] = 0xFF000000 | rawData[k++] & 0xFF | (rawData[k++] & 0xFF) << 8 | (rawData[k++] & 0xFF) << 16;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.bmp_infoheader.biWidth, this.bmp_infoheader.biHeight, ColorModel.getRGBdefault(), data, 0, this.bmp_infoheader.biWidth));
    }

    Image unpack08(byte[] rawData, int scanlineSize) {
        int b = 0;
        int k = 0;
        int i = 0;
        int x = 0;
        int y = 0;
        byte[] data = new byte[this.bmp_infoheader.biWidth * this.bmp_infoheader.biHeight];
        try {
            if (this.bmp_infoheader.biBitCount == 1) {
                for (y = 0; y < this.bmp_infoheader.biHeight; ++y) {
                    b = (this.bmp_infoheader.biHeight - 1 - y) * this.bmp_infoheader.biWidth;
                    k = y * scanlineSize;
                    for (x = 0; x < this.bmp_infoheader.biWidth - 8; x += 8) {
                        data[b + x + 7] = (byte)(rawData[k] & 1);
                        data[b + x + 6] = (byte)(rawData[k] >>> 1 & 1);
                        data[b + x + 5] = (byte)(rawData[k] >>> 2 & 1);
                        data[b + x + 4] = (byte)(rawData[k] >>> 3 & 1);
                        data[b + x + 3] = (byte)(rawData[k] >>> 4 & 1);
                        data[b + x + 2] = (byte)(rawData[k] >>> 5 & 1);
                        data[b + x + 1] = (byte)(rawData[k] >>> 6 & 1);
                        data[b + x] = (byte)(rawData[k] >>> 7 & 1);
                        ++k;
                    }
                    for (i = 7; i >= 0; --i) {
                        if (i + x >= this.bmp_infoheader.biWidth) continue;
                        data[b + x + i] = (byte)(rawData[k] >>> 7 - i & 1);
                    }
                }
            } else if (this.bmp_infoheader.biBitCount == 4) {
                for (y = 0; y < this.bmp_infoheader.biHeight; ++y) {
                    b = (this.bmp_infoheader.biHeight - 1 - y) * this.bmp_infoheader.biWidth;
                    k = y * scanlineSize;
                    for (x = 0; x < this.bmp_infoheader.biWidth - 2; x += 2) {
                        data[b + x] = (byte)(rawData[k] >> 4 & 0xF);
                        data[b + x + 1] = (byte)(rawData[k] & 0xF);
                        ++k;
                    }
                    for (i = 1; i >= 0; --i) {
                        if (i + x >= this.bmp_infoheader.biWidth) continue;
                        data[b + x + i] = (byte)(rawData[k] >>> (1 - i << 2) & 0xF);
                    }
                }
            } else {
                for (y = 0; y < this.bmp_infoheader.biHeight; ++y) {
                    b = (this.bmp_infoheader.biHeight - 1 - y) * this.bmp_infoheader.biWidth;
                    k = y * scanlineSize;
                    for (x = 0; x < this.bmp_infoheader.biWidth; ++x) {
                        data[x + b] = (byte)(rawData[k++] & 0xFF);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        IndexColorModel colourModel = new IndexColorModel((int)this.bmp_infoheader.biBitCount, this.bmp_palette.length, this.bmp_palette.r, this.bmp_palette.g, this.bmp_palette.b);
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.bmp_infoheader.biWidth, this.bmp_infoheader.biHeight, (ColorModel)colourModel, data, 0, this.bmp_infoheader.biWidth));
    }

    class BmpPalette {
        int length;
        byte[] r;
        byte[] g;
        byte[] b;

        public BmpPalette(int length) {
            this.length = length;
            this.r = new byte[length];
            this.g = new byte[length];
            this.b = new byte[length];
        }

        int getSize() {
            return this.length * 4;
        }

        public BmpPalette(ColorModel colourModel) {
            if (colourModel instanceof IndexColorModel) {
                IndexColorModel indexColourModel = (IndexColorModel)colourModel;
                this.length = indexColourModel.getMapSize();
                this.r = new byte[this.length];
                indexColourModel.getReds(this.r);
                this.g = new byte[this.length];
                indexColourModel.getGreens(this.g);
                this.b = new byte[this.length];
                indexColourModel.getBlues(this.b);
                ((BMP)BMP.this).bmp_infoheader.biBitCount = (short)indexColourModel.getPixelSize();
                ((BMP)BMP.this).bmp_infoheader.biClrUsed = this.length;
            }
        }

        void read(PCBinaryInputStream file) {
            if (this.length > 0) {
                try {
                    for (int i = 0; i < this.length; ++i) {
                        this.b[i] = file.readByte();
                        this.g[i] = file.readByte();
                        this.r[i] = file.readByte();
                        byte reserved = file.readByte();
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }

        void write(PCBinaryOutputStream file) {
            if (this.length > 0) {
                try {
                    byte reserved = 0;
                    for (int i = 0; i < this.length; ++i) {
                        file.writeByte(this.b[i]);
                        file.writeByte(this.g[i]);
                        file.writeByte(this.r[i]);
                        file.writeByte(reserved);
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
    }

    class BmpFileheader {
        byte[] bfType = new byte[]{66, 77};
        int bfSize;
        short bfReserved1 = 0;
        short bfReserved2 = 0;
        int bfOffBits;

        BmpFileheader() {
        }

        int getSize() {
            return 14;
        }

        void read(PCBinaryInputStream file) {
            try {
                this.bfType[0] = file.readByte();
                this.bfType[1] = file.readByte();
                if (this.bfType[0] != 66 && this.bfType[1] != 77) {
                    throw new IOException("Invalid BMP 3.0 File.");
                }
                this.bfSize = file.readInt();
                this.bfReserved1 = file.readShort();
                this.bfReserved2 = file.readShort();
                this.bfOffBits = file.readInt();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }

        void write(PCBinaryOutputStream file) {
            try {
                file.writeByte(this.bfType[0]);
                file.writeByte(this.bfType[1]);
                file.writeInt(this.bfSize);
                file.writeShort(this.bfReserved1);
                file.writeShort(this.bfReserved2);
                file.writeInt(this.bfOffBits);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    class BmpInfoHeader {
        int biSize = 40;
        int biWidth;
        int biHeight;
        short biPlanes = 1;
        short biBitCount;
        int biCompression;
        int biSizeImage;
        int biXPelsPerMeter;
        int biYPelsPerMeter;
        int biClrUsed;
        int biClrImportant;

        BmpInfoHeader() {
        }

        int getSize() {
            return this.biSize;
        }

        void read(PCBinaryInputStream file) {
            try {
                this.biSize = file.readInt();
                if (this.biSize == 12) {
                    this.biWidth = file.readShort();
                    this.biHeight = file.readShort();
                    this.biPlanes = file.readShort();
                    this.biBitCount = file.readShort();
                } else {
                    this.biWidth = file.readInt();
                    this.biHeight = file.readInt();
                    this.biPlanes = file.readShort();
                    this.biBitCount = file.readShort();
                    this.biCompression = file.readInt();
                    this.biSizeImage = file.readInt();
                    this.biXPelsPerMeter = file.readInt();
                    this.biYPelsPerMeter = file.readInt();
                    this.biClrUsed = file.readInt();
                    this.biClrImportant = file.readInt();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
            if (this.biSizeImage == 0) {
                this.biSizeImage = (this.biWidth * this.biBitCount + 31 >> 5 << 2) * this.biHeight;
            }
            if (this.biClrUsed == 0 && this.biBitCount < 16) {
                this.biClrUsed = 1 << this.biBitCount;
            }
        }

        void write(PCBinaryOutputStream file) {
            try {
                file.writeInt(this.biSize);
                if (this.biSize == 12) {
                    file.writeShort((short)this.biWidth);
                    file.writeShort((short)this.biHeight);
                    file.writeShort(this.biPlanes);
                    file.writeShort(this.biBitCount);
                } else {
                    file.writeInt(this.biWidth);
                    file.writeInt(this.biHeight);
                    file.writeShort(this.biPlanes);
                    file.writeShort(this.biBitCount);
                    file.writeInt(this.biCompression);
                    file.writeInt(this.biSizeImage);
                    file.writeInt(this.biXPelsPerMeter);
                    file.writeInt(this.biYPelsPerMeter);
                    file.writeInt(this.biClrUsed);
                    file.writeInt(this.biClrImportant);
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }
}

