/*
 * Decompiled with CFR 0.152.
 */
package widex.utils;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import sun.security.action.GetPropertyAction;

public class AppLog {
    public static AppLog shared = null;
    public static Logger logger = null;
    protected Logger appLogger;
    protected SimpleFormatter2 m_fileFormatter;
    protected Formatter2 m_consoleFormatter;

    public static void initShared(String loggerName, String logFileName) {
        shared = new AppLog(loggerName, logFileName);
        logger = shared.getLogger();
    }

    public SimpleFormatter2 getFileFormatter() {
        return this.m_fileFormatter;
    }

    public Formatter2 getConsoleFormatter() {
        return this.m_consoleFormatter;
    }

    public static void severe(String msg, Throwable exp) {
        if (logger != null) {
            logger.log(Level.SEVERE, msg, exp);
        }
    }

    public AppLog(String loggerName, String logFileName) {
        this(loggerName, new File(logFileName));
    }

    public AppLog(String loggerName, File logFile) {
        try {
            logFile.getParentFile().mkdirs();
            String logFileName = logFile.getAbsolutePath();
            this.appLogger = Logger.getLogger(logFileName);
            this.appLogger.setLevel(Level.ALL);
            this.appLogger.setUseParentHandlers(false);
            FileHandler fileHandler = new FileHandler(logFileName, false);
            fileHandler.setEncoding("UTF-8");
            this.m_fileFormatter = new SimpleFormatter2();
            fileHandler.setFormatter(this.m_fileFormatter);
            this.appLogger.addHandler(fileHandler);
            ConsoleHandler2 consoleHandler = new ConsoleHandler2();
            consoleHandler.setEncoding("UTF-8");
            this.m_consoleFormatter = new Formatter2();
            consoleHandler.setFormatter(this.m_consoleFormatter);
            this.appLogger.addHandler(consoleHandler);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public Logger getLogger() {
        return this.appLogger;
    }

    class Formatter2
    extends Formatter {
        boolean includeTimeStamp = false;
        Date dat = new Date();
        private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

        Formatter2() {
        }

        public String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            if (this.includeTimeStamp) {
                this.dat.setTime(record.getMillis());
                SimpleDateFormat x = new SimpleDateFormat("dd/MM/yyyy  HH:mm:ss");
                sb.append(x.format(this.dat));
            }
            sb.append(record.getMessage()).append(this.lineSeparator);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                    sb.append(this.lineSeparator);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sb.toString();
        }

        public boolean getIncludeTimeStamp() {
            return this.includeTimeStamp;
        }

        public void setIncludeTimeStamp(boolean includeTimeStamp) {
            this.includeTimeStamp = includeTimeStamp;
        }
    }

    public class ConsoleHandler2
    extends ConsoleHandler {
        boolean includeTimeStamp = false;

        protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
            super.setOutputStream(System.out);
        }

        public boolean isLoggable(LogRecord record) {
            return true;
        }
    }

    public class SimpleFormatter2
    extends SimpleFormatter {
        boolean includeTimeStamp = false;
        Date dat = new Date();
        private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        private String[] spaces = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        "};

        public synchronized String format(LogRecord record) {
            String message = this.formatMessage(record);
            StringBuffer sb = new StringBuffer();
            if (this.includeTimeStamp) {
                this.dat.setTime(record.getMillis());
                SimpleDateFormat x = new SimpleDateFormat("dd/MM/yyyy', 'HH:mm:ss', '");
                sb.append(x.format(this.dat));
            }
            String levelName = record.getLevel().getLocalizedName();
            sb.append(levelName);
            try {
                sb.append(this.spaces[6 - levelName.length()]);
            }
            catch (Exception exp) {
                // empty catch block
            }
            sb.append(": ");
            sb.append(message);
            sb.append(this.lineSeparator);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                    sb.append(this.lineSeparator);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return sb.toString();
        }

        public boolean getIncludeTimeStamp() {
            return this.includeTimeStamp;
        }

        public void setIncludeTimeStamp(boolean includeTimeStamp) {
            this.includeTimeStamp = includeTimeStamp;
        }
    }
}

