/*
 * Decompiled with CFR 0.152.
 */
package widex.parsers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ParseUtils {
    public static final NodeList EMPTY_NODE_LIST = new NodeList(){

        public int getLength() {
            return 0;
        }

        public Node item(int index) {
            return null;
        }
    };
    static /* synthetic */ Class class$widex$parsers$ParseUtils;

    public static Document getDocument(String fileName) {
        URL url = (class$widex$parsers$ParseUtils == null ? (class$widex$parsers$ParseUtils = ParseUtils.class$("widex.parsers.ParseUtils")) : class$widex$parsers$ParseUtils).getClassLoader().getResource(fileName);
        return ParseUtils.getDocument(url);
    }

    public static Document getDocument(File file) {
        try {
            return ParseUtils.getDocument(file.toURL());
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static Document getDocument(URL url) {
        try {
            return ParseUtils.getDocumentExp(url);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static Document getDocumentExp(URL url) throws Exception {
        InputStream in = null;
        try {
            Document doc;
            in = url.openStream();
            Document document = doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            return document;
        }
        catch (Exception exp) {
            throw exp;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exp2) {}
        }
    }

    public static Element getDocumentElement(String fileName) {
        URL url = (class$widex$parsers$ParseUtils == null ? (class$widex$parsers$ParseUtils = ParseUtils.class$("widex.parsers.ParseUtils")) : class$widex$parsers$ParseUtils).getClassLoader().getResource(fileName);
        return ParseUtils.getDocumentElement(url);
    }

    public static Element getDocumentElement(File file) {
        try {
            return ParseUtils.getDocumentElement(file.toURL());
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static Element getDocumentElement(URL url) {
        try {
            return ParseUtils.getDocumentExp(url).getDocumentElement();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static Element getDocumentElementExp(File file) throws Exception {
        return ParseUtils.getDocumentExp(file.toURL()).getDocumentElement();
    }

    public static Element getDocumentElementExp(URL url) throws Exception {
        return ParseUtils.getDocumentExp(url).getDocumentElement();
    }

    public static Document getDocumentFromString(String plainXML) {
        try {
            StringReader reader = new StringReader(plainXML);
            InputSource source = new InputSource(reader);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            reader.close();
            return doc;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static Element getDocumentElementFromString(String plainXML) {
        Document doc = ParseUtils.getDocumentFromString(plainXML);
        if (doc != null) {
            return doc.getDocumentElement();
        }
        return null;
    }

    public static String getTag(Element root, String tag, String defVal) {
        try {
            return root.getElementsByTagName(tag.trim()).item(0).getFirstChild().getNodeValue();
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public static String getTag(Element root, String tag) {
        if (root == null) {
            throw new NullPointerException("XML-Element  Cannot be null");
        }
        if (tag == null) {
            throw new NullPointerException("XML-Tag-Name Cannot be null");
        }
        NodeList list = root.getElementsByTagName(tag.trim());
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0).getFirstChild().getNodeValue();
    }

    public static int getTagInt(Element root, String tag) {
        if (root == null) {
            throw new NullPointerException("XML-Element  Cannot be null");
        }
        if (tag == null) {
            throw new NullPointerException("XML-Tag-Name Cannot be null");
        }
        NodeList list = root.getElementsByTagName(tag.trim());
        if (list.getLength() == 0) {
            throw new RuntimeException("Tag with name: " + tag + " was not found in the XML-Element");
        }
        return Integer.parseInt(list.item(0).getFirstChild().getNodeValue());
    }

    public static int getTagInt(Element root, String tag, int defVal) {
        try {
            return Integer.parseInt(root.getElementsByTagName(tag.trim()).item(0).getFirstChild().getNodeValue());
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public static long getTagLong(Element root, String tag) {
        if (root == null) {
            throw new NullPointerException("XML-Element  Cannot be null");
        }
        if (tag == null) {
            throw new NullPointerException("XML-Tag-Name Cannot be null");
        }
        NodeList list = root.getElementsByTagName(tag.trim());
        if (list.getLength() == 0) {
            throw new RuntimeException("Tag with name: " + tag + " was not found in the XML-Element");
        }
        return Long.parseLong(list.item(0).getFirstChild().getNodeValue());
    }

    public static long getTagLong(Element root, String tag, long defVal) {
        try {
            return Long.parseLong(root.getElementsByTagName(tag.trim()).item(0).getFirstChild().getNodeValue());
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public static boolean getTagBool(Element root, String tag) {
        if (root == null) {
            throw new NullPointerException("XML-Element  Cannot be null");
        }
        if (tag == null) {
            throw new NullPointerException("XML-Tag-Name Cannot be null");
        }
        NodeList list = root.getElementsByTagName(tag.trim());
        if (list.getLength() == 0) {
            throw new RuntimeException("Tag with name: " + tag + " was not found in the XML-Element");
        }
        return Boolean.valueOf(list.item(0).getFirstChild().getNodeValue());
    }

    public static boolean getTagBool(Element root, String tag, boolean defVal) {
        try {
            return Boolean.valueOf(root.getElementsByTagName(tag.trim()).item(0).getFirstChild().getNodeValue());
        }
        catch (Exception exp) {
            return defVal;
        }
    }

    public static Element getElement(Element root, String tag) {
        try {
            return (Element)root.getElementsByTagName(tag.trim()).item(0);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static String join(String directory, String fileName) {
        return directory + (directory.endsWith("/") ? "" : "/") + fileName;
    }

    public static void writeDocument(Document doc, String fileName) throws Exception {
        ParseUtils.writeDocument(doc, new File(fileName));
    }

    public static void writeDocument(Document doc, File file) throws Exception {
        doc.normalize();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-16");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(source, result);
    }

    public static Document createNewDocument() {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            return doc;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static Element createTag(Document doc, String name, String value) {
        name = name.trim();
        value = value.trim();
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode(value));
        return elem;
    }

    public static Element createTag(Document doc, String name, int value) {
        name = name.trim();
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode(String.valueOf(value)));
        return elem;
    }

    public static Element createTag(Document doc, String name, boolean value) {
        name = name.trim();
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode(String.valueOf(value)));
        return elem;
    }

    public static Element createTag(Document doc, String name, float value) {
        name = name.trim();
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode(String.valueOf(value)));
        return elem;
    }

    public static Element createTag(Document doc, String name, long value) {
        name = name.trim();
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode("" + value));
        return elem;
    }

    public static Element createTag(Document doc, String name, double value) {
        name = name.trim();
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode(String.valueOf(value)));
        return elem;
    }

    public static Element appendChild(Document doc, Node node, String name, String value) {
        if (value == null) {
            return null;
        }
        return (Element)node.appendChild(ParseUtils.createTag(doc, name, value));
    }

    public static Element appendChild(Document doc, Node node, String name, int value) {
        return (Element)node.appendChild(ParseUtils.createTag(doc, name, value));
    }

    public static Element appendChild(Document doc, Node node, String name, float value) {
        return (Element)node.appendChild(ParseUtils.createTag(doc, name, value));
    }

    public static Element appendChild(Document doc, Node node, String name, long value) {
        return (Element)node.appendChild(ParseUtils.createTag(doc, name, value));
    }

    public static Element appendChild(Document doc, Node node, String name, double value) {
        return (Element)node.appendChild(ParseUtils.createTag(doc, name, value));
    }

    public static Element appendChild(Document doc, Node node, String name, boolean value) {
        return (Element)node.appendChild(ParseUtils.createTag(doc, name, value));
    }

    public static String zipDataFilesToBase64String(File[] files) throws IOException {
        byte[] compressedBytes = ParseUtils.zipDataFilesToByteArray(files);
        return new BASE64Encoder().encode(compressedBytes);
    }

    private static byte[] zipDataFilesToByteArray(File[] files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        for (int i = 0; i < files.length; ++i) {
            byte[] rawBytes = ParseUtils.readFile(files[i]);
            ZipEntry zipEntry = new ZipEntry(files[i].getName());
            zos.putNextEntry(zipEntry);
            zos.write(rawBytes, 0, rawBytes.length);
            zos.closeEntry();
        }
        zos.close();
        return baos.toByteArray();
    }

    public static byte[] readFile(String name) throws IOException {
        return ParseUtils.readFile(new File(name));
    }

    public static byte[] readFile(File file) throws IOException {
        int r;
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        byte[] buff = new byte[131072];
        FileInputStream fis = new FileInputStream(file);
        for (int totalRead = 0; totalRead < size; totalRead += r) {
            r = fis.read(buff);
            System.arraycopy(buff, 0, bytes, totalRead, r);
        }
        fis.close();
        return bytes;
    }

    public static String readFileToBase64String(String fileName) {
        return ParseUtils.readFileToBase64String(new File(fileName));
    }

    public static String readFileToBase64String(File file) {
        if (file.exists()) {
            try {
                byte[] fileBytes = ParseUtils.readFile(file);
                return new BASE64Encoder().encode(fileBytes);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return null;
    }

    public static boolean writeBase64BytesToFile(File file, String base64Bytes) {
        if (file == null || base64Bytes == null) {
            return false;
        }
        try {
            byte[] bytes = new BASE64Decoder().decodeBuffer(base64Bytes);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.flush();
            fos.close();
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static void extractZipToDirectory(String versionZipBytesBase64, File occasionDirectory) throws IOException {
        if (versionZipBytesBase64 == null || occasionDirectory == null) {
            return;
        }
        byte[] versionZipBytes = new BASE64Decoder().decodeBuffer(versionZipBytesBase64);
        ParseUtils.extractZipToDirectory(versionZipBytes, occasionDirectory);
    }

    public static void extractZipToDirectory(byte[] versionZipBytes, File directory) throws IOException {
        if (versionZipBytes == null || directory == null) {
            return;
        }
        directory.mkdirs();
        ByteArrayInputStream bais = new ByteArrayInputStream(versionZipBytes);
        ZipInputStream zis = new ZipInputStream(bais);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buff = new byte[16384];
            int bytesRead = zis.read(buff);
            while (bytesRead > 0) {
                baos.write(buff, 0, bytesRead);
                bytesRead = zis.read(buff);
            }
            byte[] uncompressedBytes = baos.toByteArray();
            File aFile = new File(directory, zipEntry.getName());
            FileOutputStream fos1 = new FileOutputStream(aFile);
            fos1.write(uncompressedBytes);
            fos1.flush();
            fos1.close();
            zipEntry = zis.getNextEntry();
        }
        zis.close();
    }

    public static String getDocumentString(Document doc) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        doc.normalize();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(baos);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(source, result);
        return new String(baos.toByteArray(), "UTF8");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NodeListMerge
    implements NodeList {
        NodeList m_list1;
        NodeList m_list2;
        int m_listLength1 = 0;
        int m_listLength2 = 0;

        public NodeListMerge(NodeList l1, NodeList l2) {
            this.m_list1 = l1;
            this.m_list2 = l2;
            this.m_listLength1 = this.m_list1.getLength();
            this.m_listLength2 = this.m_list2.getLength();
        }

        public Node item(int index) {
            if (index < this.m_listLength1) {
                return this.m_list1.item(index);
            }
            return this.m_list2.item(index - this.m_listLength1);
        }

        public int getLength() {
            return this.m_listLength1 + this.m_listLength2;
        }
    }
}

