/*
 * Decompiled with CFR 0.152.
 */
package widex.layout;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import widex.layout.Spec;
import widex.layout.SpecLayout;

public class SpecPanel
extends JPanel {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    int m_axis = -1;
    String m_defaultSpec = null;
    public SpecLayout m_layout;

    public SpecPanel(String axis) {
        this(axis, "P");
    }

    public SpecPanel(String axis, String otherAxisSpec) {
        axis = axis.toUpperCase().trim();
        if (axis.equals("X")) {
            this.m_axis = 0;
        } else if (axis.equals("Y")) {
            this.m_axis = 1;
        } else if (axis.equals("X_AXIS")) {
            this.m_axis = 0;
        } else if (axis.equals("Y_AXIS")) {
            this.m_axis = 1;
        } else {
            throw new IllegalArgumentException("Invalid Axis");
        }
        this.m_layout = this.m_axis == 0 ? new SpecLayout("", otherAxisSpec) : new SpecLayout(otherAxisSpec, "");
        this.m_defaultSpec = "P";
        this.setLayout(this.m_layout);
    }

    public String getDefaultSpec() {
        return this.m_defaultSpec;
    }

    public void setDefaultSpec(String defaultSpec) {
        this.m_defaultSpec = defaultSpec;
    }

    public void addFill() {
        this.add("FILL");
    }

    public void addGap(int gap) {
        this.add(String.valueOf(gap));
    }

    public void add(String aSpec) {
        Spec spec = Spec.parseSpec(aSpec);
        this.addSpec(spec);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (constraints == null) {
            constraints = this.m_defaultSpec;
        }
        if (constraints == null || !(constraints instanceof String)) {
            throw new IllegalArgumentException("Spec must be a string");
        }
        Spec spec = Spec.parseSpec(constraints.toString());
        this.addSpec(spec);
        int row = this.m_axis == 0 ? 0 : this.m_layout.getRowSpec().length - 1;
        int col = this.m_axis == 1 ? 0 : this.m_layout.getColSpec().length - 1;
        super.addImpl(comp, col + "," + row + "", index);
    }

    private void addSpec(Spec spec) {
        Spec[] specs = this.getAxisSpecs();
        ArrayList<Spec> al = new ArrayList<Spec>(Arrays.asList(specs));
        al.add(spec);
        specs = al.toArray(new Spec[0]);
        this.setAxisSpecs(specs);
    }

    private Spec[] getAxisSpecs() {
        return this.m_axis == 0 ? this.m_layout.getColSpec() : this.m_layout.getRowSpec();
    }

    private void setAxisSpecs(Spec[] specs) {
        if (this.m_axis == 0) {
            this.m_layout.setSpec(specs, this.m_layout.getRowSpec());
        } else {
            this.m_layout.setSpec(this.m_layout.getColSpec(), specs);
        }
    }
}

