/*
 * Decompiled with CFR 0.152.
 */
package widex.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Arrays;
import widex.layout.Cons;
import widex.layout.Spec;

public class SpecLayout
implements LayoutManager2 {
    public static boolean gDebug = false;
    boolean debug = false;
    Spec[] colSpec;
    Spec[] rowSpec;
    int[] widths;
    int[] heights;
    int[] xs;
    int[] ys;
    int prefWidth = 0;
    int prefHeight = 0;
    ArrayList consts = new ArrayList();
    boolean isDirty;

    public SpecLayout(String _colSpec, String _rowSpec) {
        this.debug = gDebug;
        this.setSpec(_colSpec, _rowSpec);
    }

    public void setSpec(String _colSpec, String _rowSpec) {
        this.setSpec(Spec.parseSpecs(_colSpec), Spec.parseSpecs(_rowSpec));
    }

    public void setSpec(Spec[] _colSpec, Spec[] _rowSpec) {
        this.colSpec = _colSpec;
        this.rowSpec = _rowSpec;
        this.widths = new int[this.colSpec.length];
        this.heights = new int[this.rowSpec.length];
        this.xs = new int[this.widths.length];
        this.ys = new int[this.heights.length];
        this.prefWidth = 0;
        this.prefHeight = 0;
        this.isDirty = true;
    }

    public Spec[] getColSpec() {
        return this.colSpec;
    }

    public Spec[] getRowSpec() {
        return this.rowSpec;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        this.consts.add(new Cons(comp, constraints.toString()));
        this.isDirty = true;
    }

    public void removeLayoutComponent(Component comp) {
        this.consts.remove(new Cons(comp, null));
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.isDirty) {
            this.calculateLayout(parent);
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        if (this.isDirty) {
            this.calculateLayout(parent);
        }
        boolean isLTR = parent.getComponentOrientation().isLeftToRight();
        for (int i = 0; i < this.consts.size(); ++i) {
            Cons cons = (Cons)this.consts.get(i);
            Dimension pref = cons.comp.getPreferredSize();
            Component comp = cons.comp;
            int c = cons.c;
            int r = cons.r;
            int w = -444;
            int h = -555;
            int addW = this.colSpec[c].getAddition();
            if (cons.isSpanningW()) {
                w = -1;
            } else if (cons.isFixedW()) {
                w = cons.fixWidth;
            } else if (this.colSpec[c].isFix()) {
                w = this.widths[c];
            } else if (this.colSpec[c].isFill()) {
                w = this.widths[c];
            } else if (this.colSpec[c].isMax()) {
                w = this.widths[c] + cons.getPrefWidthAddition();
            } else if (this.colSpec[c].isPref2()) {
                w = this.widths[c];
            } else if (this.colSpec[c].isPref()) {
                w = pref.width + addW + cons.getPrefWidthAddition();
            }
            if (w == -1) {
                w = 0;
                for (int j = c; j <= c + cons.w - 1; ++j) {
                    w += this.widths[j];
                }
            }
            int x = -1;
            int hAlign = this.getBidiHorizontalAlignment(cons.hAlign, comp);
            if (!isLTR) {
                if (hAlign == 0) {
                    x = this.xs[c] - this.widths[c];
                } else if (hAlign == 1) {
                    x = this.xs[c] - w;
                } else if (hAlign == 2) {
                    x = this.xs[c] - w - (this.widths[c] - w) / 2;
                }
            } else if (hAlign == 0) {
                x = this.xs[c];
            } else if (hAlign == 1) {
                x = this.xs[c] + (this.widths[c] - w);
            } else if (hAlign == 2) {
                x = this.xs[c] + (this.widths[c] - w) / 2;
            }
            int addH = this.rowSpec[r].getAddition();
            if (cons.isSpanningH()) {
                h = -1;
            } else if (cons.isFixedH()) {
                h = cons.fixHeight;
            } else if (this.rowSpec[r].isFix()) {
                h = this.heights[r];
            } else if (this.rowSpec[r].isFill()) {
                h = this.heights[r];
            } else if (this.rowSpec[r].isMax()) {
                h = this.heights[r] + cons.getPrefHeightAddition();
            } else if (this.rowSpec[r].isPref2()) {
                h = this.heights[r];
            } else if (this.rowSpec[r].isPref()) {
                h = pref.height + addH + cons.getPrefHeightAddition();
            }
            if (h == -1) {
                h = 0;
                for (int j = r; j <= r + cons.h - 1; ++j) {
                    h += this.heights[j];
                }
            }
            int y = -1;
            int vAlign = cons.vAlign;
            if (vAlign == 3) {
                y = this.ys[r];
            } else if (vAlign == 4) {
                y = this.ys[r] + (this.heights[r] - h);
            } else if (vAlign == 2) {
                y = this.ys[r] + (this.heights[r] - h) / 2;
            }
            comp.setBounds(x, y, w, h);
        }
    }

    void debug(int x) {
        if (this.debug) {
            System.out.println(x);
        }
    }

    void debug(String x) {
        if (this.debug) {
            System.out.println(x);
        }
    }

    void calculateLayout(Container parent) {
        int dif;
        int i;
        int i2;
        Insets parentInsets = parent.getInsets();
        int insetsLeft = parentInsets.left;
        int insetsRight = parentInsets.right;
        int insetsTop = parentInsets.top;
        int insetsBottom = parentInsets.bottom;
        int[] prefWidths = new int[this.widths.length];
        int[] prefHeights = new int[this.heights.length];
        Arrays.fill(this.widths, -1);
        Arrays.fill(this.heights, -1);
        Arrays.fill(prefWidths, -1);
        Arrays.fill(prefHeights, -1);
        int groupMaxW = 0;
        int groupMaxH = 0;
        for (int i3 = 0; i3 < this.consts.size(); ++i3) {
            int val1 = -1;
            int val2 = -1;
            Cons cons = (Cons)this.consts.get(i3);
            Dimension pref = cons.comp.getPreferredSize();
            cons.tmpW = pref.width;
            int c = cons.c;
            if (cons.isSpanningW()) {
                val1 = -1;
                val2 = -1;
            } else if (this.colSpec[c].isFill()) {
                val1 = -1;
                val2 = pref.width;
            } else if (cons.isFixedW()) {
                val2 = val1 = cons.fixWidth;
            } else if (this.colSpec[c].isPref()) {
                val2 = val1 = pref.width + cons.getPrefWidthAddition();
            }
            this.widths[c] = Math.max(this.widths[c], val1);
            prefWidths[c] = Math.max(prefWidths[c], val2);
            if (this.colSpec[c].isMax()) {
                groupMaxW = Math.max(this.widths[c], groupMaxW);
            }
            val1 = -1;
            val2 = -1;
            cons.tmpH = pref.height;
            int r = cons.r;
            if (cons.isSpanningH()) {
                val1 = -1;
                val2 = -1;
            } else if (this.rowSpec[r].isFill()) {
                val1 = -1;
                val2 = pref.height;
            } else if (cons.isFixedH()) {
                val2 = val1 = cons.fixHeight;
            } else if (this.rowSpec[r].isPref()) {
                val2 = val1 = pref.height + cons.getPrefHeightAddition();
            }
            this.heights[r] = Math.max(this.heights[r], val1);
            prefHeights[r] = Math.max(prefHeights[r], val2);
            if (!this.rowSpec[r].isMax()) continue;
            groupMaxH = Math.max(this.heights[r], groupMaxH);
        }
        boolean isLTR = parent.getComponentOrientation().isLeftToRight();
        int totalW = parent.getSize().width - insetsLeft - insetsRight;
        int exploitedWidth = 0;
        int fillWidthCount = 0;
        this.prefWidth = insetsLeft + insetsRight;
        for (i2 = 0; i2 < this.widths.length; ++i2) {
            if (this.widths[i2] == -1) {
                int n = this.widths[i2] = this.colSpec[i2].isFix() ? this.colSpec[i2].getValue() : 0;
            }
            if (prefWidths[i2] == -1) {
                int n = prefWidths[i2] = this.colSpec[i2].isFix() ? this.colSpec[i2].getValue() : 0;
            }
            if (this.colSpec[i2].isPrefOnly() && this.colSpec[i2].getAddition() > 0) {
                int n = i2;
                this.widths[n] = this.widths[n] + this.colSpec[i2].getAddition();
                int n2 = i2;
                prefWidths[n2] = prefWidths[n2] + this.colSpec[i2].getAddition();
            }
            if (this.colSpec[i2].isMax()) {
                this.widths[i2] = groupMaxW;
                prefWidths[i2] = groupMaxW;
            }
            if (this.colSpec[i2].isFill()) {
                ++fillWidthCount;
                int n = i2;
                prefWidths[n] = prefWidths[n] + this.colSpec[i2].getAddition();
            }
            if (prefWidths[i2] > this.colSpec[i2].getPrefBound()) {
                prefWidths[i2] = this.colSpec[i2].getPrefBound();
            }
            exploitedWidth += this.widths[i2];
            this.prefWidth += prefWidths[i2];
        }
        int maxDiffrenitialW = 0;
        for (i = 0; i < this.consts.size(); ++i) {
            int sumW;
            Cons cons = (Cons)this.consts.get(i);
            if (!cons.isSpanningW() || cons.tmpW <= (sumW = SpecLayout.sum(prefWidths, cons.c, cons.c + cons.w - 1))) continue;
            dif = cons.tmpW - sumW;
            maxDiffrenitialW = Math.max(maxDiffrenitialW, dif);
        }
        this.prefWidth += maxDiffrenitialW;
        if (fillWidthCount > 0) {
            int fillWidth = (totalW - exploitedWidth) / fillWidthCount;
            for (int i4 = 0; i4 < this.widths.length; ++i4) {
                if (!this.colSpec[i4].isFill()) continue;
                this.widths[i4] = fillWidth;
            }
        }
        this.xs[0] = isLTR ? insetsLeft : insetsLeft + totalW;
        for (i = 1; i < this.xs.length; ++i) {
            this.xs[i] = isLTR ? this.xs[i - 1] + this.widths[i - 1] : this.xs[i - 1] - this.widths[i - 1];
        }
        int totalH = parent.getSize().height - insetsTop - insetsBottom;
        int exploitedHeight = 0;
        int fillHeightCount = 0;
        this.prefHeight = insetsTop + insetsBottom;
        for (i2 = 0; i2 < this.heights.length; ++i2) {
            if (this.heights[i2] == -1) {
                int n = this.heights[i2] = this.rowSpec[i2].isFix() ? this.rowSpec[i2].getValue() : 0;
            }
            if (prefHeights[i2] == -1) {
                int n = prefHeights[i2] = this.rowSpec[i2].isFix() ? this.rowSpec[i2].getValue() : 0;
            }
            if (this.rowSpec[i2].isPrefOnly() && this.rowSpec[i2].getAddition() > 0) {
                int n = i2;
                this.heights[n] = this.heights[n] + this.rowSpec[i2].getAddition();
                int n3 = i2;
                prefHeights[n3] = prefHeights[n3] + this.rowSpec[i2].getAddition();
            }
            if (this.rowSpec[i2].isMax()) {
                this.heights[i2] = groupMaxH;
                prefHeights[i2] = groupMaxH;
            }
            if (this.rowSpec[i2].isFill()) {
                ++fillHeightCount;
                int n = i2;
                prefHeights[n] = prefHeights[n] + this.rowSpec[i2].getAddition();
            }
            if (prefHeights[i2] > this.rowSpec[i2].getPrefBound()) {
                prefHeights[i2] = this.rowSpec[i2].getPrefBound();
            }
            exploitedHeight += this.heights[i2];
            this.prefHeight += prefHeights[i2];
        }
        int maxDiffrenitialH = 0;
        for (i = 0; i < this.consts.size(); ++i) {
            int sumH;
            Cons cons = (Cons)this.consts.get(i);
            if (!cons.isSpanningH() || cons.tmpH <= (sumH = SpecLayout.sum(prefHeights, cons.r, cons.r + cons.h - 1))) continue;
            dif = cons.tmpH - sumH;
            maxDiffrenitialH = Math.max(maxDiffrenitialH, dif);
        }
        this.prefHeight += maxDiffrenitialH;
        if (fillHeightCount > 0) {
            int fillHeight = (totalH - exploitedHeight) / fillHeightCount;
            for (int i5 = 0; i5 < this.heights.length; ++i5) {
                if (!this.rowSpec[i5].isFill()) continue;
                this.heights[i5] = fillHeight;
            }
        }
        this.ys[0] = parent.getInsets().top;
        for (i = 1; i < this.ys.length; ++i) {
            this.ys[i] = this.ys[i - 1] + this.heights[i - 1];
        }
        this.isDirty = false;
    }

    private static int sum(int[] array, int s, int e) {
        int sum = 0;
        for (int j = s; j <= e; ++j) {
            sum += array[j];
        }
        return sum;
    }

    public void invalidateLayout(Container parent) {
        this.isDirty = true;
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.0f;
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new RuntimeException("NO");
    }

    private int getBidiHorizontalAlignment(int ha, Component comp) {
        if (ha == 5) {
            ha = comp.getComponentOrientation().isLeftToRight() ? 0 : 1;
        } else if (ha == 6) {
            ha = comp.getComponentOrientation().isLeftToRight() ? 1 : 0;
        }
        return ha;
    }
}

