/*
 * Decompiled with CFR 0.152.
 */
package widex.layout;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Spec {
    private static final int _PREF = 0;
    private static final int _PREF2 = 1;
    private static final int _FIX = 2;
    private static final int _FILL = 3;
    private static final int _MAX = 4;
    public static final Spec PREF = new Spec(0, 0);
    public static final Spec PREF2 = new Spec(1, 0);
    public static final Spec FILL = new Spec(3, 0);
    public static final Spec MAX = new Spec(4, 0);
    int type;
    int value;
    int prefBound;

    public static Spec FIX(int value) {
        return new Spec(2, value);
    }

    public static Spec PREF(int value) {
        return new Spec(0, value);
    }

    public static Spec FILL(int value) {
        return new Spec(3, value);
    }

    int getAddition() {
        return this.value;
    }

    private Spec(int type, int value) {
        this.type = type;
        this.value = value;
        this.prefBound = Integer.MAX_VALUE;
    }

    public boolean isPref() {
        return this.type == 0 || this.type == 1 || this.type == 4;
    }

    public boolean isPrefOnly() {
        return this.type == 0;
    }

    public boolean isPref2() {
        return this.type == 1;
    }

    public boolean isMax() {
        return this.type == 4;
    }

    public boolean isFix() {
        return this.type == 2;
    }

    public boolean isFill() {
        return this.type == 3;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isPrefBounded() {
        return this.prefBound != Integer.MAX_VALUE;
    }

    public int getPrefBound() {
        return this.prefBound;
    }

    public static Spec parseSpec(String spec) {
        String oSpec = spec;
        if ((spec = spec.trim().toUpperCase()).startsWith("PREF+") || spec.startsWith("P+")) {
            int pwa = Integer.parseInt(spec.substring(spec.indexOf("+") + 1));
            return Spec.PREF(pwa);
        }
        if (spec.startsWith("FILL+") || spec.startsWith("F+")) {
            int pwa = Integer.parseInt(spec.substring(spec.indexOf("+") + 1));
            return Spec.FILL(pwa);
        }
        if (spec.equals("PREF")) {
            return PREF;
        }
        if (spec.equals("PREF2")) {
            return PREF2;
        }
        if (spec.equals("FILL")) {
            return FILL;
        }
        if (spec.equals("MAX")) {
            return MAX;
        }
        if (spec.equals("P")) {
            return PREF;
        }
        if (spec.equals("P2")) {
            return PREF2;
        }
        if (spec.equals("F")) {
            return FILL;
        }
        if (spec.equals("M")) {
            return MAX;
        }
        int a = -1;
        try {
            a = Integer.parseInt(spec);
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (a != -1) {
            return Spec.FIX(a);
        }
        if (spec.indexOf(";") != -1) {
            StringTokenizer tok = new StringTokenizer(spec, ";");
            int specID = Spec.getSpecID(tok.nextToken());
            Spec aSpec = new Spec(specID, 0);
            while (tok.hasMoreElements()) {
                String keyval = tok.nextToken().trim();
                int pos = keyval.indexOf("=");
                if (pos == 0) {
                    Spec.throwExp(oSpec, "");
                }
                String key = keyval.substring(0, pos);
                String val = keyval.substring(pos + 1);
                if (key.equals("ADD")) {
                    try {
                        aSpec.value = Integer.parseInt(val);
                    }
                    catch (Exception exp) {
                        Spec.throwExp(oSpec, "Invalid 'add' value");
                    }
                    continue;
                }
                if (key.equals("MAX")) {
                    try {
                        aSpec.prefBound = Integer.parseInt(val);
                    }
                    catch (Exception exp) {
                        Spec.throwExp(oSpec, "Invalid Pref-Bound value");
                    }
                    continue;
                }
                Spec.throwExp(oSpec, "Cant parse property " + key);
            }
            return aSpec;
        }
        Spec.throwExp(oSpec, "");
        return null;
    }

    private static void throwExp(String spec, String info) {
        if (info == null) {
            info = "";
        }
        throw new IllegalArgumentException("Can't Parse Spec " + spec + " " + info);
    }

    public static Spec[] parseSpecs(String specs) {
        StringTokenizer tok = new StringTokenizer(specs, ",");
        ArrayList<Spec> list = new ArrayList<Spec>();
        while (tok.hasMoreElements()) {
            list.add(Spec.parseSpec(tok.nextToken()));
        }
        return list.toArray(new Spec[0]);
    }

    private static int getSpecID(String spec) {
        if (spec.equals("PREF")) {
            return 0;
        }
        if (spec.equals("PREF2")) {
            return 1;
        }
        if (spec.equals("FILL")) {
            return 3;
        }
        if (spec.equals("MAX")) {
            return 4;
        }
        if (spec.equals("P")) {
            return 0;
        }
        if (spec.equals("P2")) {
            return 1;
        }
        if (spec.equals("F")) {
            return 3;
        }
        if (spec.equals("M")) {
            return 4;
        }
        throw new IllegalArgumentException("Can't Parse Spec " + spec);
    }

    public String toString() {
        if (this.type == 0) {
            return "PREF";
        }
        if (this.type == 1) {
            return "PREF2";
        }
        if (this.type == 2) {
            return "FIX(" + this.value + ")";
        }
        if (this.type == 3) {
            return "FILL";
        }
        if (this.type == 4) {
            return "MAX";
        }
        return "?";
    }
}

