/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.widgets.sortedtable;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import whilepack.gui.widgets.sortedtable.ColumnComparator;
import whilepack.gui.widgets.sortedtable.ISortedTableModel;
import whilepack.gui.widgets.sortedtable.SortedTableEvent;
import whilepack.gui.widgets.sortedtable.SortedTableListener;
import whilepack.gui.widgets.sortedtable.SortingVetoException;

public class SortedTableModel
extends AbstractTableModel
implements ISortedTableModel {
    private int m_sortedColumn = 0;
    private ColumnComparator[] m_columnComparator;
    private boolean[] m_dirtyColumn;
    private Vector m_columnIdentifiers;
    private Vector m_data;
    private int m_sortDirection;
    static /* synthetic */ Class class$whilepack$gui$widgets$sortedtable$SortedTableListener;

    public SortedTableModel(Object[] columnNames) {
        this(new Vector(), SortedTableModel.convertToVector(columnNames), null);
    }

    public SortedTableModel(Vector columnNames) {
        this(new Vector(), columnNames, null);
    }

    public SortedTableModel(Object[] columnNames, Comparator[] comparators) {
        this(new Vector(), SortedTableModel.convertToVector(columnNames), comparators);
    }

    public SortedTableModel(Object[][] data, Object[] columnNames) {
        this(SortedTableModel.convertToVector(data), SortedTableModel.convertToVector(columnNames), null);
    }

    public SortedTableModel(Object[][] data, Object[] columnNames, Comparator[] comparators) {
        this(SortedTableModel.convertToVector(data), SortedTableModel.convertToVector(columnNames), comparators);
    }

    public SortedTableModel(Vector data, Vector columnIdentifiers, Comparator[] comparators) {
        int i;
        if (comparators == null) {
            this.m_columnComparator = new ColumnComparator[columnIdentifiers.size()];
            for (i = 0; i < this.m_columnComparator.length; ++i) {
                this.m_columnComparator[i] = new ColumnComparator(i);
            }
        } else {
            this.m_columnComparator = new ColumnComparator[comparators.length];
            for (i = 0; i < this.m_columnComparator.length; ++i) {
                this.m_columnComparator[i] = new ColumnComparator(i, comparators[i]);
            }
        }
        this.m_columnIdentifiers = columnIdentifiers;
        int columnCount = this.getColumnCount();
        this.m_dirtyColumn = new boolean[columnCount];
        this.m_sortDirection = 0;
        this.setData(data, false);
    }

    public void setData(Object[][] data) {
        this.setData(SortedTableModel.convertToVector(data));
    }

    public void setData(Vector data) {
        this.setData(data, true);
    }

    private void setData(Vector data, boolean fireEvent) {
        if (data == null) {
            data = new Vector();
        }
        this.m_data = new Vector();
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Vector rows = new Vector(data);
            Collections.sort(rows, this.m_columnComparator[i]);
            this.m_data.addElement(rows);
            this.m_dirtyColumn[i] = false;
        }
        if (fireEvent) {
            this.fireTableDataChanged();
        }
    }

    public Object getValueAt(int row, int col) {
        Vector sortedRows = (Vector)this.m_data.elementAt(this.m_sortedColumn);
        Vector aRow = null;
        aRow = this.getSortDirection() == 0 ? (Vector)sortedRows.elementAt(row) : (Vector)sortedRows.elementAt(sortedRows.size() - 1 - row);
        return aRow.elementAt(col);
    }

    public Vector getRowVector(int row) {
        Vector sortedRows = (Vector)this.m_data.elementAt(this.m_sortedColumn);
        Vector aRow = null;
        aRow = this.getSortDirection() == 0 ? (Vector)sortedRows.elementAt(row) : (Vector)sortedRows.elementAt(sortedRows.size() - 1 - row);
        return aRow;
    }

    public Vector getData() {
        return this.getData(this.m_sortedColumn);
    }

    private Vector getData(int column) {
        Vector sortedRows = (Vector)this.m_data.elementAt(column);
        return sortedRows;
    }

    public void setValueAt(Object aValue, int row, int col) {
        Vector sortedRows = (Vector)this.m_data.elementAt(this.m_sortedColumn);
        Vector aRow = null;
        aRow = this.getSortDirection() == 0 ? (Vector)sortedRows.elementAt(row) : (Vector)sortedRows.elementAt(sortedRows.size() - 1 - row);
        if (this.getValueAt(row, col) == null || !this.getValueAt(row, col).equals(aValue)) {
            aRow.setElementAt(aValue, col);
            this.m_dirtyColumn[col] = true;
            this.fireTableCellUpdated(row, col);
        }
    }

    public int getColumnCount() {
        return this.m_columnIdentifiers.size();
    }

    public String getColumnName(int c) {
        return this.m_columnIdentifiers.elementAt(c).toString();
    }

    public Class getColumnClass(int c) {
        return this.m_columnIdentifiers.elementAt(c).getClass();
    }

    public int addRow(Object[] row) {
        return this.addRow(SortedTableModel.convertToVector(row));
    }

    private int addRow(Vector newRow) {
        int newRowIndex = -1;
        for (int i = 0; i < this.m_data.size(); ++i) {
            Vector rows = (Vector)this.m_data.elementAt(i);
            int index = Collections.binarySearch(rows, newRow, this.m_columnComparator[i]);
            if (index < 0) {
                index = -index - 1;
            }
            if (this.m_sortedColumn == i) {
                newRowIndex = index;
            }
            rows.insertElementAt(newRow, index);
        }
        if (newRowIndex != -1) {
            this.fireTableRowsInserted(newRowIndex, newRowIndex);
        }
        return newRowIndex;
    }

    public void removeRow(int row) {
        Vector sortedRows = (Vector)this.m_data.elementAt(this.m_sortedColumn);
        Vector delRow = null;
        delRow = this.getSortDirection() == 0 ? (Vector)sortedRows.elementAt(row) : (Vector)sortedRows.elementAt(sortedRows.size() - 1 - row);
        for (int i = 0; i < this.m_data.size(); ++i) {
            sortedRows = (Vector)this.m_data.elementAt(i);
            sortedRows.remove(delRow);
        }
        super.fireTableRowsDeleted(row, row);
    }

    public void removeAllRows() {
        this.setData(new Vector());
    }

    public Comparator getColumnComparator(int col) {
        return this.m_columnComparator[col].getComparator();
    }

    public void setColumnComparator(int col, Comparator comparator) {
        this.m_columnComparator[col].setColumnComparator(comparator);
        Vector rowsSetOfThisColumn = (Vector)this.m_data.elementAt(col);
        Collections.sort(rowsSetOfThisColumn, this.m_columnComparator[col]);
        this.fireTableStructureChanged();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public int getRowCount() {
        Vector currentSortedRows = (Vector)this.m_data.elementAt(this.m_sortedColumn);
        return currentSortedRows.size();
    }

    public int getSortedColumn() {
        return this.m_sortedColumn;
    }

    public void changeSortDirection() {
        if (this.getSortDirection() == 0) {
            this.setSortDirection(1);
        } else {
            this.setSortDirection(0);
        }
    }

    public void setSortedColumn(int col) {
        if (this.m_sortedColumn == col) {
            return;
        }
        this.setSortedColumn(col, 0);
    }

    private void setSortedColumn(int col, int sortDirection) {
        if (this.checkAllowedSorting(col, sortDirection)) {
            this.m_sortedColumn = col;
            this.m_sortDirection = sortDirection;
            this.checkDirtyColumns();
            this.fireTableStructureChanged();
            this.fireTableSorted(new SortedTableEvent(this));
        }
    }

    private void setSortDirection(int newDirection) {
        if (this.m_sortDirection == newDirection) {
            return;
        }
        this.setSortedColumn(this.getSortedColumn(), newDirection);
    }

    public int getSortDirection() {
        return this.m_sortDirection;
    }

    private void checkDirtyColumns() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.m_dirtyColumn[i]) continue;
            Vector rows = (Vector)this.m_data.elementAt(i);
            Collections.sort(rows, this.m_columnComparator[i]);
            this.m_dirtyColumn[i] = false;
        }
    }

    public void addSortedTableListener(SortedTableListener l) {
        this.listenerList.add(class$whilepack$gui$widgets$sortedtable$SortedTableListener == null ? (class$whilepack$gui$widgets$sortedtable$SortedTableListener = SortedTableModel.class$("whilepack.gui.widgets.sortedtable.SortedTableListener")) : class$whilepack$gui$widgets$sortedtable$SortedTableListener, l);
    }

    public void removeSortedTableListener(SortedTableListener l) {
        this.listenerList.remove(class$whilepack$gui$widgets$sortedtable$SortedTableListener == null ? (class$whilepack$gui$widgets$sortedtable$SortedTableListener = SortedTableModel.class$("whilepack.gui.widgets.sortedtable.SortedTableListener")) : class$whilepack$gui$widgets$sortedtable$SortedTableListener, l);
    }

    private SortedTableListener[] getSortedTableListeners() {
        return (SortedTableListener[])this.listenerList.getListeners(class$whilepack$gui$widgets$sortedtable$SortedTableListener == null ? (class$whilepack$gui$widgets$sortedtable$SortedTableListener = SortedTableModel.class$("whilepack.gui.widgets.sortedtable.SortedTableListener")) : class$whilepack$gui$widgets$sortedtable$SortedTableListener);
    }

    private void fireTableWillBeSorted(SortedTableEvent e) throws SortingVetoException {
        SortedTableListener[] listeners = this.getSortedTableListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].tableWillBeSorted(e);
        }
    }

    private void fireTableSorted(SortedTableEvent e) {
        SortedTableListener[] listeners = this.getSortedTableListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].tableSorted(e);
        }
    }

    private boolean checkAllowedSorting(int futureSortedColumn, int futureSortDirection) {
        try {
            this.fireTableWillBeSorted(new SortedTableEvent(this, futureSortedColumn, futureSortDirection));
            return true;
        }
        catch (Exception exp) {
            return false;
        }
    }

    private static Vector convertToVector(Object[] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(anArray.length);
        for (int i = 0; i < anArray.length; ++i) {
            v.addElement(anArray[i]);
        }
        return v;
    }

    private static Vector convertToVector(Object[][] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Vector> v = new Vector<Vector>(anArray.length);
        for (int i = 0; i < anArray.length; ++i) {
            v.addElement(SortedTableModel.convertToVector(anArray[i]));
        }
        return v;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

