/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.widgets.sortedtable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import whilepack.gui.widgets.sortedtable.ISortedTableModel;
import widex.utils.Utils;

public class SortedTableHandler {
    public static Icon SORT_DESC_ICON = null;
    public static Icon SORT_ASC_ICON = null;
    private boolean[] sortableColumns;
    private int[] textAlignments;
    private int sortedColumn = 0;
    private int pressedColumn = -1;
    static /* synthetic */ Class class$whilepack$gui$widgets$sortedtable$ISortedTableModel;

    public SortedTableHandler(JTable table) {
        if (table == null) {
            throw new NullPointerException("Configured Table cannot be null");
        }
        if (!(table.getModel() instanceof ISortedTableModel)) {
            throw new IllegalArgumentException("TableModel of Configured Table must be of " + (class$whilepack$gui$widgets$sortedtable$ISortedTableModel == null ? (class$whilepack$gui$widgets$sortedtable$ISortedTableModel = SortedTableHandler.class$("whilepack.gui.widgets.sortedtable.ISortedTableModel")) : class$whilepack$gui$widgets$sortedtable$ISortedTableModel));
        }
        TableHeaderMouseInputListener mouseInputListener = new TableHeaderMouseInputListener();
        table.setAutoCreateColumnsFromModel(false);
        this.sortedColumn = ((ISortedTableModel)table.getModel()).getSortedColumn();
        table.getTableHeader().setDefaultRenderer(new SortedColumnHeaderRenderer());
        table.getColumnModel().setColumnMargin(0);
        table.getTableHeader().addMouseListener(mouseInputListener);
        table.getTableHeader().addMouseMotionListener(mouseInputListener);
        int columnCount = table.getColumnCount();
        this.sortableColumns = new boolean[columnCount];
        this.textAlignments = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.sortableColumns[i] = true;
            this.textAlignments[i] = 0;
        }
    }

    public void setColumnSortable(int col, boolean allowSorting) {
        this.sortableColumns[col] = allowSorting;
    }

    public void setColumnHeaderTextAlignment(int col, int alignment) {
        if (alignment != 2 && alignment != 0 && alignment != 4 && alignment != 10 && alignment != 11) {
            throw new IllegalArgumentException("Illegal Alignment");
        }
        this.textAlignments[col] = alignment;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TableHeaderMouseInputListener
    implements MouseInputListener {
        TableHeaderMouseInputListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            JTableHeader tableHeader = (JTableHeader)e.getSource();
            if (SwingUtilities.isLeftMouseButton(e)) {
                int aColumn;
                if (tableHeader.getResizingColumn() == null && (aColumn = tableHeader.columnAtPoint(e.getPoint())) != -1 && SortedTableHandler.this.sortableColumns[aColumn]) {
                    SortedTableHandler.this.pressedColumn = aColumn;
                    tableHeader.repaint();
                    return;
                }
                SortedTableHandler.this.pressedColumn = -1;
            }
        }

        public void mouseReleased(MouseEvent e) {
            SwingUtilities.invokeLater(new ReleaseRunnable(e));
        }

        public void mouseDragged(MouseEvent e) {
            if (SortedTableHandler.this.pressedColumn != -1) {
                JTableHeader tableHeader = (JTableHeader)e.getSource();
                JTable table = tableHeader.getTable();
                SortedTableHandler.this.pressedColumn = -1;
                tableHeader.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        class ReleaseRunnable
        implements Runnable {
            MouseEvent e;

            public ReleaseRunnable(MouseEvent e) {
                this.e = e;
            }

            public void run() {
                JTableHeader tableHeader = (JTableHeader)this.e.getSource();
                JTable table = tableHeader.getTable();
                ISortedTableModel model = (ISortedTableModel)table.getModel();
                if (SortedTableHandler.this.pressedColumn != -1) {
                    int c = SortedTableHandler.this.pressedColumn;
                    SortedTableHandler.this.pressedColumn = -1;
                    tableHeader.repaint();
                    if (SortedTableHandler.this.sortedColumn == table.convertColumnIndexToModel(c)) {
                        model.changeSortDirection();
                    } else {
                        SortedTableHandler.this.sortedColumn = table.convertColumnIndexToModel(c);
                        model.setSortedColumn(c);
                    }
                }
            }
        }
    }

    class SortedColumnHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        Icon sortAscIcon = SORT_ASC_ICON;
        Icon sortDscIcon = SORT_DESC_ICON;
        Border pressedBorder;
        Border normalBorder;

        public SortedColumnHeaderRenderer() {
            this.setOpaque(true);
            this.setComponentOrientation(Utils.getOrientation());
            this.setIconTextGap(10);
            this.setHorizontalTextPosition(10);
            this.pressedBorder = new EtchedBorder();
            this.normalBorder = new CompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), new EmptyBorder(1, 6, 1, 6));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setText(value == null ? "" : value.toString());
                this.setPreferredSize(new Dimension(10, 18));
            }
            ISortedTableModel model = (ISortedTableModel)table.getModel();
            this.setHorizontalAlignment(SortedTableHandler.this.textAlignments[column]);
            if (column == SortedTableHandler.this.pressedColumn) {
                this.setBorder(this.pressedBorder);
            } else {
                this.setBorder(this.normalBorder);
            }
            if (column == table.convertColumnIndexToView(model.getSortedColumn())) {
                if (model.getSortDirection() == 0) {
                    this.setIcon(this.sortAscIcon);
                } else {
                    this.setIcon(this.sortDscIcon);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }
}

