/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.texteditor;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import whilepack.gui.CodeTextEditor;

public class MarginMouseListener
extends MouseAdapter
implements MouseMotionListener {
    private int pressLineStart = -1;
    private int pressLineEnd = -1;
    private CodeTextEditor codeTextEditor;
    private Point pressPoint;

    public void mousePressed(MouseEvent e) {
        int pos = this.codeTextEditor.txt.viewToModel(e.getPoint());
        int[] se = this.codeTextEditor.posToStartEndLine(pos);
        this.pressLineStart = se[0];
        this.pressLineEnd = se[1];
        this.pressPoint = e.getPoint();
    }

    public MarginMouseListener(CodeTextEditor codeTextEditor) {
        this.codeTextEditor = codeTextEditor;
    }

    public void mouseDragged(MouseEvent e) {
        try {
            if (this.pressPoint == null) {
                return;
            }
            if (this.pressPoint.distance(e.getPoint()) < 5.0) {
                return;
            }
            int pos = this.codeTextEditor.txt.viewToModel(e.getPoint());
            int[] se = this.codeTextEditor.posToStartEndLine(pos);
            if (se[0] < this.pressLineStart) {
                this.codeTextEditor.txt.setCaretPosition(this.pressLineStart + (this.pressLineEnd - this.pressLineStart));
                this.codeTextEditor.txt.moveCaretPosition(se[0]);
            } else if (se[1] <= this.codeTextEditor.txt.getDocument().getLength()) {
                this.codeTextEditor.txt.setCaretPosition(this.pressLineStart);
                this.codeTextEditor.txt.moveCaretPosition(se[1]);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.pressPoint = null;
        this.pressLineEnd = -1;
        this.pressLineStart = -1;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

