/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.syntaxutils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Segment;
import novaworx.syntax.KeywordMap;
import novaworx.syntax.Syntax;
import novaworx.syntax.SyntaxFactory;
import whilepack.general.SugarHandler;
import whilepack.gui.CodeTextEditor;
import whilepack.gui.WhileIDE;

public class WideSyntaxHandler {
    private static boolean initilized = false;
    private static Map dynamicKeywords = new HashMap();
    private static Syntax TEXT_SYNTAX;
    private static Syntax LIST_SYNTAX;

    public static void init() {
        if (initilized) {
            return;
        }
        WideSyntaxHandler.loadSyntaxGrammars();
        TEXT_SYNTAX = SyntaxFactory.getSyntax((String)"wct");
        LIST_SYNTAX = SyntaxFactory.getSyntax((String)"wcl");
        WideSyntaxHandler.saveDynamicKeyword(TEXT_SYNTAX, "case");
        WideSyntaxHandler.saveDynamicKeyword(TEXT_SYNTAX, "of");
        WideSyntaxHandler.saveDynamicKeyword(TEXT_SYNTAX, "true");
        WideSyntaxHandler.saveDynamicKeyword(TEXT_SYNTAX, "false");
        WideSyntaxHandler.saveDynamicKeyword(TEXT_SYNTAX, "list");
        WideSyntaxHandler.refreshSyntax();
        initilized = true;
    }

    public static void refreshSyntax() {
        WideSyntaxHandler.setKeywordEnabled(TEXT_SYNTAX, "case", SugarHandler.isCaseSugarActive());
        WideSyntaxHandler.setKeywordEnabled(TEXT_SYNTAX, "of", SugarHandler.isCaseSugarActive());
        WideSyntaxHandler.setKeywordEnabled(TEXT_SYNTAX, "true", SugarHandler.isBooleansSugarActive());
        WideSyntaxHandler.setKeywordEnabled(TEXT_SYNTAX, "false", SugarHandler.isBooleansSugarActive());
        WideSyntaxHandler.setKeywordEnabled(TEXT_SYNTAX, "list", SugarHandler.isListSuagrActive());
    }

    public static void refreshCodeTextEditor() {
        WhileIDE ide = WhileIDE.ide;
        CodeTextEditor[] editors = ide.getCodeTextEditors();
        for (int i = 0; i < editors.length; ++i) {
            CodeTextEditor editor = editors[i];
            editor.reloadSyntax();
        }
    }

    private static void setKeywordEnabled(Syntax syntax, String keyword, boolean enabled) {
        KeywordMap keywordMap = syntax.getTokenMarker().getMainRuleSet().getKeywords();
        if (enabled) {
            keywordMap.add(keyword, ((Byte)dynamicKeywords.get(keyword)).byteValue());
        } else {
            keywordMap.add(keyword, (byte)0);
        }
    }

    private static void saveDynamicKeyword(Syntax syntax, String keyword) {
        KeywordMap keywordMap = syntax.getTokenMarker().getMainRuleSet().getKeywords();
        Segment segment = new Segment(keyword.toCharArray(), 0, keyword.length());
        byte keyworkId = keywordMap.lookup(segment, 0, segment.count);
        dynamicKeywords.put(keyword, new Byte(keyworkId));
    }

    private static void loadSyntaxGrammars() {
        String sHomeDirectory = System.getProperty("user.dir");
        File oEtc = new File(sHomeDirectory, "etc");
        File oCatalog = new File(oEtc, "syntax.catalog.xml");
        SyntaxFactory.setSyntaxCatalog((File)oCatalog);
        SyntaxFactory.loadSyntaxes();
    }
}

