/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.searchreplace;

import novaworx.textpane.SyntaxTextPane;
import whilepack.gui.CodeTextEditor;

public class SearchUtils {
    private CodeTextEditor editor;
    private String findWhat;
    private boolean chkMatchWholeWords;
    private boolean chkMatchCase;

    public SearchUtils(CodeTextEditor editor, String findWhat, boolean chkMatchCase, boolean chkMatchWholeWords) {
        this.editor = editor;
        this.findWhat = findWhat;
        this.chkMatchCase = chkMatchCase;
        this.chkMatchWholeWords = chkMatchWholeWords;
    }

    public boolean findTextFromCaret() {
        int pos;
        SyntaxTextPane txt = this.editor.txt;
        char[] text = txt.getText().toCharArray();
        int offset = txt.getCaretPosition();
        char[] findWhatChars = this.findWhat.toCharArray();
        while (true) {
            if ((pos = this.indexOf(text, findWhatChars, offset)) == -1) {
                return false;
            }
            if (this.checkMatchWholeWords(text, pos, findWhatChars.length)) break;
            offset += findWhatChars.length;
        }
        txt.setCaretPosition(pos);
        txt.moveCaretPosition(pos + findWhatChars.length);
        return true;
    }

    public boolean findPreviousTextFromCaret() {
        int pos;
        SyntaxTextPane txt = this.editor.txt;
        char[] text = txt.getText().toCharArray();
        this.reverse(text);
        char[] findWhatChars = this.findWhat.toCharArray();
        int p0 = Math.min(txt.getCaret().getDot(), txt.getCaret().getMark());
        int p1 = Math.max(txt.getCaret().getDot(), txt.getCaret().getMark());
        int selectionLength = p1 - p0;
        int offset = text.length - txt.getCaretPosition() + selectionLength;
        while (true) {
            this.reverse(findWhatChars);
            pos = this.indexOf(text, findWhatChars, offset);
            if (pos == -1) {
                return false;
            }
            if (this.checkMatchWholeWords(text, pos, findWhatChars.length)) break;
            offset += findWhatChars.length;
        }
        pos = text.length - pos;
        txt.setCaretPosition(pos - findWhatChars.length);
        txt.moveCaretPosition(pos);
        return true;
    }

    private boolean checkMatchWholeWords(char[] text, int pos, int length) {
        if (this.chkMatchWholeWords) {
            if (pos - 1 >= 0 && Character.isLetterOrDigit(text[pos - 1])) {
                return false;
            }
            if (pos + length <= text.length - 1 && Character.isLetterOrDigit(text[pos + length])) {
                return false;
            }
        }
        return true;
    }

    private int indexOf(char[] sourceText, char[] targetText, int offset) {
        return this.indexOf(sourceText, 0, sourceText.length, targetText, 0, targetText.length, offset);
    }

    private int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && !this.isEqual(source[i], first)) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (this.isEqual(source[j++], target[k++])) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }

    private boolean isEqual(char a, char b) {
        if (a == b) {
            return true;
        }
        if (this.chkMatchCase) {
            return false;
        }
        return Character.toLowerCase(a) == Character.toLowerCase(b);
    }

    private void reverse(char[] value) {
        int n = value.length - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = value[j];
            value[j] = value[n - j];
            value[n - j] = temp;
        }
    }
}

