/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.searchreplace;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import whilepack.SysLog;
import whilepack.gui.AbstractAction2;
import whilepack.gui.CodeTextEditor;
import whilepack.gui.WhileIDE;
import whilepack.gui.searchreplace.FindDialog;
import whilepack.gui.searchreplace.FindDialogCallBack;
import whilepack.gui.searchreplace.SearchPrompt;

public class SearchActions {
    public static final FindAction FIND_ACTION = new FindAction();
    public static final FindNext FIND_NEXT = new FindNext();
    public static final FindPrevious FIND_PREVIOUS = new FindPrevious();
    public static final ReplaceAction REPLACE_ACTION = new ReplaceAction();
    private static FindDialog findDialog;

    public static class ReplaceAction
    extends AbstractAction2
    implements FindDialogCallBack {
        public ReplaceAction() {
            super("Replace...", new ImageIcon("images/action/replace.png"));
            this.putValue("ShortDescription", "Replace...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control H"));
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE ide = WhileIDE.ide;
            CodeTextEditor editor = ide.editor();
            if (editor == null) {
                return;
            }
            if (findDialog == null) {
                findDialog = new FindDialog(ide.frame);
            }
            findDialog.show(this, true);
        }

        public void findApproved(FindDialog findDialog) {
            CodeTextEditor editor;
            boolean hasNext = true;
            boolean replaceAll = false;
            while (hasNext = findDialog.findText(editor = WhileIDE.ide.editor(), false)) {
                int action = 0;
                if (!replaceAll) {
                    SearchPrompt x = new SearchPrompt(WhileIDE.ide.frame);
                    action = x.showDialog();
                    if (action == -1) {
                        return;
                    }
                    boolean bl = replaceAll = action == 2;
                }
                if (action != 0 && !replaceAll) continue;
                String replaceWith = findDialog.getReplaceWithText();
                SysLog.out.println(">> " + replaceWith);
                editor.txt.replaceSelection(replaceWith);
            }
        }
    }

    public static class FindPrevious
    extends AbstractAction2
    implements FindDialogCallBack {
        public FindPrevious() {
            super("Find Previous", new ImageIcon("images/ide_empty.gif"));
            this.putValue("ShortDescription", "Find Previous");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift F3"));
            this.putValue("MnemonicKey", new Integer(118));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE ide = WhileIDE.ide;
            CodeTextEditor editor = ide.editor();
            if (editor == null) {
                return;
            }
            if (findDialog == null || !findDialog.hasText()) {
                findDialog = new FindDialog(ide.frame);
                findDialog.show(this);
            } else {
                findDialog.findPrevious(editor);
            }
        }

        public void findApproved(FindDialog findDialog) {
            findDialog.findPrevious(WhileIDE.ide.editor());
        }
    }

    public static class FindNext
    extends AbstractAction2
    implements FindDialogCallBack {
        public FindNext() {
            super("Find Next", new ImageIcon("images/ide_empty.gif"));
            this.putValue("ShortDescription", "Find Next");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F3"));
            this.putValue("MnemonicKey", new Integer(110));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE ide = WhileIDE.ide;
            CodeTextEditor editor = ide.editor();
            if (editor == null) {
                return;
            }
            if (findDialog == null || !findDialog.hasText()) {
                findDialog = new FindDialog(ide.frame);
                findDialog.show(this);
                if (findDialog.isCanceled()) {
                    return;
                }
            } else {
                findDialog.findText(editor);
            }
        }

        public void findApproved(FindDialog findDialog) {
            findDialog.findText(WhileIDE.ide.editor());
        }
    }

    public static class FindAction
    extends AbstractAction2
    implements FindDialogCallBack {
        public FindAction() {
            super("Find...", new ImageIcon("images/action/find.png"));
            this.putValue("ShortDescription", "Find...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F"));
            this.putValue("MnemonicKey", new Integer(70));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE ide = WhileIDE.ide;
            CodeTextEditor editor = ide.editor();
            if (editor == null) {
                return;
            }
            if (findDialog == null) {
                findDialog = new FindDialog(ide.frame);
            }
            findDialog.show(this);
        }

        public void findApproved(FindDialog findDialog) {
            CodeTextEditor editor = WhileIDE.ide.editor();
            if (findDialog.isCanceled()) {
                return;
            }
            findDialog.findText(editor);
        }
    }
}

