/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.searchreplace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import whilepack.SysLog;
import whilepack.gui.CodeTextEditor;
import whilepack.gui.WhileIDE;
import whilepack.gui.searchreplace.FindDialogCallBack;
import whilepack.gui.searchreplace.SearchUtils;
import widex.layout.SpecLayout;
import widex.layout.SpecPanel;
import widex.utils.Utils;

public class FindDialog
extends JDialog {
    private JComboBox cbxFindWhat;
    private JCheckBox chkMatchWholeWords;
    private JCheckBox chkMatchCase;
    private boolean canceled;
    private Action findAction = new FindAction();
    private JButton btnFind;
    private String findWhatText = null;
    private String replaceWith = null;
    private FindDialogCallBack callBack;
    private JComboBox cbxReplaceWith = null;
    private boolean showReplace = true;
    private JLabel lblReplaceWith;
    private static final String TITLE_FIND = "Find Text";
    private static final String TITLE_REPLCAE_STRING = "Replace Text";
    private String originalFindWhatText = "";

    public FindDialog(Frame owner) {
        super(owner, TITLE_REPLCAE_STRING, false);
        int i;
        this.cbxFindWhat = new JComboBox();
        this.cbxFindWhat.setEditable(true);
        JTextField editor = (JTextField)this.cbxFindWhat.getEditor().getEditorComponent();
        editor.getDocument().addDocumentListener(new ThisListener());
        ActionListener[] als = editor.getActionListeners();
        for (i = 0; i < als.length; ++i) {
            editor.removeActionListener(als[i]);
        }
        this.cbxReplaceWith = new JComboBox();
        this.cbxReplaceWith.setEditable(true);
        editor = (JTextField)this.cbxReplaceWith.getEditor().getEditorComponent();
        editor.getDocument().addDocumentListener(new ThisListener());
        als = editor.getActionListeners();
        for (i = 0; i < als.length; ++i) {
            editor.removeActionListener(als[i]);
        }
        JPanel p = new JPanel((LayoutManager)new SpecLayout("P,5,FILL", "P,5,P"));
        JLabel lblFindWhat = new JLabel("Find What:");
        lblFindWhat.setLabelFor(this.cbxFindWhat);
        lblFindWhat.setDisplayedMnemonic('n');
        p.add((Component)lblFindWhat, "0,0, vAlign=CENTER");
        p.add((Component)this.cbxFindWhat, "2,0");
        this.lblReplaceWith = new JLabel("Replace With:");
        this.lblReplaceWith.setLabelFor(this.cbxReplaceWith);
        this.lblReplaceWith.setDisplayedMnemonic('R');
        p.add((Component)this.lblReplaceWith, "0,2, vAlign=CENTER");
        p.add((Component)this.cbxReplaceWith, "2,2");
        this.findAction.setEnabled(false);
        this.btnFind = new JButton(this.findAction);
        final JButton btnCancel = new JButton(new CancelAction());
        SpecPanel buttons = new SpecPanel("X");
        buttons.addFill();
        buttons.add((Component)this.btnFind, (Object)"M");
        buttons.add("5");
        buttons.add((Component)btnCancel, (Object)"M");
        this.chkMatchWholeWords = new JCheckBox("Match whole words");
        this.chkMatchWholeWords.setMnemonic('w');
        this.chkMatchCase = new JCheckBox("Match case");
        this.chkMatchCase.setMnemonic('a');
        SpecPanel options = new SpecPanel("Y", "FILL");
        options.add((Component)p);
        options.add("5");
        options.add((Component)this.chkMatchCase);
        options.add("5");
        options.add((Component)this.chkMatchWholeWords);
        options.add("5");
        options.add((Component)buttons);
        options.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)options);
        this.pack();
        this.setSize(350, this.getHeight());
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        Utils.addEscKeyAction((JComponent)this.getRootPane(), (ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                btnCancel.doClick();
            }
        });
    }

    private void doClose() {
        SysLog.out.println("NOW =  " + this.originalFindWhatText);
        this.cbxFindWhat.getModel().setSelectedItem(this.originalFindWhatText);
        this.cbxFindWhat.setSelectedItem(this.originalFindWhatText);
        this.dispose();
    }

    public boolean hasText() {
        return this.findWhatText != null;
    }

    private String getFindWhatText() {
        return this.findWhatText;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void show(FindDialogCallBack callBack) {
        this.show(callBack, false);
    }

    public void show(FindDialogCallBack callBack, boolean showReplace) {
        Object selectedItem = this.cbxFindWhat.getModel().getSelectedItem();
        String string = this.originalFindWhatText = selectedItem == null ? "" : selectedItem.toString();
        if (this.showReplace != showReplace) {
            this.showReplace = showReplace;
            this.updateGui();
        }
        this.callBack = callBack;
        this.canceled = true;
        super.validate();
        this.btnFind.setDefaultCapable(true);
        this.cbxFindWhat.requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.btnFind);
        super.show();
    }

    private void updateGui() {
        this.lblReplaceWith.setVisible(this.showReplace);
        this.cbxReplaceWith.setVisible(this.showReplace);
        if (this.showReplace) {
            this.setTitle(TITLE_REPLCAE_STRING);
        } else {
            this.setTitle(TITLE_FIND);
        }
    }

    public static void main(String[] args) {
        FindDialog x = new FindDialog(null);
        x.setLocationRelativeTo(null);
        x.show();
        SysLog.out.println("S");
        x.show();
    }

    public boolean findText(CodeTextEditor editor) {
        return this.findText(editor, true);
    }

    public boolean findText(CodeTextEditor editor, boolean showMsg) {
        SearchUtils x = new SearchUtils(editor, this.getFindWhatText(), this.chkMatchCase.isSelected(), this.chkMatchWholeWords.isSelected());
        boolean foundAny = x.findTextFromCaret();
        if (!foundAny && showMsg) {
            WhileIDE.okDialog("The specified text was not found.");
        }
        return foundAny;
    }

    public void findPrevious(CodeTextEditor editor) {
        SearchUtils x = new SearchUtils(editor, this.getFindWhatText(), this.chkMatchCase.isSelected(), this.chkMatchWholeWords.isSelected());
        boolean foundAny = x.findPreviousTextFromCaret();
        if (!foundAny) {
            WhileIDE.okDialog("The specified text was not found.");
        }
    }

    public String getReplaceWithText() {
        return this.replaceWith;
    }

    class ThisListener
    implements DocumentListener {
        ThisListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.check(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.check(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.check(e);
        }

        void check(DocumentEvent e) {
            FindDialog.this.findAction.setEnabled(e.getDocument().getLength() != 0);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel", null);
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            FindDialog.this.doClose();
        }
    }

    class FindAction
    extends AbstractAction {
        public FindAction() {
            super("Find", null);
            this.putValue("MnemonicKey", new Integer(70));
        }

        public void actionPerformed(ActionEvent e) {
            FindDialog.this.cbxFindWhat.getModel().setSelectedItem(FindDialog.this.cbxFindWhat.getEditor().getItem());
            if (FindDialog.this.showReplace) {
                FindDialog.this.cbxReplaceWith.getModel().setSelectedItem(FindDialog.this.cbxReplaceWith.getEditor().getItem());
            }
            FindDialog.this.canceled = false;
            FindDialog.this.findWhatText = FindDialog.this.cbxFindWhat.getSelectedItem().toString();
            if (FindDialog.this.showReplace) {
                FindDialog.this.replaceWith = FindDialog.this.cbxReplaceWith.getSelectedItem().toString();
            }
            FindDialog.this.dispose();
            FindDialog.this.callBack.findApproved(FindDialog.this);
        }
    }
}

