/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import whilepack.gui.print.PrintingOptions;

public class PrintText {
    private Book pages_ = new Book();
    private int wrapOffset_ = 0;
    private String docTitle_;
    private String[] text_;
    private PrintingOptions printOptions_;
    private int tabSize_ = 4;

    public PrintText(PlainDocument document) {
        this(document, "", new PrintingOptions(), false, 4);
    }

    public PrintText(PlainDocument document, String docTitle, PrintingOptions printOptions, boolean softTabs, int tabSize) {
        this.printOptions_ = printOptions;
        this.tabSize_ = tabSize;
        this.docTitle_ = docTitle != null ? docTitle : "New Document";
        Element root = document.getDefaultRootElement();
        int count = root.getElementCount();
        String[] lines = new String[count];
        Segment segment = new Segment();
        for (int i = 0; i < count; ++i) {
            Element lineElement = root.getElement(i);
            try {
                document.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset(), segment);
                lines[i] = segment.toString();
                continue;
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
        this.text_ = lines;
        this.printTextArray();
    }

    PrintText(String[] text) {
        this.printOptions_ = new PrintingOptions();
        this.text_ = text;
        this.printTextArray();
    }

    PrintText(String[] text, Font font) {
        this.printOptions_ = new PrintingOptions();
        this.text_ = text;
        this.printTextArray();
    }

    void printTextArray() {
        PageFormat pgfmt = this.printOptions_.getPageFormat();
        Font pageFont = this.printOptions_.getPageFont();
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            this.text_ = this.removeEOLChar();
            if (this.printOptions_.getPrintLineNumbers()) {
                this.text_ = this.addLineNumbers();
            }
            if (this.printOptions_.getWrapText()) {
                this.text_ = this.wrapText();
            }
            this.pages_ = this.pageinateText();
            try {
                job.setPageable(this.pages_);
                if (job.printDialog()) {
                    job.print();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Printer Error", "Error", 0);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Printer Error", "Error", 0);
        }
    }

    private String[] removeEOLChar() {
        int lineCount = this.text_.length;
        String[] newText = new String[lineCount];
        int offset = 0;
        for (int i = 0; i < lineCount; ++i) {
            if (this.text_[i].length() == 1) {
                newText[i] = " ";
                continue;
            }
            String temp1 = this.text_[i].substring(this.text_[i].length() - 2, this.text_[i].length() - 1);
            String temp2 = this.text_[i].substring(this.text_[i].length() - 1, this.text_[i].length());
            offset = temp1.compareTo("\r") == 0 || temp1.compareTo("\n") == 0 ? 2 : (temp2.compareTo("\r") == 0 || temp2.compareTo("\n") == 0 ? 1 : 0);
            String temp3 = this.text_[i].substring(0, this.text_[i].length() - offset);
            StringBuffer temp4 = new StringBuffer();
            int length = temp3.length();
            for (int j = 0; j < length; ++j) {
                if ("\t".equals(temp3.substring(j, j + 1))) {
                    int numSpaces = temp4.length() % this.tabSize_;
                    if (numSpaces == 0) {
                        numSpaces = this.tabSize_;
                    }
                    for (int x = 0; x < numSpaces; ++x) {
                        temp4.append(" ");
                    }
                    continue;
                }
                temp4.append(temp3.substring(j, j + 1));
            }
            newText[i] = temp4.toString();
        }
        return newText;
    }

    private String[] addLineNumbers() {
        int numLines = this.text_.length;
        int totalNumSpaces = 0;
        String[] newText = new String[numLines];
        Integer lines = new Integer(numLines);
        String temp = lines.toString();
        totalNumSpaces = temp.length();
        this.wrapOffset_ = totalNumSpaces + 3;
        for (int i = 0; i < numLines; ++i) {
            StringBuffer num = new StringBuffer();
            num.append(i + 1);
            int numLen = num.length();
            StringBuffer lineNum = new StringBuffer();
            for (int j = 0; j < totalNumSpaces - numLen; ++j) {
                lineNum.append(' ');
            }
            lineNum.append(num.toString());
            newText[i] = lineNum.toString() + ".  " + this.text_[i];
        }
        return newText;
    }

    private String[] wrapText() {
        String currentLine = null;
        Vector<String> temp = new Vector<String>();
        int lineCount = this.text_.length;
        int newLineCount = 0;
        StringBuffer wrapSpaces = new StringBuffer("");
        int i = 0;
        PageFormat pgfmt = this.printOptions_.getPageFormat();
        Font pageFont = this.printOptions_.getPageFont();
        double pageWidth = pgfmt.getImageableWidth();
        for (i = 0; i < this.wrapOffset_; ++i) {
            wrapSpaces.append(' ');
        }
        for (i = 0; i < lineCount; ++i) {
            currentLine = this.text_[i];
            while (true) {
                FontRenderContext fontRenderContext = new FontRenderContext(pageFont.getTransform(), false, false);
                if (!(pageFont.getStringBounds(currentLine, fontRenderContext).getWidth() > pageWidth)) break;
                int numChars = (int)((double)currentLine.length() * pageWidth / pageFont.getStringBounds(currentLine, new FontRenderContext(pageFont.getTransform(), false, false)).getWidth());
                temp.add(currentLine.substring(0, numChars));
                currentLine = wrapSpaces.toString() + currentLine.substring(numChars, currentLine.length());
            }
            temp.add(currentLine);
        }
        newLineCount = temp.size();
        String[] newText = new String[newLineCount];
        for (int j = 0; j < newLineCount; ++j) {
            newText[j] = (String)temp.get(j);
        }
        return newText;
    }

    private Book pageinateText() {
        Book book = new Book();
        int linesPerPage = 0;
        int currentLine = 0;
        int pageNum = 0;
        PageFormat pgfmt = this.printOptions_.getPageFormat();
        Font pageFont = this.printOptions_.getPageFont();
        int height = (int)pgfmt.getImageableHeight();
        int pages = 0;
        linesPerPage = height / (pageFont.getSize() + 2);
        pages = this.text_.length / linesPerPage;
        this.convertUnprintables();
        if (this.printOptions_.getPrintHeader()) {
            linesPerPage -= 2;
        }
        while (pageNum <= pages) {
            String[] pageText = new String[linesPerPage];
            for (int x = 0; x < linesPerPage; ++x) {
                String readString;
                try {
                    readString = this.text_[currentLine];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    readString = " ";
                }
                pageText[x] = readString;
                ++currentLine;
            }
            book.append(new Page(pageText, ++pageNum), pgfmt);
        }
        return book;
    }

    private void convertUnprintables() {
        int i = this.text_.length;
        while (i > 0) {
            String tempString;
            if ((tempString = this.text_[--i]) != null && !"".equals(tempString)) continue;
            this.text_[i] = " ";
        }
    }

    class PrintableText {
        private Font font_;
        private boolean newLine_ = true;
        private String text_;

        PrintableText() {
        }

        PrintableText(String text, Font font, boolean newLine) {
            this.text_ = text;
            this.font_ = font;
            this.newLine_ = newLine;
        }

        String getText() {
            return this.text_;
        }

        void setText(String text) {
            this.text_ = text;
        }

        Font getFont() {
            return this.font_;
        }

        void setFont(Font font) {
            this.font_ = font;
        }

        boolean isNewLine() {
            return this.newLine_;
        }

        void setNewLine(boolean newLine) {
            this.newLine_ = newLine;
        }
    }

    class Page
    implements Printable {
        private String[] pageText_;
        private int pageNumber_ = 0;

        Page(String[] text, int pageNum) {
            this.pageText_ = text;
            this.pageNumber_ = pageNum;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            int pos;
            int posOffset = 1;
            double pageWidth = pageFormat.getImageableWidth();
            Font pageFont = PrintText.this.printOptions_.getPageFont();
            if (PrintText.this.printOptions_.getPrintHeader()) {
                StringBuffer header = new StringBuffer();
                StringBuffer pageNumText = new StringBuffer();
                boolean i = false;
                boolean headerPos = false;
                boolean numSpaces = false;
                Calendar date = Calendar.getInstance();
                header.append(date.get(5));
                header.append('/');
                header.append(date.get(2) + 1);
                header.append('/');
                header.append(date.get(1));
                pageNumText.append("Page ");
                pageNumText.append(this.pageNumber_);
                double margin = (pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2.0;
                graphics.setFont(PrintText.this.printOptions_.getHeaderFont());
                graphics.setColor(Color.black);
                pos = (int)pageFormat.getImageableY() + (PrintText.this.printOptions_.getHeaderFont().getSize() + 2);
                graphics.drawString(header.toString(), (int)pageFormat.getImageableX(), pos);
                int xPos = (int)(pageFormat.getWidth() / 2.0 - (double)(graphics.getFontMetrics().stringWidth(PrintText.this.docTitle_) / 2));
                graphics.drawString(PrintText.this.docTitle_, xPos, pos);
                xPos = (int)(pageFormat.getWidth() - margin - (double)graphics.getFontMetrics().stringWidth(pageNumText.toString()));
                graphics.drawString(pageNumText.toString(), xPos, pos);
                posOffset = 3;
            }
            graphics.setFont(pageFont);
            graphics.setColor(Color.black);
            for (int x = 0; x < this.pageText_.length; ++x) {
                pos = (int)pageFormat.getImageableY() + (pageFont.getSize() + 2) * (x + posOffset);
                graphics.drawString(this.pageText_[x], (int)pageFormat.getImageableX(), pos);
            }
            return 0;
        }
    }
}

