/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import li.netcat.print.PreviewPanel;
import li.netcat.print.Print;
import li.netcat.print.PrintManager;
import whilepack.SysLog;
import whilepack.gui.ToolbarUtils;

public class PrintPreview
extends JPanel
implements ActionListener {
    private static final ImageIcon NEXT_PAGE = new ImageIcon("images/prnt/NextPage.gif");
    private static final ImageIcon PREVIOUS_PAGE = new ImageIcon("images/prnt/PreviousPage.gif");
    private static final ImageIcon ZOOM_IN = new ImageIcon("images/prnt/ZoomIn.gif");
    private static final ImageIcon ZOOM_OUT = new ImageIcon("images/prnt/ZoomOut.gif");
    private static final ImageIcon SCALE_OUT = new ImageIcon("images/prnt/ScaleOut.gif");
    private static final ImageIcon SCALE_IN = new ImageIcon("images/prnt/ScaleIn.gif");
    private static final ImageIcon ORIENTATION = new ImageIcon("images/prnt/Orientation.gif");
    private static final ImageIcon RESET = new ImageIcon("images/prnt/Reset.gif");
    private static final ImageIcon SETUP = new ImageIcon("images/prnt/Setup.gif");
    private static final ImageIcon PRINT = new ImageIcon("images/prnt/Print.gif");
    private PreviewPanel previewPanel;
    private JButton nextPageButton;
    private JButton previousPageButton;
    private JButton zoomOutButton;
    private JButton zoomInButton;
    private JButton scaleOutButton;
    private JButton scaleInButton;
    private JButton orientationButton;
    private JButton resetButton;
    private JButton pageDialogButton;
    private JButton printButton;

    public PrintPreview(Print print) {
        super(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.previewPanel = new PreviewPanel(print);
        this.previewPanel.setResizeMode(PreviewPanel.MODE_NONE);
        this.previewPanel.getPrintManager().setImageableArea(54, 54, 504, 684);
        this.previewPanel.getPrintManager().setImageableArea(30, 30, 504, 730);
        JScrollPane scroller = new JScrollPane((Component)this.previewPanel);
        scroller.getVerticalScrollBar().setUnitIncrement(23);
        scroller.getHorizontalScrollBar().setUnitIncrement(23);
        this.add((Component)scroller, "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, -1, 5, 5));
        JPanel toolBar = new JPanel(new BorderLayout(5, 5));
        toolBar.add((Component)buttonPanel, "West");
        this.add((Component)toolBar, "North");
        this.previousPageButton = this.createButton(PREVIOUS_PAGE, "Previous Page");
        buttonPanel.add(this.previousPageButton);
        this.nextPageButton = this.createButton(NEXT_PAGE, "Next Page");
        buttonPanel.add(this.nextPageButton);
        this.zoomOutButton = this.createButton(ZOOM_OUT, "Zoom Out");
        buttonPanel.add(this.zoomOutButton);
        this.zoomInButton = this.createButton(ZOOM_IN, "Zoom In");
        buttonPanel.add(this.zoomInButton);
        this.scaleOutButton = this.createButton(SCALE_OUT, "Scale Out");
        buttonPanel.add(this.scaleOutButton);
        this.scaleInButton = this.createButton(SCALE_IN, "Scale In");
        buttonPanel.add(this.scaleInButton);
        this.orientationButton = this.createButton(ORIENTATION, "Change Orientation");
        buttonPanel.add(this.orientationButton);
        this.pageDialogButton = this.createButton(SETUP, "Page Setup");
        buttonPanel.add(this.pageDialogButton);
        this.resetButton = this.createButton(RESET, "Reset");
        buttonPanel.add(this.resetButton);
        this.printButton = this.createButton(PRINT, "Print");
        buttonPanel.add(this.printButton);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.nextPageButton) {
            this.previewPanel.nextPage();
        } else if (source == this.previousPageButton) {
            this.previewPanel.previousPage();
        } else if (source == this.zoomOutButton) {
            this.previewPanel.setZoom(this.previewPanel.getZoom() / 1.3);
        } else if (source == this.zoomInButton) {
            this.previewPanel.setZoom(this.previewPanel.getZoom() * 1.3);
        } else if (source == this.scaleOutButton) {
            this.previewPanel.getPrintManager().setScaleValue(this.previewPanel.getPrintManager().getScaleValue() / 1.1);
        } else if (source == this.scaleInButton) {
            this.previewPanel.getPrintManager().setScaleValue(this.previewPanel.getPrintManager().getScaleValue() * 1.1);
        } else if (source == this.orientationButton) {
            int newOrientation = this.previewPanel.getPrintManager().getOrientation() == 1 ? 0 : 1;
            this.previewPanel.getPrintManager().setOrientation(newOrientation);
        } else if (source == this.resetButton) {
            PrintManager pm = this.previewPanel.getPrintManager();
            pm.setPageFormat(pm.getPrinterJob().defaultPage());
            pm.setScaleValue(1.0);
            this.previewPanel.setZoom(1.0);
        } else if (source == this.pageDialogButton) {
            this.previewPanel.getPrintManager().pageDialog(true);
            SysLog.out.println(this.previewPanel.getPrintManager().getImageableX());
            SysLog.out.println(this.previewPanel.getPrintManager().getImageableY());
            SysLog.out.println(this.previewPanel.getPrintManager().getImageableWidth());
            SysLog.out.println(this.previewPanel.getPrintManager().getImageableHeight());
        } else if (source == this.printButton) {
            try {
                this.previewPanel.getPrintManager().print(true);
            }
            catch (PrinterException x) {
                x.printStackTrace();
            }
        }
    }

    public JFrame open() {
        return this.open("Print Preview");
    }

    public JFrame open(String title) {
        JFrame frame = new JFrame(title);
        frame.setContentPane(this);
        frame.setSize(780, 580);
        frame.setDefaultCloseOperation(2);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.toFront();
        return frame;
    }

    public PreviewPanel getPreviewPanel() {
        return this.previewPanel;
    }

    private JButton createButton(ImageIcon icon, String toolTip) {
        JButton button = ToolbarUtils.createToolbarButton(icon);
        button.setFocusable(false);
        button.setToolTipText(toolTip);
        button.addActionListener(this);
        button.setPreferredSize(new Dimension(28, 26));
        return button;
    }
}

