/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.print;

import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import li.netcat.print.Print;
import li.netcat.print.util.GridPrint;
import li.netcat.print.util.GridPrintConstraints;
import li.netcat.print.util.ImagePrint;
import li.netcat.print.util.PageDecorator;
import li.netcat.print.util.PageNumber;
import li.netcat.print.util.PageNumberPrint;
import li.netcat.print.util.PagePrint;
import li.netcat.print.util.TextPrint;
import whilepack.cid.WhileUtils;
import whilepack.gui.print.LinePrint;
import whilepack.gui.print.PrintPreview;
import widex.utils.PropertyBag;
import widex.utils.Utils;

public class HeaderFooterExample {
    public static void main(String[] args) {
        PrintPreview printPreview = new PrintPreview((Print)new PagePrint(HeaderFooterExample.createPrint(new File("Study/CaseAndLists.while")), HeaderFooterExample.createPageDecorator("A")));
        printPreview.open();
    }

    public void showDialog(String text) {
    }

    public static Print createPrint(File file) {
        String text = "";
        try {
            text = WhileUtils.readFile(file);
        }
        catch (IOException e) {
            text = "???";
        }
        return HeaderFooterExample.createPrint(text);
    }

    public static Print createPrint(String text) {
        text = text.replaceAll("\t", "    ");
        TextPrint codeText = new TextPrint(text);
        codeText.setFont(new Font("Monospaced", 0, 10));
        return codeText;
    }

    public static PageDecorator createPageDecorator(String fileName) {
        return new MyPageDecorator(fileName);
    }

    private static class MyPageDecorator
    implements PageDecorator {
        private static Image LOGO = Toolkit.getDefaultToolkit().createImage("build/images/mta.gif");
        private Print headerPrint;
        private String headerText;
        private String footerText;

        public MyPageDecorator(String fileName) {
            PropertyBag pb = new PropertyBag("print.ini", true);
            this.headerText = pb.get("header", "WIDE");
            this.footerText = pb.get("footer", "{FN}");
            this.headerText = Utils.replace((String)this.headerText, (String)"{FN}", (String)fileName);
            this.footerText = Utils.replace((String)this.footerText, (String)"{FN}", (String)fileName);
            TextPrint textPrint = new TextPrint(this.headerText);
            textPrint.setFont(new Font("Tahoma", 0, 12));
            ImagePrint imagePrint = new ImagePrint(LOGO, 104, 18);
            GridPrintConstraints c = GridPrintConstraints.DEFAULT;
            GridPrint gp = new GridPrint();
            gp.add((Print)textPrint, c.colSpan(1));
            gp.add((Print)imagePrint, c.colWidthPreferred());
            gp.add((Print)new LinePrint());
            this.headerPrint = gp;
        }

        public Print createHeader(PageNumber number) {
            return this.headerPrint;
        }

        public int getHeaderGap(PageNumber number) {
            return 0;
        }

        public Print createFooter(PageNumber number) {
            TextPrint textPrint = new TextPrint(this.footerText);
            textPrint.setFont(new Font("Tahoma", 0, 10));
            GridPrint gp = new GridPrint();
            GridPrintConstraints c = GridPrintConstraints.DEFAULT;
            gp.add((Print)new LinePrint());
            gp.add((Print)textPrint, c.colSpan(1));
            gp.add((Print)new PageNumberPrint(number), c.hAlignRight().colWidthPreferred());
            return gp;
        }

        public int getFooterGap(PageNumber number) {
            return 5;
        }
    }
}

