/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.options;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import whilepack.general.SugarHandler;
import whilepack.gui.WhileIDE;
import whilepack.gui.syntaxutils.WideSyntaxHandler;
import widex.layout.SpecPanel;
import widex.utils.Utils;

public class OptionsDialog
extends JDialog {
    private JCheckBox chkBooleansSugar;
    private JCheckBox chkListSugar;
    private JCheckBox chkElseSugar;
    private JCheckBox chkCasetSugar;
    private boolean canceled = true;

    public OptionsDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        boolean b = SugarHandler.isBooleansSugarActive();
        boolean c = SugarHandler.isCaseSugarActive();
        boolean e = SugarHandler.isElseSugarActive();
        boolean l = SugarHandler.isListSuagrActive();
        this.chkListSugar = new JCheckBox("List Sugar", l);
        this.chkElseSugar = new JCheckBox("Else Sugar", e);
        this.chkCasetSugar = new JCheckBox("Case Sugar", c);
        this.chkBooleansSugar = new JCheckBox("Booleans Sugar", b);
        SpecPanel checkboxes = new SpecPanel("Y", "P");
        checkboxes.add((Component)this.chkListSugar);
        checkboxes.add((Component)this.chkElseSugar);
        checkboxes.add((Component)this.chkCasetSugar);
        checkboxes.add((Component)this.chkBooleansSugar);
        JButton btnOK = new JButton("OK");
        JButton btnCancel = new JButton("Cancel");
        JButton btnHelp = new JButton("Help");
        SpecPanel buttons = new SpecPanel("X");
        buttons.addFill();
        buttons.add((Component)btnOK, (Object)"M");
        buttons.addGap(5);
        buttons.add((Component)btnCancel, (Object)"M");
        buttons.addGap(5);
        buttons.add((Component)btnHelp, (Object)"M");
        btnOK.addActionListener(new ApproveAction());
        btnCancel.addActionListener(new CancelAction());
        btnHelp.addActionListener(new HelpAction());
        btnOK.setDefaultCapable(true);
        SpecPanel mainPanel = new SpecPanel("Y", "FILL");
        mainPanel.add((Component)checkboxes);
        mainPanel.addGap(5);
        mainPanel.add((Component)new JSeparator());
        mainPanel.addGap(10);
        mainPanel.add((Component)buttons);
        mainPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add((Component)mainPanel);
        this.getRootPane().setDefaultButton(btnOK);
        Utils.makeHideOnEscape((JDialog)this);
        this.pack();
        this.setSize(300, this.getHeight());
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        Utils.makeHideOnEscape((JDialog)this);
    }

    public void show() {
        this.canceled = true;
        super.show();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void processChanges() {
        boolean b = this.chkBooleansSugar.isSelected();
        boolean l = this.chkListSugar.isSelected();
        boolean e = this.chkElseSugar.isSelected();
        boolean c = this.chkCasetSugar.isSelected();
        boolean changed = false;
        if (b != SugarHandler.isBooleansSugarActive()) {
            changed = true;
        }
        if (c != SugarHandler.isCaseSugarActive()) {
            changed = true;
        }
        if (e != SugarHandler.isElseSugarActive()) {
            changed = true;
        }
        if (l != SugarHandler.isListSuagrActive()) {
            changed = true;
        }
        if (!changed) {
            return;
        }
        SugarHandler.setBooleansSugarActive(b);
        SugarHandler.setCaseSugarActive(c);
        SugarHandler.setElseSugarActive(e);
        SugarHandler.setListSuagrActive(l);
        WideSyntaxHandler.refreshSyntax();
        WideSyntaxHandler.refreshCodeTextEditor();
    }

    class HelpAction
    implements ActionListener {
        HelpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JEditorPane jEditorPane = new JEditorPane(new File("help/options/sugars.html").toURL());
                JScrollPane scrollPane = new JScrollPane(jEditorPane);
                jEditorPane.setEditable(false);
                JDialog x = new JDialog(OptionsDialog.this, "Help", true);
                x.getContentPane().add(scrollPane);
                x.setSize(500, 300);
                x.setLocationRelativeTo(OptionsDialog.this);
                Utils.makeHideOnEscape((JDialog)x);
                x.show();
                x.dispose();
            }
            catch (Exception e1) {
                WhileIDE.okDialog("Cannot find help file", true);
            }
        }
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.dispose();
        }
    }

    class ApproveAction
    implements ActionListener {
        ApproveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.canceled = false;
            OptionsDialog.this.dispose();
        }
    }
}

