/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import whilepack.gui.ToolbarUtils;
import whilepack.gui.help.HelpElement;
import whilepack.gui.help.HelpParser;
import whilepack.gui.help.IHTMLPanel;
import whilepack.gui.help.SimpleHTMLPanel;
import whilepack.gui.help.WebWindowPanel;
import widex.layout.SpecPanel;
import widex.utils.Dialogs;
import widex.utils.Gaps;
import widex.utils.TreeSelectionDelay;
import widex.utils.Utils;

public class HelpWindow {
    JButton m_btnBack = null;
    JButton m_btnForward = null;
    JButton m_btnSearch = null;
    JTextField m_txtSearch = null;
    JList m_list;
    JTree m_tree;
    IHTMLPanel m_view;
    Border goMark;
    JButton m_btnToggleTabs = null;
    JTabbedPane m_tabbedPane = null;
    JSplitPane m_splitPane = null;
    ImageIcon m_showIcon = new ImageIcon("images/help_window_show_tabs.gif");
    ImageIcon m_hideIcon = new ImageIcon("images/help_window_hide_tabs.gif");
    String m_hideText = "Hide";
    String m_showText = "Show";
    HashMap helpTopics = new HashMap();
    int m_historyIndex = -1;
    int m_historySize = 10;
    HelpElement[] m_history = new HelpElement[this.m_historySize];
    Stack m_backStack = new Stack();
    Stack m_forwardStack = new Stack();
    JFrame frame;
    JPanel m_mainPanel = null;
    int divSize = 0;
    int divLocation = 0;
    int last = 160;

    public HelpWindow(String helpFile) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        try {
            HelpElement[] topics = HelpParser.parse(new File(helpFile));
            this.load(topics, root);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.m_btnBack = ToolbarUtils.createToolbarButton("Back");
        this.m_btnForward = ToolbarUtils.createToolbarButton("Forward");
        this.m_view = new File("hook.txt").exists() ? new WebWindowPanel() : new SimpleHTMLPanel();
        this.m_tree = new JTree(root);
        this.m_btnSearch = new JButton();
        this.m_txtSearch = new JTextField();
        this.m_list = new JList();
        this.m_btnBack.setFocusable(false);
        this.m_btnForward.setFocusable(false);
        Border obb = this.m_view.getComponent().getBorder();
        this.m_view.getComponent().setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), obb));
        this.goMark = new CompoundBorder(new LineBorder(Color.gray), obb);
        this.m_btnBack.setVerticalTextPosition(3);
        this.m_btnBack.setHorizontalTextPosition(0);
        this.m_btnForward.setVerticalTextPosition(3);
        this.m_btnForward.setHorizontalTextPosition(0);
        this.m_btnToggleTabs = ToolbarUtils.createToolbarButton("");
        this.m_btnToggleTabs.setVerticalTextPosition(3);
        this.m_btnToggleTabs.setHorizontalTextPosition(0);
        this.m_btnToggleTabs.setIcon(this.m_hideIcon);
        this.m_btnToggleTabs.setText(this.m_hideText);
        this.m_btnToggleTabs.addActionListener(new ToggleTabsAction());
        this.m_btnBack.addActionListener(new HistoryBackAction());
        this.m_btnForward.addActionListener(new HistoryForwardAction());
        SpecPanel toolBar = new SpecPanel("X", "P2");
        Insets insets = new Insets(0, 4, 0, 4);
        this.m_btnBack.setMargin(insets);
        this.m_btnForward.setMargin(insets);
        this.m_btnToggleTabs.setMargin(insets);
        this.m_btnBack.setIcon(new ImageIcon("images/left.png"));
        this.m_btnForward.setIcon(new ImageIcon("images/right.png"));
        Utils.sizeToMaxWidth((JComponent)this.m_btnBack, (JComponent)this.m_btnForward, (JComponent)this.m_btnToggleTabs);
        toolBar.add((Component)this.m_btnBack);
        toolBar.add(Gaps.h((int)5));
        toolBar.add((Component)this.m_btnForward);
        toolBar.add(Gaps.h((int)5));
        toolBar.add((Component)this.m_btnToggleTabs);
        DefaultTreeCellRenderer cr = new DefaultTreeCellRenderer();
        this.m_tree.setCellRenderer(cr);
        this.m_tree.setRootVisible(false);
        this.m_tree.expandRow(0);
        this.expandAll(this.m_tree, true);
        TreeSelectionDelay.configureTree((JTree)this.m_tree, (TreeSelectionListener)new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (e.getPath().getLastPathComponent() != null) {
                    DefaultMutableTreeNode r = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                    HelpElement topic = (HelpElement)r.getUserObject();
                    if (topic.url.length() > 0) {
                        try {
                            HelpWindow.this.showPage(new URL("file:" + topic.url));
                        }
                        catch (Exception exp) {
                            exp.printStackTrace();
                        }
                    } else {
                        Border v = HelpWindow.this.m_view.getComponent().getBorder();
                        HelpWindow.this.m_view.getComponent().setBorder(HelpWindow.this.goMark);
                        SwingUtilities.invokeLater(new Runnable(this, v){
                            private final /* synthetic */ Border val$v;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$v = val$v;
                            }

                            public void run() {
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                1.access$000(this.this$1).m_view.getComponent().setBorder(this.val$v);
                            }
                        });
                    }
                }
            }

            static /* synthetic */ HelpWindow access$000(1 x0) {
                return x0.HelpWindow.this;
            }
        });
        cr.setOpenIcon(new ImageIcon("images/help_window_tree_open.gif"));
        cr.setClosedIcon(new ImageIcon("images/help_window_tree_closed.gif"));
        cr.setLeafIcon(new ImageIcon("images/help_window_tree_leaf.gif"));
        JScrollPane treeScroller = new JScrollPane(this.m_tree);
        treeScroller.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), treeScroller.getBorder()));
        JPanel btnSearchPanel = new JPanel();
        btnSearchPanel.setLayout(new BoxLayout(btnSearchPanel, 2));
        btnSearchPanel.add(Box.createHorizontalGlue());
        btnSearchPanel.add(this.m_btnSearch);
        Utils.fixCompHeight((JComponent)this.m_txtSearch, (int)21);
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.addTab("Contents", treeScroller);
        this.m_tabbedPane.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.m_splitPane = new JSplitPane(1, this.m_tabbedPane, this.m_view.getComponent());
        this.m_splitPane.setResizeWeight(0.0);
        this.m_splitPane.setBorder(new CompoundBorder(new CompoundBorder(new MatteBorder(1, 0, 0, 0, Color.gray), new MatteBorder(1, 0, 0, 0, Color.white)), new EmptyBorder(0, 0, 0, 0)));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BorderLayout());
        this.m_mainPanel.add((Component)toolBar, "North");
        this.m_mainPanel.add((Component)this.m_splitPane, "Center");
        this.buildFrame();
        if (Utils.getOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            this.m_splitPane.setDividerLocation(this.m_splitPane.getWidth() - this.m_tree.getPreferredSize().width - 30);
        } else {
            this.m_splitPane.setDividerLocation(160);
        }
    }

    public void buildFrame() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = new JFrame("WIDE Help");
        this.frame.setIconImage(new ImageIcon("images/help_window_icon.gif").getImage());
        this.frame.getContentPane().setLayout(new GridLayout(1, 1));
        this.frame.getContentPane().add(this.m_mainPanel);
        this.frame.applyComponentOrientation(Utils.getOrientation());
        this.frame.setDefaultCloseOperation(1);
        Utils.addEscKeyFeature((Component)this.frame, (JRootPane)this.frame.getRootPane());
        this.frame.pack();
        this.frame.setSize(550, 450);
        this.frame.setLocationRelativeTo(null);
        this.frame.pack();
        this.frame.setSize(790, 580);
        this.frame.setLocationRelativeTo(null);
    }

    void load(HelpElement[] topics, DefaultMutableTreeNode parent) {
        for (int i = 0; i < topics.length; ++i) {
            HelpElement topic = topics[i];
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(topic);
            this.helpTopics.put(topic.id, topic);
            this.load(topic.getList(), node);
            parent.add(node);
        }
    }

    Component[] getCompsFromPane(Container c) {
        ArrayList comps = new ArrayList();
        this.listAll(comps, "", c);
        return comps.toArray(new Component[0]);
    }

    void listAll(ArrayList comps, String indent, Container c) {
        Component[] cs = c.getComponents();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] instanceof Container) {
                indent = indent + "  ";
                this.listAll(comps, indent, (Container)cs[i]);
            }
            if (cs[i] instanceof JButton) {
                comps.add(cs[i]);
            }
            if (cs[i] instanceof JTree) {
                comps.add(cs[i]);
            }
            if (cs[i] instanceof JEditorPane) {
                comps.add(cs[i]);
            }
            if (cs[i] instanceof JTextField) {
                comps.add(cs[i]);
            }
            if (!(cs[i] instanceof JList)) continue;
            comps.add(cs[i]);
        }
    }

    public void showHelpWindow() {
        this.frame.show();
    }

    public void setTabsVisible(boolean v) {
        if (v) {
            this.showTabs();
        } else {
            this.hideTabs();
        }
    }

    void hideTabs() {
        this.last = this.m_splitPane.getDividerLocation();
        this.m_tabbedPane.setVisible(false);
        this.divLocation = this.m_tabbedPane.getWidth();
        this.divSize = this.m_splitPane.getDividerSize();
        this.m_splitPane.setDividerSize(0);
        this.m_btnToggleTabs.setIcon(this.m_showIcon);
        this.m_btnToggleTabs.setText(this.m_showText);
    }

    void showTabs() {
        this.m_splitPane.setDividerSize(this.divSize);
        this.m_splitPane.setDividerLocation(this.last);
        this.m_tabbedPane.setVisible(true);
        this.m_btnToggleTabs.setIcon(this.m_hideIcon);
        this.m_btnToggleTabs.setText(this.m_hideText);
    }

    void showPage(URL url) {
        this.showPage(url, true);
    }

    void showPage(URL url, boolean clearForwardHistory) {
        if (url.equals(this.m_view.getCurrentPage())) {
            return;
        }
        if (clearForwardHistory) {
            this.m_btnForward.setEnabled(false);
            this.m_forwardStack.clear();
        }
        if (this.m_view.getCurrentPage() != null) {
            this.m_backStack.push(this.m_view.getCurrentPage());
            if (this.m_backStack.size() == 10) {
                this.m_backStack.remove(0);
            }
            this.m_btnBack.setEnabled(true);
        }
        this.showPageOnView(url);
    }

    public void showHelpID(String id) {
        if (this.helpTopics.containsKey(id)) {
            HelpElement hElement = (HelpElement)this.helpTopics.get(id);
            String url = hElement.url;
            try {
                this.showPage(new URL("file:" + url));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.m_tree.getModel().getRoot();
            Enumeration<TreeNode> children = root.preorderEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                if (child.getUserObject() != hElement) continue;
                TreePath tp = new TreePath(child.getPath());
                this.m_tree.setSelectionPath(tp);
                this.m_tree.expandPath(tp);
            }
        }
    }

    void showPageOnView(URL url) {
        try {
            this.m_view.loadPage(url);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void main(String[] args) throws Exception {
        HelpWindow x = new HelpWindow("widehelp.xml");
        x.frame.setDefaultCloseOperation(3);
        x.frame.show();
    }

    class HistoryForwardAction
    implements ActionListener {
        HistoryForwardAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (HelpWindow.this.m_forwardStack.size() == 0) {
                return;
            }
            HelpWindow.this.showPage((URL)HelpWindow.this.m_forwardStack.pop(), false);
            HelpWindow.this.m_btnForward.setEnabled(HelpWindow.this.m_forwardStack.size() != 0);
        }
    }

    class HistoryBackAction
    implements ActionListener {
        HistoryBackAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (HelpWindow.this.m_backStack.size() == 0) {
                return;
            }
            if (HelpWindow.this.m_view.getCurrentPage() != null) {
                HelpWindow.this.m_forwardStack.push(HelpWindow.this.m_view.getCurrentPage());
                HelpWindow.this.m_btnForward.setEnabled(true);
                if (HelpWindow.this.m_forwardStack.size() == 10) {
                    HelpWindow.this.m_forwardStack.remove(0);
                }
            }
            HelpWindow.this.showPageOnView((URL)HelpWindow.this.m_backStack.pop());
            HelpWindow.this.m_btnBack.setEnabled(HelpWindow.this.m_backStack.size() != 0);
        }
    }

    class EmptynessListener
    implements DocumentListener,
    FocusListener {
        EmptynessListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.o(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.o(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.o(e);
        }

        void o(DocumentEvent e) {
            HelpWindow.this.m_btnSearch.setEnabled(e.getDocument().getLength() != 0);
        }

        public void focusGained(FocusEvent e) {
            HelpWindow.this.m_txtSearch.setCaretPosition(HelpWindow.this.m_txtSearch.getText().length());
            HelpWindow.this.m_txtSearch.selectAll();
            HelpWindow.this.m_btnSearch.setEnabled(HelpWindow.this.m_txtSearch.getDocument().getLength() != 0);
            JFrame fr = (JFrame)JOptionPane.getFrameForComponent(HelpWindow.this.m_btnSearch);
            fr.getRootPane().setDefaultButton(HelpWindow.this.m_btnSearch);
        }

        public void focusLost(FocusEvent e) {
            HelpWindow.this.m_btnSearch.setEnabled(HelpWindow.this.m_txtSearch.getDocument().getLength() != 0);
            JFrame fr = (JFrame)JOptionPane.getFrameForComponent(HelpWindow.this.m_btnSearch);
            fr.getRootPane().setDefaultButton(null);
        }
    }

    class ToggleTabsAction
    implements ActionListener {
        ToggleTabsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Icon icon = HelpWindow.this.m_btnToggleTabs.getIcon();
            if (icon == HelpWindow.this.m_hideIcon) {
                HelpWindow.this.hideTabs();
            } else {
                HelpWindow.this.showTabs();
            }
        }
    }

    class SearchActionListener
    implements ActionListener {
        ActionListener searchAction;

        SearchActionListener(ActionListener searchAction) {
            this.searchAction = searchAction;
        }

        public void actionPerformed(ActionEvent e) {
            this.searchAction.actionPerformed(e);
            if (HelpWindow.this.m_list.getModel().getSize() == 0) {
                Dialogs.showErrorDialog((Component)HelpWindow.this.m_list, (String)"No Topics Found.", null);
            }
        }
    }
}

