/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import whilepack.SysLog;
import whilepack.gui.ButtonsFisher;
import whilepack.gui.ClipboardMenuHandler;
import whilepack.gui.CodeTextEditor;
import whilepack.gui.DefaultTreeCellRenderer2;
import whilepack.gui.FileNode;
import whilepack.gui.WhileIDE;
import widex.layout.SpecLayout;
import widex.utils.Utils;

public class WideFileView
extends JPanel {
    private DefaultMutableTreeNode m_root = new DefaultMutableTreeNode(this.ROOT);
    private DefaultMutableTreeNode m_abstractRoot = new DefaultMutableTreeNode(this.ABSTRACT);
    private DefaultMutableTreeNode m_concreteRoot = new DefaultMutableTreeNode(this.CONCRETE);
    private DefaultTreeModel m_model;
    private JTree m_tree;
    private String ROOT = "WIDE";
    private String ABSTRACT = "String Notation";
    private String CONCRETE = "List Notation";
    private JScrollPane scroller;

    public WideFileView() {
        this.m_root.add(this.m_abstractRoot);
        this.m_root.add(this.m_concreteRoot);
        this.m_model = new DefaultTreeModel(this.m_root);
        this.m_tree = new JTree(this.m_model){
            private final Color COLOR_1 = Color.white;
            private final Color COLOR_2 = new Color(245, 245, 245);

            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                Paint oldPaint = g2d.getPaint();
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.COLOR_1, this.getWidth(), 0.0f, this.COLOR_2);
                g2d.setPaint(gradientPaint);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setPaint(oldPaint);
                super.paintComponent(g);
            }
        };
        this.m_tree.setOpaque(false);
        this.m_tree.addMouseListener(new ML());
        this.m_tree.setCellRenderer(new TCR());
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    WhileIDE.ide.transferFocusToEditor();
                }
                if (e.getKeyCode() == 10) {
                    WideFileView.this.openFile(false);
                }
            }
        });
        this.scroller = new JScrollPane(this.m_tree);
        this.scroller.getViewport().setBackground(Color.cyan);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.getHorizontalScrollBar().setFocusable(false);
        JLabel label = new JLabel("File View:");
        this.makeFontBold(label);
        label.setBorder(new CompoundBorder(new LineBorder(Color.gray), new EmptyBorder(2, 5, 2, 5)));
        label.setBorder(new CompoundBorder(new EmptyBorder(3, 0, 0, 0), label.getBorder()));
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)label, "North");
        this.add((Component)this.scroller, "Center");
    }

    public void makeFontBold(JLabel label) {
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
    }

    void checkFile(File file) {
        this.checkFile(new FileNode(file));
    }

    void checkFile(FileNode fileNode) {
        boolean isConcrete = fileNode.getFileName().endsWith(".wcl");
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(fileNode);
        if (isConcrete) {
            this.addChild(node, this.m_concreteRoot, this.m_model);
            this.m_tree.expandPath(new TreePath(this.m_concreteRoot.getPath()));
        } else {
            this.addChild(node, this.m_abstractRoot, this.m_model);
            this.m_tree.expandPath(new TreePath(this.m_abstractRoot.getPath()));
        }
    }

    void updateList(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.checkFile(files[i]);
        }
    }

    private void addChild(DefaultMutableTreeNode newChild, DefaultMutableTreeNode parent, DefaultTreeModel model) {
        FileNode newFileNode = (FileNode)newChild.getUserObject();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode curChild = (DefaultMutableTreeNode)parent.getChildAt(i);
            FileNode curFileNode = (FileNode)curChild.getUserObject();
            int compare = newFileNode.toString().compareTo(curFileNode.toString());
            if (compare == 0) {
                if (newFileNode.getFile().equals(curFileNode.getFile())) {
                    return;
                }
                compare = -1;
            }
            if (compare >= 0) continue;
            model.insertNodeInto(newChild, parent, i);
            return;
        }
        model.insertNodeInto(newChild, parent, parent.getChildCount());
    }

    public FileNode getFile(File file) {
        TreePath path = this.findTreePath(file, this.m_concreteRoot);
        if (path == null) {
            path = this.findTreePath(file, this.m_abstractRoot);
        }
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode x = (DefaultMutableTreeNode)path.getLastPathComponent();
        return (FileNode)x.getUserObject();
    }

    public void selectFile(File file) {
        boolean ok = this.selectFileImpl(file, this.m_concreteRoot);
        if (ok) {
            return;
        }
        this.selectFileImpl(file, this.m_abstractRoot);
    }

    private boolean selectFileImpl(File file, DefaultMutableTreeNode parent) {
        TreePath path = this.findTreePath(file, parent);
        if (path == null) {
            return false;
        }
        this.m_tree.setSelectionPath(path);
        this.m_tree.makeVisible(path);
        return true;
    }

    private TreePath findTreePath(File file, DefaultMutableTreeNode parent) {
        FileNode aFileNode = new FileNode(file);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode curChild = (DefaultMutableTreeNode)parent.getChildAt(i);
            FileNode curFileNode = (FileNode)curChild.getUserObject();
            int compare = aFileNode.toString().compareTo(curFileNode.toString());
            if (compare != 0 || !aFileNode.getFile().equals(curFileNode.getFile())) continue;
            return new TreePath(curChild.getPath());
        }
        return null;
    }

    private void openFile(boolean moveFocusToEditor) {
        TreePath tp = this.m_tree.getSelectionPath();
        if (tp == null) {
            return;
        }
        Object o = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
        if (o instanceof FileNode) {
            FileNode fileNode = (FileNode)o;
            WhileIDE.ide.m_openAction.openFile(fileNode.getFile(), fileNode.getBreakPoints(), moveFocusToEditor);
        }
    }

    FileNode[] getAllFiles() {
        FileNode fileNode;
        DefaultMutableTreeNode curChild;
        int i;
        ArrayList<FileNode> list = new ArrayList<FileNode>();
        for (i = 0; i < this.m_abstractRoot.getChildCount(); ++i) {
            curChild = (DefaultMutableTreeNode)this.m_abstractRoot.getChildAt(i);
            fileNode = (FileNode)curChild.getUserObject();
            list.add(fileNode);
        }
        for (i = 0; i < this.m_concreteRoot.getChildCount(); ++i) {
            curChild = (DefaultMutableTreeNode)this.m_concreteRoot.getChildAt(i);
            fileNode = (FileNode)curChild.getUserObject();
            list.add(fileNode);
        }
        return list.toArray(new FileNode[0]);
    }

    private void showProperties(File file) {
        JTextField txt = new JTextField(file.getAbsolutePath());
        txt.setFont(txt.getFont().deriveFont((float)txt.getFont().getSize() + 1.0f));
        txt.setEditable(false);
        txt.setCursor(Cursor.getPredefinedCursor(2));
        txt.getCaret().setVisible(true);
        txt.selectAll();
        ClipboardMenuHandler.config(txt);
        long lm = file.lastModified();
        JPanel x = new JPanel((LayoutManager)new SpecLayout("P, 10, 250", "P,10,P"));
        x.add((Component)new JLabel("File Name:"), "0,0");
        x.add((Component)txt, "2,0");
        x.add((Component)new JLabel("Last Modified:"), "0,2");
        x.add((Component)new JLabel(Utils.dateAsText((long)lm) + ", " + Utils.hourAsText((long)lm)), "2,2");
        x.setBorder(new CompoundBorder(new EmptyBorder(8, 8, 8, 8), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 15, 5, 15))));
        JDialog dialog = Utils.createDialog((Component)this, (String)"Properties", (boolean)true);
        dialog.getContentPane().add(x);
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(Utils.windowForComponent((Component)this));
        Utils.makeHideOnEscape((JDialog)dialog);
        dialog.show();
        dialog.dispose();
    }

    class PropertiesAction
    implements ActionListener {
        PropertiesAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TreePath tp = WideFileView.this.m_tree.getSelectionPath();
            if (tp == null) {
                return;
            }
            Object o = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (o instanceof FileNode) {
                FileNode node = (FileNode)o;
                File file = node.getFile();
                WideFileView.this.showProperties(file);
            }
        }
    }

    class OpenMatchingSource
    implements ActionListener {
        OpenMatchingSource() {
        }

        public void actionPerformed(ActionEvent e) {
            TreePath tp = WideFileView.this.m_tree.getSelectionPath();
            if (tp == null) {
                return;
            }
            Object o = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (o instanceof FileNode) {
                FileNode node = (FileNode)o;
                File otherFile = null;
                if (node.getType() == 0) {
                    File file = node.getFile();
                    otherFile = new File(file.getParentFile(), this.wclIT(file.getName()));
                } else {
                    File file = node.getFile();
                    otherFile = new File(file.getParentFile(), this.wctIT(file.getName()));
                }
                if (otherFile.exists()) {
                    WhileIDE.ide.m_openAction.openFile(otherFile);
                } else {
                    WhileIDE.okDialog(WideFileView.this.m_tree, otherFile.getAbsolutePath() + " was not found", true);
                }
            }
        }

        String wclIT(String n) {
            int index = n.lastIndexOf(".");
            if (index != -1) {
                return n.substring(0, index) + ".wcl";
            }
            return n + ".wcl";
        }

        String wctIT(String n) {
            int index = n.lastIndexOf(".");
            if (index != -1) {
                return n.substring(0, index) + ".while";
            }
            return n + ".wct";
        }
    }

    class RemoveFile
    implements ActionListener {
        RemoveFile() {
        }

        public void actionPerformed(ActionEvent e) {
            TreePath tp = WideFileView.this.m_tree.getSelectionPath();
            if (tp == null) {
                return;
            }
            Object o = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (o instanceof FileNode) {
                int ans;
                String prompt = "Removing " + ((FileNode)o).getFile().getName() + " From project...\n" + "Delete file from disk as well ?\n\n";
                JOptionPane opt = new JOptionPane(prompt, 3, 1);
                ButtonsFisher.fish(opt);
                JDialog d = opt.createDialog(Utils.windowForComponent((Component)WideFileView.this.m_tree), "WIDE");
                d.pack();
                d.show();
                Object ansObj = opt.getValue();
                int n = ans = ansObj == null ? 2 : Integer.parseInt(ansObj.toString());
                if (ans == -1) {
                    return;
                }
                if (ans == 2) {
                    return;
                }
                CodeTextEditor edit = WhileIDE.ide.fileToEditor(((FileNode)o).getFile());
                if (edit != null) {
                    WhileIDE.ide.m_closeAction.close(edit, true, true);
                }
                WideFileView.this.m_model.removeNodeFromParent((DefaultMutableTreeNode)tp.getLastPathComponent());
                File file = ((FileNode)o).getFile();
                CodeTextEditor.deleteLastUsedInput(file);
                if (ans == 0) {
                    SysLog.out.println("deleting " + file);
                    file.delete();
                }
            }
        }
    }

    class CompFile
    implements ActionListener {
        CompFile() {
        }

        public void actionPerformed(ActionEvent e) {
            TreePath tp = WideFileView.this.m_tree.getSelectionPath();
            if (tp == null) {
                return;
            }
            Object o = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (o instanceof FileNode) {
                WhileIDE.ide.lowerPanel.showMsg();
                WhileIDE.ide.m_compAction.compile(((FileNode)o).getFile(), false);
            }
        }
    }

    class OpenFile
    implements ActionListener {
        OpenFile() {
        }

        public void actionPerformed(ActionEvent e) {
            WideFileView.this.openFile(true);
        }
    }

    class TCR
    extends DefaultTreeCellRenderer2 {
        ImageIcon root;
        ImageIcon abst;
        ImageIcon conc;
        ImageIcon closed;
        ImageIcon opened;

        TCR() {
            this.setBorderSelectionColor(Color.gray);
            this.root = new ImageIcon("images/tree_root.gif");
            this.abst = new ImageIcon("images/fileTypes/text.gif");
            this.conc = new ImageIcon("images/fileTypes/list.gif");
            this.closed = new ImageIcon("images/tree_fclosed.gif");
            this.opened = new ImageIcon("images/tree_fopened.gif");
            Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
            this.setBackgroundNonSelectionColor(null);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object _value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, _value, sel, expanded, leaf, row, hasFocus);
            Object value = ((DefaultMutableTreeNode)_value).getUserObject();
            if (value == WideFileView.this.ROOT) {
                this.setIcon(this.root);
            } else if (value == WideFileView.this.ABSTRACT || value == WideFileView.this.CONCRETE) {
                if (expanded) {
                    this.setIcon(this.opened);
                } else {
                    this.setIcon(this.closed);
                }
            } else if (((FileNode)value).getType() == 0) {
                this.setIcon(this.abst);
            } else {
                this.setIcon(this.conc);
            }
            return this;
        }

        private int getLabelStart() {
            Icon currentI = this.getIcon();
            if (currentI != null && this.getText() != null) {
                return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            return 0;
        }
    }

    class ML
    implements MouseListener {
        JPopupMenu popup;

        ML() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                new OpenFile().actionPerformed(null);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            Object o;
            TreePath tp = WideFileView.this.m_tree.getPathForLocation(e.getX(), e.getY());
            if (tp == null) {
                return;
            }
            WideFileView.this.m_tree.setSelectionPath(tp);
            if (SwingUtilities.isRightMouseButton(e) && (o = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject()) instanceof FileNode) {
                if (this.popup == null) {
                    this.cp();
                }
                this.popup.show(WideFileView.this.m_tree, e.getX(), e.getY());
            }
        }

        void cp() {
            JMenuItem miOpen = new JMenuItem("Open", new ImageIcon("images/open.gif"));
            JMenuItem miCompile = new JMenuItem("Compile", new ImageIcon("images/compile.png"));
            JMenuItem miRemove = new JMenuItem("Remove", new ImageIcon("images/remove.gif"));
            JMenuItem miOpenMatchingSource = new JMenuItem("Open matching source", new ImageIcon("images/empty.gif"));
            JMenuItem miProperties = new JMenuItem("Properties", new ImageIcon("images/empty.gif"));
            miOpen.setMnemonic('O');
            miCompile.setMnemonic('C');
            miRemove.setMnemonic('R');
            miOpenMatchingSource.setMnemonic('M');
            miProperties.setMnemonic('P');
            miOpen.addActionListener(new OpenFile());
            miCompile.addActionListener(new CompFile());
            miRemove.addActionListener(new RemoveFile());
            miOpenMatchingSource.addActionListener(new OpenMatchingSource());
            miProperties.addActionListener(new PropertiesAction());
            this.popup = new JPopupMenu();
            this.popup.add(miOpen);
            this.popup.add(miCompile);
            this.popup.add(miRemove);
            this.popup.addSeparator();
            this.popup.add(miOpenMatchingSource);
            this.popup.add(miProperties);
        }
    }
}

