/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.utils.Lm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import whilepack.SysLog;
import whilepack.cid.CompileWarning;
import whilepack.cid.IWhileCompiler;
import whilepack.cid.WCCException;
import whilepack.cid.WhileCompiler3;
import whilepack.cid.WhileConcreteCompiler2;
import whilepack.general.SugarHandler;
import whilepack.gui.AbstractAction2;
import whilepack.gui.ButtonsFisher;
import whilepack.gui.CodeTextEditor;
import whilepack.gui.DebugActions;
import whilepack.gui.DebugPanel;
import whilepack.gui.DirtyListener;
import whilepack.gui.DoPrint;
import whilepack.gui.DoPrint2;
import whilepack.gui.FileNode;
import whilepack.gui.IDEUtils;
import whilepack.gui.ListInputDialog;
import whilepack.gui.LowerPanel;
import whilepack.gui.MM;
import whilepack.gui.NewFileDialog;
import whilepack.gui.StatusBar;
import whilepack.gui.ToggleBreakPointAction;
import whilepack.gui.ToolbarUtils;
import whilepack.gui.UndoRedoListener;
import whilepack.gui.WideFileView;
import whilepack.gui.actions.AccelratorKeyListener;
import whilepack.gui.help.HelpManager;
import whilepack.gui.options.OptionsDialog;
import whilepack.gui.searchreplace.SearchActions;
import whilepack.gui.widgets.sortedtable.SortedTableHandler;
import widex.parsers.ParseUtils;
import widex.utils.Gaps;
import widex.utils.PropertyBag;
import widex.utils.Utils;

public class WhileIDE
extends JPanel
implements AccelratorKeyListener {
    private JTabbedPane tabbedPane;
    LowerPanel lowerPanel;
    private JPanel executionToolBar;
    private JPanel debugToolBar;
    private JButton m_btnNew;
    private JButton m_btnOpen;
    private JButton m_btnSave;
    private JButton m_btnCompile;
    private JButton m_btnDebug;
    private JButton m_btnRun;
    private JButton m_btnUndo;
    private JButton m_btnRedo;
    private StatusBar m_statusBar;
    private NewAction m_newAction;
    private SaveAction m_saveAction;
    InputAction m_inputAction;
    CompileAction m_compAction;
    GotoErrorAction m_gotoErrorAction;
    OpenAction m_openAction;
    RunAction m_runAction;
    SuspendAction m_suspendAction;
    private ToggleBreakPointAction m_toggleBreakPointAction;
    CloseAction m_closeAction;
    private CloseAllAction m_closeAllAction;
    private ExitAction m_exitAction;
    private SaveAsAction m_saveAsAction;
    private SaveAllAction m_saveAllAction;
    private PrintAction m_printAction;
    private EditorAction m_cutAction;
    private EditorAction m_copyAction;
    private EditorAction m_pasteAction;
    private EditorAction m_deleteAction;
    private EditorAction m_selectAllAction;
    private EditorAction m_undoAction;
    private EditorAction m_redoAction;
    private OptionsAction m_optionsAction;
    private DecompileAction m_decompileAction;
    private TitleAndStatusBarUpdater m_titleAndStatusBarUpdater;
    private JSplitPane split1;
    private JSplitPane split2;
    private WideFileView fileView;
    public static WhileIDE ide = null;
    private Icon fileTypeIconList;
    private Icon fileTypeIconText;
    private static ImageIcon m_emptyIcon = new ImageIcon("images/ide_empty.gif");
    public Frame frame;
    private JLabel lblRunning;
    private JComponent actionsComp;
    private int actionIndex = 0;
    private JFileChooser fc;
    private Map editors2 = new HashMap();
    private static final int CUT = 0;
    private static final int COPY = 1;
    private static final int PASTE = 2;
    private static final int DELETE = 3;
    private static final int SELECT_ALL = 4;
    private static final int UNDO = 5;
    private static final int REDO = 6;
    private final String[] names = new String[]{"Cut", "Copy", "Paste", "Delete", "Select All", "Undo", "Redo"};
    private final ImageIcon[] icons = new ImageIcon[]{new ImageIcon("images/ide_edit_cut.gif"), new ImageIcon("images/ide_edit_copy.gif"), new ImageIcon("images/ide_edit_paste.gif"), new ImageIcon("images/ide_edit_delete.gif"), m_emptyIcon, new ImageIcon("images/ide_edit_undo.gif"), new ImageIcon("images/ide_edit_redo.gif")};
    private final String[] keyStrokes = new String[]{"control X", "control C", "control V", "Delete", "control A", "control Z", "control pressed Y"};
    private final char[] mnemonics = new char[]{'t', 'C', 'P', 'D', 'A', 'U', 'R'};
    private JMenu mnuFile;
    private JMenuBar m_menuBar = null;
    private static String DEF_TITLE = "WIDE";

    public WhileIDE() {
        this.actionsComp = new JLabel();
        AbstractAction2.addAccelratorKeyListener(this);
        m_emptyIcon = new ImageIcon("images/ide_empty.gif");
        this.m_newAction = new NewAction();
        this.m_saveAction = new SaveAction();
        this.m_inputAction = new InputAction();
        this.m_compAction = new CompileAction();
        this.m_gotoErrorAction = new GotoErrorAction();
        this.m_openAction = new OpenAction();
        this.m_runAction = new RunAction();
        this.m_suspendAction = new SuspendAction();
        this.m_saveAsAction = new SaveAsAction();
        this.m_saveAllAction = new SaveAllAction();
        this.m_printAction = new PrintAction();
        this.m_closeAction = new CloseAction();
        this.m_closeAllAction = new CloseAllAction();
        this.m_optionsAction = new OptionsAction();
        this.m_decompileAction = new DecompileAction();
        this.m_exitAction = new ExitAction();
        this.m_toggleBreakPointAction = new ToggleBreakPointAction();
        this.m_cutAction = new EditorAction(this, 0);
        this.m_copyAction = new EditorAction(this, 1);
        this.m_pasteAction = new EditorAction(this, 2);
        this.m_deleteAction = new EditorAction(this, 3);
        this.m_selectAllAction = new EditorAction(this, 4);
        this.m_undoAction = new EditorAction(this, 5);
        this.m_redoAction = new EditorAction(this, 6);
        this.m_btnNew = new JButton(this.m_newAction);
        JButton btnNew = ToolbarUtils.createToolbarButton(this.m_newAction);
        btnNew.setText("");
        JButton txtEdit1 = ToolbarUtils.createToolbarButton(this.m_cutAction);
        JButton txtEdit2 = ToolbarUtils.createToolbarButton(this.m_copyAction);
        JButton txtEdit3 = ToolbarUtils.createToolbarButton(this.m_pasteAction);
        JButton txtEdit4 = ToolbarUtils.createToolbarButton(this.m_undoAction);
        JButton txtEdit5 = ToolbarUtils.createToolbarButton(this.m_redoAction);
        this.m_btnOpen = ToolbarUtils.createToolbarButton(this.m_openAction);
        this.m_btnSave = ToolbarUtils.createToolbarButton(this.m_saveAction);
        this.m_btnCompile = ToolbarUtils.createToolbarButton(this.m_compAction);
        this.m_btnDebug = ToolbarUtils.createToolbarButton(DebugActions.debugAction);
        this.m_btnRun = ToolbarUtils.createToolbarButton(this.m_runAction);
        ide = this;
        this.m_titleAndStatusBarUpdater = new TitleAndStatusBarUpdater();
        this.fixButtons(new JButton[]{this.m_btnNew, this.m_btnOpen, this.m_btnSave, txtEdit1, txtEdit2, txtEdit3, txtEdit4, txtEdit5, this.m_btnDebug, this.m_btnCompile, this.m_btnRun});
        this.m_statusBar = new StatusBar();
        JButton resume = ToolbarUtils.createToolbarButton(DebugActions.resumeAction);
        JButton suspend2 = ToolbarUtils.createToolbarButton(DebugActions.suspendAction);
        JButton stepOver = ToolbarUtils.createToolbarButton(DebugActions.stepOverAction);
        JButton runToCursor = ToolbarUtils.createToolbarButton(DebugActions.runToCursorAction);
        JButton showExePoint = ToolbarUtils.createToolbarButton(DebugActions.showExePointAction);
        JPanel toolBar = new JPanel();
        toolBar.setLayout(new BoxLayout(toolBar, 2));
        Color cc = toolBar.getBackground();
        toolBar.setBackground(new Color(cc.getRed() + 6, cc.getGreen() + 6, cc.getBlue() + 6));
        toolBar.add(Box.createRigidArea(new Dimension(5, 0)));
        toolBar.add(btnNew);
        this.addToolBarSeparator(toolBar);
        toolBar.add(this.m_btnOpen);
        toolBar.add(this.m_btnSave);
        this.addToolBarSeparator(toolBar);
        toolBar.add(txtEdit1);
        toolBar.add(txtEdit2);
        toolBar.add(txtEdit3);
        this.addToolBarSeparator(toolBar);
        toolBar.add(txtEdit4);
        toolBar.add(txtEdit5);
        toolBar.setBorder(new EmptyBorder(2, 0, 0, 0));
        this.m_btnUndo = txtEdit4;
        this.m_btnRedo = txtEdit5;
        this.addToolBarSeparator(toolBar);
        toolBar.add(this.m_btnCompile);
        toolBar.add(ToolbarUtils.createToolbarButton(new InputAction()));
        this.addToolBarSeparator(toolBar);
        toolBar.add(this.m_btnRun);
        this.executionToolBar = new JPanel();
        this.executionToolBar.setLayout(new BoxLayout(this.executionToolBar, 2));
        this.executionToolBar.add(ToolbarUtils.createToolbarButton(this.m_suspendAction));
        this.executionToolBar.setVisible(false);
        this.fixToolBar(this.executionToolBar);
        toolBar.add(this.executionToolBar);
        this.addToolBarSeparator(toolBar);
        toolBar.add(this.m_btnDebug);
        this.debugToolBar = new JPanel();
        this.debugToolBar.setLayout(new BoxLayout(this.debugToolBar, 2));
        this.debugToolBar.add(stepOver);
        this.debugToolBar.add(Gaps.h((int)5));
        this.debugToolBar.add(resume);
        this.debugToolBar.add(Gaps.h((int)2));
        this.debugToolBar.add(runToCursor);
        this.debugToolBar.add(Gaps.h((int)2));
        this.debugToolBar.add(suspend2);
        this.debugToolBar.add(Gaps.h((int)2));
        this.debugToolBar.add(showExePoint);
        this.debugToolBar.setVisible(false);
        toolBar.add(this.debugToolBar);
        this.addToolBarSeparator(toolBar);
        this.fixToolBar(toolBar);
        this.fixToolBar(this.debugToolBar);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.add(this.actionsComp);
        this.lblRunning = new JLabel(new ImageIcon("images/await.gif"));
        this.lblRunning.setVisible(false);
        toolBar.add(this.lblRunning);
        toolBar.add(Gaps.h((int)5));
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setFont(UIManager.getFont("Menu.font"));
        this.tabbedPane.setFocusTraversalKeysEnabled(false);
        this.tabbedPane.setFocusable(false);
        InputMap inputMap = this.tabbedPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("control pressed TAB"), "SwitchAction");
        inputMap.put(KeyStroke.getKeyStroke("alt RIGHT"), "SwitchAction");
        this.tabbedPane.getActionMap().put("SwitchAction", new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                int index = WhileIDE.this.tabbedPane.getSelectedIndex() + 1;
                if (index == WhileIDE.this.tabbedPane.getTabCount()) {
                    index = 0;
                }
                WhileIDE.this.tabbedPane.setSelectedIndex(index);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control shift pressed TAB"), "SwitchAction2");
        inputMap.put(KeyStroke.getKeyStroke("alt LEFT"), "SwitchAction2");
        this.tabbedPane.getActionMap().put("SwitchAction2", new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                int index = WhileIDE.this.tabbedPane.getSelectedIndex() - 1;
                if (index == -1) {
                    index = WhileIDE.this.tabbedPane.getTabCount() - 1;
                }
                WhileIDE.this.tabbedPane.setSelectedIndex(index);
            }
        });
        this.tabbedPane.addChangeListener(this.m_titleAndStatusBarUpdater);
        this.tabbedPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){
            JPopupMenu pop = null;

            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                int index = WhileIDE.this.tabbedPane.indexAtLocation(e.getX(), e.getY());
                if (index == -1) {
                    return;
                }
                if (this.pop == null) {
                    this.cpop();
                }
                this.pop.show(WhileIDE.this.tabbedPane, e.getX(), e.getY());
            }

            void cpop() {
                this.pop = new JPopupMenu();
                this.pop.add(WhileIDE.this.m_closeAction);
                this.pop.addSeparator();
                this.pop.add(WhileIDE.this.m_compAction);
                this.pop.add(WhileIDE.this.m_saveAction);
                WhileIDE.this.fixMenu(this.pop);
            }
        });
        this.lowerPanel = new LowerPanel();
        this.lowerPanel.setMinimumSize(new Dimension(0, 0));
        this.fileView = new WideFileView();
        this.fileView.setMinimumSize(new Dimension(0, 0));
        this.fileView.setPreferredSize(new Dimension(160, 0));
        this.split1 = new JSplitPane(1, this.fileView, this.tabbedPane);
        this.split1.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.split1.setResizeWeight(0.0);
        this.split1.setDividerLocation(200);
        IDEUtils.removeBinding(this.split1, "F6");
        this.split2 = new JSplitPane(0, this.split1, this.lowerPanel);
        this.split2.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.split2.setResizeWeight(1.0);
        IDEUtils.removeBinding(this.split2, "F6");
        JPanel m_tabAndScroller = new JPanel(new BorderLayout(0, 0));
        m_tabAndScroller.add(this.split2);
        this.readProjectFiles();
        this.setLayout(new BorderLayout(0, 1));
        this.add((Component)toolBar, "North");
        this.add((Component)m_tabAndScroller, "Center");
        this.add((Component)this.m_statusBar, "South");
    }

    private void readProjectFiles() {
        File projectsFile = new File("project.xml");
        if (!projectsFile.exists()) {
            return;
        }
        Element root = ParseUtils.getDocumentElement((File)projectsFile);
        if (root == null) {
            return;
        }
        int activeTabIndex = 0;
        NodeList nodeList = root.getElementsByTagName("Editor");
        TreeMap<Integer, FileNode> opened = new TreeMap<Integer, FileNode>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            File file;
            Element elem = (Element)nodeList.item(i);
            String fileN = ParseUtils.getTag((Element)elem, (String)"File", null);
            String bpts = ParseUtils.getTag((Element)elem, (String)"BreakPoints", (String)"");
            boolean manualyEditedList = ParseUtils.getTagBool((Element)elem, (String)"ManualyEditedList", (boolean)false);
            int tabIndex = ParseUtils.getTagInt((Element)elem, (String)"TabIndex", (int)-1);
            boolean isActive = ParseUtils.getTagBool((Element)elem, (String)"Active", (boolean)false);
            if (fileN == null || !(file = new File(fileN)).exists() || !this.isExtensionLegal(file)) continue;
            FileNode fileNode = new FileNode(file, bpts);
            fileNode.setManualyEditedList(manualyEditedList);
            if (tabIndex >= 0) {
                if (isActive) {
                    activeTabIndex = tabIndex;
                }
                opened.put(new Integer(tabIndex), fileNode);
            }
            this.fileView.checkFile(fileNode);
        }
        Iterator iterator = opened.values().iterator();
        while (iterator.hasNext()) {
            FileNode fileNode = (FileNode)iterator.next();
            this.m_openAction.openFile(fileNode.file, fileNode.getBreakPoints(), true);
        }
        if (this.tabbedPane.getTabCount() > 0) {
            if (activeTabIndex < this.tabbedPane.getTabCount()) {
                this.tabbedPane.setSelectedIndex(activeTabIndex);
            } else {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    private boolean isExtensionLegal(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".while") || name.endsWith(".wcl");
    }

    public void keyRegistered(KeyStroke keyStroke, Action action) {
        String actionName = "wideAction_" + this.actionIndex;
        this.actionsComp.getInputMap(2).put(keyStroke, actionName);
        this.actionsComp.getActionMap().put(actionName, action);
        ++this.actionIndex;
    }

    public void prepareGuiForDebugExecution() {
        this.lblRunning.setVisible(true);
        this.debugToolBar.setVisible(true);
    }

    public void prepareGuiForDebugTermination() {
        this.lblRunning.setVisible(false);
        this.debugToolBar.setVisible(false);
    }

    public void prepareGuiForRunExecution() {
        this.lblRunning.setVisible(true);
        this.m_runAction.setEnabled(false);
        this.m_suspendAction.setEnabled(true);
        this.executionToolBar.setVisible(true);
    }

    public void prepareGuiForRunTermination() {
        this.lblRunning.setVisible(false);
        this.m_runAction.setEnabled(true);
        this.m_suspendAction.setEnabled(false);
        this.executionToolBar.setVisible(false);
    }

    private void addToolBarSeparator(Container toolBar) {
        toolBar.add(Box.createRigidArea(new Dimension(3, 0)));
        toolBar.add(this.createVerticalSeparator());
        toolBar.add(Box.createRigidArea(new Dimension(3, 0)));
    }

    private void fixToolBar(Container toolBar) {
        for (int i = 0; i < toolBar.getComponentCount(); ++i) {
            if (!(toolBar.getComponent(i) instanceof JButton)) continue;
            JButton[] b = new JButton[]{(JButton)toolBar.getComponent(i)};
            this.fixButtons(b);
        }
    }

    private JSeparator createVerticalSeparator() {
        JSeparator ss = new JSeparator(1);
        ss.setPreferredSize(new Dimension(2, 1));
        ss.setMaximumSize(new Dimension(2, 22));
        return ss;
    }

    private void fixButtons(JButton[] bs) {
        for (int i = 0; i < bs.length; ++i) {
            JButton b = bs[i];
            WhileIDE.fixButton(b);
        }
    }

    private static void fixButton(JButton b) {
        if (ToolbarUtils.isWorkingWithJide()) {
            b.setMargin(new Insets(0, 0, 0, 0));
            b.setMargin(new Insets(2, 2, 2, 2));
            Utils.fixCompSize((JComponent)b, (int)25, (int)25);
        } else {
            b.setMargin(new Insets(2, 2, 2, 2));
            Utils.fixCompSize((JComponent)b, (int)28, (int)28);
        }
        b.setFocusable(false);
        b.setText("");
        b.setOpaque(false);
        b.setBackground(new Color(219, 216, 209));
    }

    private void notifyUndoRedo(CodeTextEditor e) {
        this.m_btnUndo.setEnabled(e.hasUndo());
        this.m_btnRedo.setEnabled(e.hasRedo());
    }

    public CodeTextEditor[] getCodeTextEditors() {
        return this.editors2.values().toArray(new CodeTextEditor[0]);
    }

    private void configEditor(CodeTextEditor editor) {
        editor.txt.getInputMap(0).put(KeyStroke.getKeyStroke("control W"), "CloseAction");
        editor.txt.getActionMap().put("CloseAction", this.m_closeAction);
        editor.setDirtyListener(this.m_titleAndStatusBarUpdater);
        editor.setUndoRedoListener(this.m_titleAndStatusBarUpdater);
    }

    public CodeTextEditor fileToEditor(File file) {
        if (file == null) {
            return null;
        }
        CodeTextEditor[] edits = this.editors2.values().toArray(new CodeTextEditor[0]);
        for (int i = 0; i < edits.length; ++i) {
            if (edits[i].m_file == null || !edits[i].m_file.equals(file)) continue;
            return edits[i];
        }
        return null;
    }

    private void fixFocus() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        CodeTextEditor e = (CodeTextEditor)WhileIDE.access$1100(7.access$2500(this.this$1)).get(WhileIDE.access$000(7.access$2500(this.this$1)).getSelectedComponent());
                        if (e != null) {
                            e.txt.requestFocusInWindow();
                        }
                    }
                });
            }

            static /* synthetic */ WhileIDE access$2500(7 x0) {
                return x0.WhileIDE.this;
            }
        }).start();
    }

    public void transferFocusToEditor() {
        CodeTextEditor e = this.editor();
        if (e != null) {
            e.txt.requestFocusInWindow();
        }
    }

    private File getEditorDirectory() {
        CodeTextEditor e = this.editor();
        if (e == null) {
            return new File(System.getProperty("user.dir"));
        }
        return e.getFile().getParentFile();
    }

    public CodeTextEditor editor() {
        return this.editor(-1);
    }

    private CodeTextEditor editor(int i) {
        if (i == -1) {
            return (CodeTextEditor)this.editors2.get(this.tabbedPane.getSelectedComponent());
        }
        return (CodeTextEditor)this.editors2.get(this.tabbedPane.getComponentAt(i));
    }

    String tabTitle() {
        String x = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        if (x.endsWith(" *")) {
            x = x.substring(0, x.length() - 2);
        }
        return x;
    }

    JFileChooser craeteFC() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.getName().endsWith(".while")) {
                    return true;
                }
                return pathname.isDirectory();
            }

            public String getDescription() {
                return "WHILE Files (.while)";
            }
        });
        return fc;
    }

    private String exp2str(Exception exp) {
        exp.printStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exp.printStackTrace(pw);
        return sw.toString();
    }

    private Icon getWhileFileIcon(int type) {
        if (this.fileTypeIconList == null) {
            this.fileTypeIconList = new ImageIcon("images/fileTypes/list.gif");
            this.fileTypeIconText = new ImageIcon("images/fileTypes/text.gif");
        }
        if (type == 1) {
            return this.fileTypeIconList;
        }
        if (type == 0) {
            return this.fileTypeIconText;
        }
        return new ImageIcon("images/fileTypes/unknown.gif");
    }

    private JMenuBar getJMenuBar() {
        if (this.m_menuBar != null) {
            return this.m_menuBar;
        }
        this.m_menuBar = new MM();
        this.m_menuBar.getInputMap(2).remove(KeyStroke.getKeyStroke("F10"));
        this.m_menuBar.getInputMap(2).getParent().remove(KeyStroke.getKeyStroke("F10"));
        this.mnuFile = this.m_menuBar.add(new JMenu("File"));
        JMenu mnuEdit = this.m_menuBar.add(new JMenu("Edit"));
        JMenu mnuSearch = this.m_menuBar.add(new JMenu("Search"));
        JMenu mnuBuild = this.m_menuBar.add(new JMenu("Build"));
        JMenu mnuTools = this.m_menuBar.add(new JMenu("Tools"));
        JMenu mnuHelp = this.m_menuBar.add(new JMenu("Help"));
        this.mnuFile.setMnemonic('F');
        this.mnuFile.add(new NewAction());
        this.mnuFile.add(this.m_openAction);
        this.mnuFile.add(this.m_closeAction);
        this.mnuFile.add(this.m_closeAllAction);
        this.mnuFile.addSeparator();
        this.mnuFile.add(this.m_saveAction);
        this.mnuFile.add(this.m_saveAsAction);
        this.mnuFile.add(this.m_saveAllAction);
        this.mnuFile.addSeparator();
        this.mnuFile.add(this.m_printAction);
        this.mnuFile.addSeparator();
        this.mnuFile.add(this.m_exitAction);
        mnuEdit.setMnemonic('E');
        mnuEdit.add(new JMenuItem(this.m_undoAction));
        mnuEdit.add(new JMenuItem(this.m_redoAction));
        mnuEdit.addSeparator();
        mnuEdit.add(this.m_cutAction);
        mnuEdit.add(this.m_copyAction);
        mnuEdit.add(this.m_pasteAction);
        mnuEdit.add(this.m_deleteAction);
        mnuEdit.addSeparator();
        mnuEdit.add(this.m_selectAllAction);
        mnuSearch.setMnemonic('S');
        mnuSearch.add(SearchActions.FIND_ACTION);
        mnuSearch.add(SearchActions.FIND_NEXT);
        mnuSearch.add(SearchActions.FIND_PREVIOUS);
        mnuSearch.addSeparator();
        mnuSearch.add(SearchActions.REPLACE_ACTION);
        mnuBuild.setMnemonic('B');
        mnuBuild.add(this.m_compAction);
        mnuBuild.add(this.m_runAction);
        mnuBuild.add(DebugActions.debugAction);
        mnuBuild.addSeparator();
        mnuBuild.add(this.m_toggleBreakPointAction);
        mnuBuild.addSeparator();
        mnuBuild.add(DebugActions.stepOverAction);
        mnuBuild.add(DebugActions.resumeAction);
        mnuBuild.add(DebugActions.runToCursorAction);
        mnuBuild.add(this.m_suspendAction).setVisible(false);
        mnuBuild.add(DebugActions.suspendAction).setVisible(false);
        mnuBuild.add(this.m_gotoErrorAction).setVisible(false);
        mnuTools.setMnemonic('T');
        mnuTools.add(this.m_optionsAction);
        mnuTools.add(this.m_decompileAction);
        mnuHelp.setMnemonic('H');
        mnuHelp.add(new HelpTopicsAction());
        mnuHelp.add(new AboutAction());
        this.fixMenu(this.mnuFile);
        this.fixMenu(mnuEdit);
        this.fixMenu(mnuSearch);
        this.fixMenu(mnuBuild);
        this.fixMenu(mnuTools);
        this.fixMenu(mnuHelp);
        return this.m_menuBar;
    }

    private void fixMenu(JMenu mnuFile) {
        for (int i = 0; i < mnuFile.getItemCount(); ++i) {
            if (mnuFile.getItem(i) == null) continue;
            mnuFile.getItem(i).setMargin(new Insets(2, -10, 2, 2));
            mnuFile.getItem(i).setToolTipText(null);
        }
    }

    private void fixMenu(JPopupMenu mnuFile) {
        for (int i = 0; i < mnuFile.getComponentCount(); ++i) {
            if (!(mnuFile.getComponent(i) instanceof AbstractButton)) continue;
            AbstractButton a = (AbstractButton)mnuFile.getComponent(i);
            a.setMargin(new Insets(2, -10, 2, 2));
            a.setToolTipText(null);
        }
    }

    private static String readFile(File file) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        String code = "";
        while ((line = in.readLine()) != null) {
            code = code + line + "\n";
        }
        in.close();
        return code;
    }

    private WindowFocusListener getWindowFocusListener() {
        return new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                if (WhileIDE.this.mnuFile.isSelected()) {
                    WhileIDE.this.mnuFile.setSelected(false);
                    WhileIDE.this.transferFocusToEditor();
                }
            }

            public void windowLostFocus(WindowEvent e) {
            }
        };
    }

    private static Image img(ImageIcon ii) {
        Image im = ii.getImage();
        final Color color = Color.green;
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    private static int questionDialog(Component comp, String prompt, int type) {
        return WhileIDE.questionDialog(comp, prompt, type, DEF_TITLE);
    }

    private static int questionDialog(Component comp, String prompt, int type, String title) {
        JOptionPane opt = new JOptionPane(prompt, 3, type);
        ButtonsFisher.fish(opt);
        JDialog d = opt.createDialog(Utils.windowForComponent((Component)comp), title);
        d.pack();
        d.show();
        d.dispose();
        Object ansO = opt.getValue();
        int ans = ansO == null ? 2 : Integer.parseInt(ansO.toString());
        return ans;
    }

    public static void okDialog(String prompt) {
        WhileIDE.okDialog(WhileIDE.ide.frame, prompt, false);
    }

    public static void okDialog(String prompt, boolean isError) {
        WhileIDE.okDialog(WhileIDE.ide.frame, prompt, isError);
    }

    public static void okDialog(Component comp, String prompt, boolean isError) {
        WhileIDE.okDialog(comp, prompt, isError, DEF_TITLE);
    }

    public static void okDialog(Component comp, String prompt) {
        WhileIDE.okDialog(comp, prompt, false, DEF_TITLE);
    }

    private static void okDialog(Component comp, String prompt, boolean isError, String title) {
        JOptionPane opt = new JOptionPane(prompt, isError ? 0 : 1, -1);
        ButtonsFisher.fish(opt);
        JDialog d = opt.createDialog(Utils.windowForComponent((Component)comp), title);
        d.pack();
        d.show();
        d.dispose();
    }

    public DebugPanel getDebugPanel() {
        return this.lowerPanel.m_debugPanel;
    }

    public static void main(String[] args) throws Exception {
        SortedTableHandler.SORT_ASC_ICON = new ImageIcon("images/table/sort_asc.gif");
        SortedTableHandler.SORT_DESC_ICON = new ImageIcon("images/table/sort_desc.gif");
        Lm.verifyLicense((String)"Eyal Katz", (String)"WIDE", (String)"foG6.cDUfriKSQvaMk0dHeSF8kskn0z");
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        LookAndFeelFactory.installJideExtension((int)2);
        ToolbarUtils.setWorkingWithJide(true);
        UIManager.put("OptionPane.errorIcon", new ImageIcon(WhileIDE.img(new ImageIcon("images/msg_error.png"))));
        UIManager.put("OptionPane.informationIcon", new ImageIcon(WhileIDE.img(new ImageIcon("images/msg_info.png"))));
        UIManager.put("OptionPane.questionIcon", new ImageIcon(WhileIDE.img(new ImageIcon("images/msg_question.png"))));
        UIManager.put("OptionPane.warningIcon", new ImageIcon(WhileIDE.img(new ImageIcon("images/msg_warning.png"))));
        Font font = new Font("Tahoma", 0, 11);
        UIManager.put("Tree.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("MenuItem.font", font);
        final WhileIDE x = new WhileIDE();
        JFrame fr = new JFrame("");
        fr.getContentPane().setLayout(new GridLayout(1, 1));
        fr.setJMenuBar(x.getJMenuBar());
        fr.getContentPane().add(x);
        fr.setDefaultCloseOperation(0);
        fr.setIconImage(new ImageIcon("images/main.png").getImage());
        final PropertyBag prefs = new PropertyBag("prefs.ini", true);
        fr.setBounds(-10000, -10000, 0, 0);
        fr.pack();
        int frameX = prefs.getInt("mainFrame.x", -1);
        int frameY = prefs.getInt("mainFrame.y", -1);
        int frameW = prefs.getInt("mainFrame.w", 800);
        int frameH = prefs.getInt("mainFrame.h", 600);
        boolean frameMax = prefs.getBool("mainFrame.max", true);
        fr.setBounds(frameX, frameY, frameW, frameH);
        if (frameX == -1) {
            fr.setLocationRelativeTo(null);
        }
        fr.setExtendedState(frameMax ? 6 : 0);
        fr.addWindowListener(x.m_exitAction);
        fr.addWindowFocusListener(x.getWindowFocusListener());
        x.lowerPanel.showCard(prefs.getInt("lowerPanel.card", 0));
        x.m_saveAction.setEnabled(false);
        x.m_saveAsAction.setEnabled(false);
        x.m_saveAllAction.setEnabled(false);
        x.frame = fr;
        WhileIDE.setDividerLocation(x.split2, prefs, "mainFrame.dividerLocation2", 0.74, 0);
        WhileIDE.setDividerLocation(x.split1, prefs, "mainFrame.dividerLocation1", 0.0, 200);
        WhileIDE.setDividerLocation(x.getDebugPanel().getSplitter(), prefs, "debugPanel.dividerLocation", 0.6, 0);
        x.m_titleAndStatusBarUpdater.stateChanged();
        x.frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                WhileIDE.setDividerLocation(x.split2, prefs, "mainFrame.dividerLocation2", 0.74, 0);
                WhileIDE.setDividerLocation(x.split1, prefs, "mainFrame.dividerLocation1", 0.0, 200);
                WhileIDE.setDividerLocation(x.getDebugPanel().getSplitter(), prefs, "debugPanel.dividerLocation", 0.6, 0);
            }
        });
        fr.show();
    }

    private static void setDividerLocation(JSplitPane splitter, PropertyBag prefs, String s, double defaultLocation1, int defaultLocation2) {
        int debugDividerLocation = prefs.getInt(s, -1);
        if (debugDividerLocation == -1) {
            if (defaultLocation1 != 0.0) {
                splitter.setDividerLocation(defaultLocation1);
            } else {
                splitter.setDividerLocation(defaultLocation2);
            }
        } else {
            splitter.setDividerLocation(debugDividerLocation);
        }
    }

    static /* synthetic */ int access$1500(Component x0, String x1, int x2) {
        return WhileIDE.questionDialog(x0, x1, x2);
    }

    class PrintAction
    extends AbstractAction2 {
        public PrintAction() {
            super("Print...", new ImageIcon("images/ide_print.gif"));
            this.putValue("ShortDescription", "Print...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control P"));
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent e) {
            if (new File("hook.txt").exists()) {
                DoPrint.print();
            } else {
                DoPrint2.print();
            }
        }
    }

    class CloseAllAction
    extends AbstractAction2 {
        CloseAllAction() {
            super("Close All", m_emptyIcon);
            this.putValue("ShortDescription", "Close All");
        }

        public void actionPerformed(ActionEvent e) {
            while (WhileIDE.this.tabbedPane.getTabCount() > 0) {
                if (WhileIDE.this.m_closeAction.close()) continue;
                return;
            }
        }
    }

    class AboutAction
    extends AbstractAction2 {
        AboutAction() {
            super("About", m_emptyIcon);
            this.putValue("ShortDescription", "About");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(""));
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent e) {
            JLabel lbl = new JLabel(new ImageIcon("images/splash.png"));
            lbl.setCursor(Cursor.getPredefinedCursor(12));
            lbl.addMouseListener(new MouseAdapter(this, lbl){
                private final /* synthetic */ JLabel val$lbl;
                private final /* synthetic */ AboutAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$lbl = val$lbl;
                }

                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        Utils.windowForComponent((Component)this.val$lbl).dispose();
                    }
                }
            });
            JDialog d = new JDialog(WhileIDE.this.frame, "About", true);
            d.setUndecorated(true);
            d.getContentPane().setLayout(new GridLayout(1, 1));
            d.getContentPane().add(lbl);
            d.pack();
            d.setLocationRelativeTo(WhileIDE.this.frame);
            d.setDefaultCloseOperation(2);
            Utils.makeHideOnEscape((JDialog)d);
            d.show();
            d.dispose();
        }
    }

    class HelpTopicsAction
    extends AbstractAction2 {
        boolean firstTime = true;

        HelpTopicsAction() {
            super("Help Topics...", new ImageIcon("images/ide_help.gif"));
            this.putValue("ShortDescription", "Help Topics");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
            this.putValue("MnemonicKey", new Integer(72));
            HelpManager.get().showHelpID("Intro");
        }

        public void actionPerformed(ActionEvent e) {
            HelpManager.get().showHelpWindow();
        }
    }

    class ExitAction
    extends AbstractAction2
    implements WindowListener {
        ExitAction() {
            super("Exit", m_emptyIcon);
            this.putValue("ShortDescription", "Exit");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt F4"));
            this.putValue("MnemonicKey", new Integer(120));
        }

        public void windowOpened(WindowEvent e) {
            WhileIDE.this.m_titleAndStatusBarUpdater.editorDirtyChanged(WhileIDE.this.editor(), false);
        }

        public void windowClosing(WindowEvent e) {
            this.actionPerformed(null);
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.saveOpenedFiles();
                this.saveGuiPref();
                SugarHandler.save();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            System.exit(0);
        }

        public void saveOpenedFiles() throws Exception {
            File ideDirectory = new File(System.getProperty("user.dir"));
            Document doc = ParseUtils.createNewDocument();
            Element root = doc.createElement("Root");
            CodeTextEditor activeEditor = WhileIDE.this.editor();
            FileNode[] fileNodes = WhileIDE.this.fileView.getAllFiles();
            for (int i = 0; i < fileNodes.length; ++i) {
                FileNode fileNode = fileNodes[i];
                Element elem = doc.createElement("Editor");
                CodeTextEditor editor = WhileIDE.this.fileToEditor(fileNode.getFile());
                if (editor != null) {
                    int tabIndex = WhileIDE.this.tabbedPane.indexOfComponent(editor.scroller);
                    if (!WhileIDE.this.m_closeAction.close(editor, false)) {
                        return;
                    }
                    ParseUtils.appendChild((Document)doc, (Node)elem, (String)"File", (String)fileNode.getFileRelativeTo(ideDirectory));
                    ParseUtils.appendChild((Document)doc, (Node)elem, (String)"BreakPoints", (String)editor.getBreakPoints());
                    ParseUtils.appendChild((Document)doc, (Node)elem, (String)"TabIndex", (int)tabIndex);
                    ParseUtils.appendChild((Document)doc, (Node)elem, (String)"ManualyEditedList", (boolean)fileNode.isManualyEditedList());
                    if (editor == activeEditor) {
                        ParseUtils.appendChild((Document)doc, (Node)elem, (String)"Active", (boolean)true);
                    }
                } else {
                    ParseUtils.appendChild((Document)doc, (Node)elem, (String)"File", (String)fileNode.getFileRelativeTo(ideDirectory));
                    ParseUtils.appendChild((Document)doc, (Node)elem, (String)"BreakPoints", (String)fileNode.getBreakPointsAsString());
                    ParseUtils.appendChild((Document)doc, (Node)elem, (String)"ManualyEditedList", (boolean)fileNode.isManualyEditedList());
                }
                root.appendChild(elem);
            }
            doc.appendChild(root);
            ParseUtils.writeDocument((Document)doc, (String)"project.xml");
        }

        private void saveGuiPref() {
            int frameX = WhileIDE.this.frame.getX();
            int frameY = WhileIDE.this.frame.getY();
            int frameW = WhileIDE.this.frame.getWidth();
            int frameH = WhileIDE.this.frame.getHeight();
            boolean frameMax = WhileIDE.this.frame.getExtendedState() == 6;
            PropertyBag prefs = new PropertyBag("prefs.ini", true);
            prefs.put("mainFrame.x", frameX);
            prefs.put("mainFrame.y", frameY);
            prefs.put("mainFrame.w", frameW);
            prefs.put("mainFrame.h", frameH);
            prefs.put("mainFrame.max", frameMax);
            prefs.put("mainFrame.dividerLocation2", WhileIDE.this.split2.getDividerLocation());
            prefs.put("mainFrame.dividerLocation1", WhileIDE.this.split1.getDividerLocation());
            prefs.put("debugPanel.dividerLocation", WhileIDE.this.getDebugPanel().getSplitter().getDividerLocation());
            prefs.put("lowerPanel.card", WhileIDE.this.lowerPanel.getCard());
            prefs.save();
        }
    }

    class DecompileAction
    extends AbstractAction2 {
        public DecompileAction() {
            super("Convert to .while file ...", m_emptyIcon);
            this.putValue("ShortDescription", "Convert to .while file ...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(""));
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            CodeTextEditor codeTextEditor = WhileIDE.this.editor();
            if (codeTextEditor == null) {
                return;
            }
            if (codeTextEditor.getFileType() != 1) {
                WhileIDE.okDialog("Please select a .wcl file", true);
                return;
            }
            WhileIDE.this.m_compAction.compile();
            String fileName = codeTextEditor.getFile().getName();
            int dot = fileName.indexOf(".");
            String name = fileName.substring(0, dot);
            name = name + "_while" + ".while";
            File newFile = new File(codeTextEditor.getFile().getParentFile(), name);
            int index = 1;
            while (newFile.exists()) {
                name = fileName.substring(0, dot);
                name = name + "_while_" + index + ".while";
                newFile = new File(codeTextEditor.getFile().getParentFile(), name);
                ++index;
            }
            String newFileName = newFile.getAbsolutePath();
            JOptionPane pane = new JOptionPane("New .while file name:", 3, 2, null, null, null);
            pane.setWantsInput(true);
            pane.setSelectionValues(null);
            pane.setInitialSelectionValue(newFileName);
            ButtonsFisher.fish(pane);
            JDialog dialog = pane.createDialog(WhileIDE.this.frame, "WIDE");
            int w = SwingUtilities.computeStringWidth(new JTextField().getFontMetrics(new JTextField().getFont()), newFileName);
            pane.selectInitialValue();
            dialog.pack();
            dialog.setSize(w + 100, dialog.getHeight());
            dialog.show();
            dialog.dispose();
            if (pane.getInputValue() == null) {
                return;
            }
            if (pane.getInputValue().equals(JOptionPane.UNINITIALIZED_VALUE)) {
                return;
            }
            String value = pane.getInputValue().toString().trim();
            if (!value.endsWith(".while")) {
                value = value + ".while";
            }
            WhileIDE.this.m_compAction.saveCompileFile(new File(value), WhileIDE.this.m_compAction.lastCompiler, true);
        }
    }

    class OptionsAction
    extends AbstractAction2 {
        public OptionsAction() {
            super("Options...", m_emptyIcon);
            this.putValue("ShortDescription", "Options...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(""));
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent e) {
            OptionsDialog optionsDialog = new OptionsDialog(WhileIDE.this.frame, "Options", true);
            optionsDialog.show();
            if (optionsDialog.wasCanceled()) {
                return;
            }
            optionsDialog.processChanges();
        }
    }

    class EditorAction
    extends AbstractAction2 {
        int type;
        WhileIDE ref;

        public EditorAction(WhileIDE ref, int type) {
            super(WhileIDE.this.names[type], WhileIDE.this.icons[type]);
            this.putValue("ShortDescription", WhileIDE.this.names[type]);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(WhileIDE.this.keyStrokes[type]));
            this.putValue("MnemonicKey", new Integer(WhileIDE.this.mnemonics[type]));
            this.type = type;
            this.ref = ref;
        }

        public void actionPerformed(ActionEvent e) {
            CodeTextEditor editor = this.ref.editor();
            if (this.type == 0) {
                editor.txt.cut();
            } else if (this.type == 1) {
                editor.txt.copy();
            } else if (this.type == 2) {
                editor.txt.paste();
            } else if (this.type == 3) {
                editor.txt.replaceSelection("");
            } else if (this.type == 4) {
                editor.txt.selectAll();
            } else if (this.type == 5) {
                editor.undo();
            } else if (this.type == 6) {
                editor.redo();
            }
        }
    }

    class SuspendAction
    extends AbstractAction2
    implements Runnable {
        SuspendAction() {
            super("Suspend Execution", new ImageIcon("images/action/suspend.png"));
            this.putValue("ShortDescription", "Suspend Execution");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F5"));
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            WhileIDE.this.lowerPanel.suspend(WhileIDE.this);
        }
    }

    class RunAction
    extends AbstractAction2
    implements Runnable {
        Component source;

        RunAction() {
            super("Run", new ImageIcon("images/action/execute.png"));
            this.putValue("ShortDescription", "Run");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F5"));
            this.putValue("MnemonicKey", new Integer(114));
        }

        public void actionPerformed(ActionEvent e) {
            this.source = (Component)e.getSource();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            WhileIDE.this.lowerPanel.run(WhileIDE.this, this.source);
        }
    }

    class GotoErrorAction
    extends AbstractAction2 {
        GotoErrorAction() {
            super("Go to Error", new ImageIcon("images/autoscrollToSource.png"));
            this.putValue("ShortDescription", "Go to Error");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F4"));
            this.putValue("MnemonicKey", new Integer(71));
        }

        public void actionPerformed(ActionEvent e) {
            File file = WhileIDE.this.lowerPanel.m_messagesPanel.file;
            WCCException error = WhileIDE.this.lowerPanel.m_messagesPanel.error;
            if (file == null || error == null) {
                return;
            }
            WhileIDE ide = WhileIDE.ide;
            CodeTextEditor cte = ide.fileToEditor(file);
            if (cte != null) {
                cte.gotoErrorLine(error);
            }
        }
    }

    class CompileAction
    extends AbstractAction2
    implements Runnable {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy ; hh:mm:ss");
        private IWhileCompiler lastCompiler;

        CompileAction() {
            super("Compile", new ImageIcon("images/compile.png"));
            this.putValue("ShortDescription", "Compile");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F7"));
            this.putValue("MnemonicKey", new Integer(109));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE.this.lowerPanel.showMsg();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.compile();
        }

        public String compile() {
            CodeTextEditor editor = WhileIDE.this.editor();
            boolean wasSaved = WhileIDE.this.m_saveAction.save();
            if (!wasSaved) {
                return null;
            }
            return (String)this.compile(editor.m_file, false);
        }

        public ArrayList compileForDebug() {
            CodeTextEditor editor = WhileIDE.this.editor();
            boolean wasSaved = WhileIDE.this.m_saveAction.save();
            if (!wasSaved) {
                return null;
            }
            return (ArrayList)this.compile(editor.m_file, true);
        }

        public Object compile(File file, boolean isForDebug) {
            WCCException wccException = null;
            int fileType = file.getName().endsWith(".while") ? 0 : 1;
            try {
                WhileIDE.this.lowerPanel.clearMessages();
                WhileIDE.this.lowerPanel.msg("---------------------------------- WIDE Compiler ----------------------------------\n");
                WhileIDE.this.lowerPanel.msg("Time       :  " + this.sdf.format(new Date()) + "\n");
                WhileIDE.this.lowerPanel.msg("Command    :  Compile " + file.getName() + "\n");
                WhileIDE.this.lowerPanel.msg("Directory  :  " + file.getParent() + "\n");
                IWhileCompiler comp = this.getCompiler(fileType, file, isForDebug);
                comp.compile();
                if (comp.getWarningCount() > 0) {
                    CompileWarning[] warnings = comp.getWarnings();
                    WhileIDE.this.lowerPanel.msg("\n");
                    for (int i = 0; i < warnings.length; ++i) {
                        WhileIDE.this.lowerPanel.msg("Warning: " + warnings[i].toString() + "\n");
                    }
                    WhileIDE.this.lowerPanel.msg("\n");
                }
                WhileIDE.this.lowerPanel.msg("No Errors");
                File compiledFile = comp.getOutputFile(file);
                this.setLastCompiler(comp);
                if (fileType == 0) {
                    if (!isForDebug && this.overwriteExistingListFile(compiledFile)) {
                        this.saveCompileFile(compiledFile, comp, false);
                    }
                } else {
                    compiledFile = null;
                }
                if (compiledFile != null) {
                    WhileIDE.this.lowerPanel.msg(" (Output File: " + compiledFile.getName() + ")");
                }
                if (isForDebug) {
                    return comp.getDebuggerCommands();
                }
                if (fileType == 0) {
                    return comp.getConcreteCode();
                }
                return ((WhileConcreteCompiler2)comp).getOriginalSource();
            }
            catch (WCCException exp) {
                wccException = exp;
                wccException.fileType = fileType;
                exp.printStackTrace();
                WhileIDE.this.lowerPanel.showMsg();
                WhileIDE.this.lowerPanel.compileError("Compilation Error:\r\n");
                WhileIDE.this.lowerPanel.compileError(" Location " + exp.line + ", " + exp.col + ": " + exp.getMessage());
            }
            catch (Exception exp) {
                exp.printStackTrace();
                WhileIDE.this.lowerPanel.msg("Compilation Error:\r\n", Color.red);
                WhileIDE.this.lowerPanel.msg(" " + exp.getMessage());
            }
            WhileIDE.this.lowerPanel.m_messagesPanel.setError(file, wccException);
            return null;
        }

        private boolean overwriteExistingListFile(File compiledFile) {
            FileNode fileNode = WhileIDE.this.fileView.getFile(compiledFile);
            if (fileNode == null) {
                return true;
            }
            if (!fileNode.isManualyEditedList()) {
                return true;
            }
            int answer = JOptionPane.showConfirmDialog(WhileIDE.this.frame, compiledFile + " was manually edited before\nOverwrite File?", "Confirm Overwrite", 0);
            return answer == 0;
        }

        private void setLastCompiler(IWhileCompiler comp) {
            this.lastCompiler = comp;
        }

        private IWhileCompiler getCompiler(int fileType, File file, boolean isForDebug) throws WCCException {
            IWhileCompiler comp = fileType == 0 ? new WhileCompiler3(file) : new WhileConcreteCompiler2(file);
            comp.setCompilerForDebug(isForDebug);
            return comp;
        }

        private void saveCompileFile(File outputFile, IWhileCompiler comp, boolean openAfterSave) {
            try {
                PrintWriter out = new PrintWriter(new FileOutputStream(outputFile), true);
                out.print(comp.getConcreteCode());
                out.flush();
                out.close();
                WhileIDE.this.fileView.checkFile(outputFile);
                WhileIDE.this.fileView.getFile(outputFile).setManualyEditedList(false);
                CodeTextEditor cte = WhileIDE.this.fileToEditor(outputFile);
                if (cte != null) {
                    cte.setExternalChanged(true);
                }
                if (openAfterSave) {
                    WhileIDE.ide.m_openAction.openFile(outputFile, null, true);
                }
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(WhileIDE.this, WhileIDE.this.exp2str(exp), "Error", 0);
                exp.printStackTrace();
            }
            SysLog.out.println(comp.getConcreteCode());
        }
    }

    class InputAction
    extends AbstractAction2 {
        InputAction() {
            super("Edit Input...", new ImageIcon("images/action/showViewer.png"));
            this.putValue("ShortDescription", "Edit Input");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control I"));
        }

        public void actionPerformed(ActionEvent e) {
            this.getInput((Component)e.getSource(), true);
        }

        String getInput(Component source) {
            return this.getInput(source, false);
        }

        String getInput(Component source, boolean forceShowDialog) {
            CodeTextEditor editor = WhileIDE.this.editor();
            FileNode fileNode = WhileIDE.this.fileView.getFile(editor.getFile());
            boolean askInput = fileNode.getAsksInput();
            String lastUsedInput = editor.getLastUsedInput();
            if (lastUsedInput == null) {
                askInput = true;
            }
            if (!askInput && !forceShowDialog) {
                return lastUsedInput;
            }
            ListInputDialog dialog = new ListInputDialog(WhileIDE.this.frame, lastUsedInput, editor.getFile(), editor.getFile().getParentFile(), askInput);
            dialog.setLocationRelativeTo(WhileIDE.this.frame);
            dialog.show();
            if (dialog.wasCanceled()) {
                return null;
            }
            askInput = dialog.chkDisplayAgain.isSelected();
            fileNode.setAsksInput(askInput);
            String newInput = dialog.getText();
            editor.setLastUsedInput(newInput);
            return newInput;
        }
    }

    class SaveAsAction
    extends AbstractAction2 {
        public SaveAsAction() {
            super("Save As...", m_emptyIcon);
            this.putValue("ShortDescription", "Save As...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F12"));
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE.this.m_saveAction.saveAs();
        }
    }

    class SaveAllAction
    extends AbstractAction2 {
        public SaveAllAction() {
            super("Save All", new ImageIcon("images/ide_save_all.gif"));
            this.putValue("ShortDescription", "Save All files");
            this.putValue("MnemonicKey", new Integer(108));
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < WhileIDE.this.tabbedPane.getTabCount(); ++i) {
                CodeTextEditor editor = WhileIDE.this.editor(i);
                if (WhileIDE.this.m_saveAction.save(editor, false)) continue;
                return;
            }
        }
    }

    class SaveAction
    extends AbstractAction2
    implements Runnable {
        SaveAction() {
            super("Save", new ImageIcon("images/ide_save.gif"));
            this.putValue("ShortDescription", "Save");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.save(WhileIDE.this.editor(), false);
        }

        public boolean save() {
            return this.save(WhileIDE.this.editor(), false);
        }

        public boolean saveAs() {
            return this.save(WhileIDE.this.editor(), true);
        }

        public boolean save(CodeTextEditor editor, boolean saveAs) {
            if (!saveAs) {
                if (editor.isDirty()) {
                    SysLog.out.println("Saving " + editor.m_file);
                    return this.save(editor, editor.m_file);
                }
                return true;
            }
            WhileIDE.this.fc = WhileIDE.this.fc == null ? new JFileChooser() : WhileIDE.this.fc;
            WhileIDE.this.fc.setCurrentDirectory(WhileIDE.this.getEditorDirectory());
            WhileIDE.this.fc.setDialogTitle("Save As");
            WhileIDE.this.fc.resetChoosableFileFilters();
            WhileIDE.this.fc.removeChoosableFileFilter(WhileIDE.this.fc.getAcceptAllFileFilter());
            if (editor.getFileType() == 0) {
                WhileIDE.this.fc.addChoosableFileFilter(IDEUtils.WHILE_FILTER);
            } else {
                WhileIDE.this.fc.addChoosableFileFilter(IDEUtils.WCL_FILTER);
            }
            WhileIDE.this.fc.addChoosableFileFilter(IDEUtils.ALL_FILES);
            if (editor.getFileType() == 0) {
                WhileIDE.this.fc.setFileFilter(IDEUtils.WHILE_FILTER);
            } else {
                WhileIDE.this.fc.setFileFilter(IDEUtils.WCL_FILTER);
            }
            int answer = WhileIDE.this.fc.showOpenDialog(WhileIDE.this);
            File file = null;
            if (answer == 0) {
                file = WhileIDE.this.fc.getSelectedFile();
            }
            if (file == null) {
                return false;
            }
            editor.m_file = file;
            WhileIDE.this.tabbedPane.setTitleAt(WhileIDE.this.tabbedPane.getSelectedIndex(), editor.m_file.getName());
            SysLog.out.println("Saving " + editor.m_file);
            return this.save(editor, editor.m_file);
        }

        boolean save(CodeTextEditor editor, File file) {
            try {
                PrintWriter out = new PrintWriter(new FileOutputStream(file), true);
                out.print(editor.txt.getText());
                out.flush();
                out.close();
                editor.setDirty(false);
                if (editor.getFileType() == 1) {
                    FileNode fileNode = WhileIDE.this.fileView.getFile(file);
                    if (fileNode == null) {
                        return true;
                    }
                    fileNode.setManualyEditedList(true);
                }
                return true;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                JOptionPane.showMessageDialog(WhileIDE.this, WhileIDE.this.exp2str(exp), "Error", 0);
                return false;
            }
        }
    }

    class CloseAction
    extends AbstractAction2 {
        public CloseAction() {
            super("Close", m_emptyIcon);
            this.putValue("ShortDescription", "Close");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F4"));
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            this.close();
        }

        public boolean close() {
            return this.close(WhileIDE.this.editor());
        }

        public boolean close(CodeTextEditor editor) {
            return this.close(editor, true, false);
        }

        public boolean close(CodeTextEditor editor, boolean removeFromTabbedPane) {
            return this.close(editor, removeFromTabbedPane, false);
        }

        public boolean close(CodeTextEditor editor, boolean removeFromTabbedPane, boolean ignoreDirty) {
            if (editor.isDirty()) {
                String text = editor.getFile().getName();
                int ans = 1;
                if (!ignoreDirty) {
                    JOptionPane opt = new JOptionPane("Save changes to " + text + " ?", 3, 1);
                    ButtonsFisher.fish(opt);
                    JDialog d = opt.createDialog(WhileIDE.this, "WIDE");
                    d.pack();
                    d.show();
                    Object ansO = opt.getValue();
                    int n = ans = ansO == null ? 2 : Integer.parseInt(ansO.toString());
                }
                if (ans == 2 || ans == -1) {
                    return false;
                }
                if (ans == 0) {
                    WhileIDE.this.m_saveAction.save();
                }
            }
            String breakPoints = editor.getBreakPoints();
            WhileIDE.this.fileView.getFile(editor.getFile()).setBreakPoints(breakPoints);
            if (removeFromTabbedPane) {
                WhileIDE.this.tabbedPane.remove(editor.scroller);
                WhileIDE.this.editors2.remove(editor.scroller);
                WhileIDE.this.m_titleAndStatusBarUpdater.stateChanged(null);
                WhileIDE.this.fixFocus();
                editor.txt = null;
            }
            return true;
        }
    }

    class OpenAction
    extends AbstractAction2
    implements Runnable {
        public OpenAction() {
            super("Open...", new ImageIcon("images/ide_open.gif"));
            this.putValue("ShortDescription", "Open");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control O"));
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            WhileIDE.this.fc = WhileIDE.this.fc == null ? new JFileChooser() : WhileIDE.this.fc;
            WhileIDE.this.fc.setCurrentDirectory(WhileIDE.this.getEditorDirectory());
            WhileIDE.this.fc.setDialogTitle("Open Files");
            WhileIDE.this.fc.resetChoosableFileFilters();
            WhileIDE.this.fc.removeChoosableFileFilter(WhileIDE.this.fc.getAcceptAllFileFilter());
            WhileIDE.this.fc.addChoosableFileFilter(IDEUtils.WHILE_FILTER);
            WhileIDE.this.fc.addChoosableFileFilter(IDEUtils.WCL_FILTER);
            WhileIDE.this.fc.addChoosableFileFilter(IDEUtils.ALL_FILES);
            WhileIDE.this.fc.setFileFilter(IDEUtils.WHILE_FILTER);
            int answer = WhileIDE.this.fc.showOpenDialog(WhileIDE.this);
            File file = null;
            if (answer == 0) {
                file = WhileIDE.this.fc.getSelectedFile();
                this.openFile(file);
            }
        }

        void openFile(String file) {
            this.openFile(new File(file));
        }

        void openFile(File file) {
            this.openFile(file, null, true);
        }

        public void openFile(File file, Collection breakPoints, boolean moveFocusToEditor) {
            WhileIDE.this.fileView.checkFile(file);
            CodeTextEditor[] edits = WhileIDE.this.editors2.values().toArray(new CodeTextEditor[0]);
            for (int i = 0; i < edits.length; ++i) {
                if (edits[i].m_file == null || !edits[i].m_file.equals(file)) continue;
                WhileIDE.this.tabbedPane.setSelectedComponent(edits[i].scroller);
                return;
            }
            int ft = -1;
            if (file.getName().endsWith("while")) {
                ft = 0;
            } else if (file.getName().endsWith("wcl")) {
                ft = 1;
            } else {
                return;
            }
            CodeTextEditor editor = new CodeTextEditor(file, ft);
            WhileIDE.this.configEditor(editor);
            try {
                editor.txt.setText(WhileIDE.readFile(file));
                editor.clearUndo();
                editor.setBreakPoints(breakPoints);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            WhileIDE.this.editors2.put(editor.scroller, editor);
            WhileIDE.this.tabbedPane.addTab(file.getName(), WhileIDE.this.getWhileFileIcon(ft), editor.scroller);
            WhileIDE.this.tabbedPane.setSelectedComponent(editor.scroller);
            editor.txt.setCaretPosition(0);
            if (moveFocusToEditor) {
                editor.txt.requestFocusInWindow();
            }
            editor.setDirty(false);
            WhileIDE.this.m_titleAndStatusBarUpdater.editorDirtyChanged(editor, false);
        }
    }

    class NewAction
    extends AbstractAction2 {
        int iii = 1;

        public NewAction() {
            super("New", new ImageIcon("images/ide_new.gif"));
            this.putValue("ShortDescription", "New");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control N"));
            this.putValue("MnemonicKey", new Integer(78));
        }

        public void actionPerformed(ActionEvent e) {
            this.newFile();
        }

        public void newFile() {
            NewFileDialog.Result result = NewFileDialog.showDialog(WhileIDE.this);
            if (result == null) {
                return;
            }
            String name = new File(result.name).getName();
            SysLog.out.println(new File(result.name));
            File file = result.getFile();
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (Exception exp) {
                // empty catch block
            }
            CodeTextEditor editor = new CodeTextEditor(file, result.type);
            WhileIDE.this.configEditor(editor);
            WhileIDE.this.editors2.put(editor.scroller, editor);
            WhileIDE.this.tabbedPane.addTab(name, WhileIDE.this.getWhileFileIcon(result.type), editor.scroller);
            WhileIDE.this.tabbedPane.setSelectedComponent(editor.scroller);
            WhileIDE.this.fileView.checkFile(file);
            WhileIDE.this.fileView.selectFile(file);
            editor.txt.setCaretPosition(0);
            editor.txt.requestFocusInWindow();
            WhileIDE.this.fixFocus();
            WhileIDE.this.m_titleAndStatusBarUpdater.editorDirtyChanged(editor, false);
        }
    }

    class TitleAndStatusBarUpdater
    implements ChangeListener,
    DirtyListener,
    UndoRedoListener {
        TitleAndStatusBarUpdater() {
        }

        public void stateChanged() {
            this.stateChanged(null);
        }

        public void stateChanged(ChangeEvent evt) {
            int index = WhileIDE.this.tabbedPane.getSelectedIndex();
            WhileIDE.this.m_saveAction.setEnabled(index != -1);
            WhileIDE.this.m_saveAsAction.setEnabled(index != -1);
            WhileIDE.this.m_inputAction.setEnabled(index != -1);
            WhileIDE.this.m_compAction.setEnabled(index != -1);
            if (!WhileIDE.this.lowerPanel.isRunning()) {
                WhileIDE.this.m_runAction.setEnabled(index != -1);
                WhileIDE.this.m_suspendAction.setEnabled(false);
            }
            if (!WhileIDE.this.lowerPanel.isRunning2()) {
                DebugActions.debugAction.setEnabled(index != -1);
                DebugActions.suspendAction.setEnabled(false);
            }
            WhileIDE.this.m_cutAction.setEnabled(index != -1);
            WhileIDE.this.m_copyAction.setEnabled(index != -1);
            WhileIDE.this.m_pasteAction.setEnabled(index != -1);
            WhileIDE.this.m_saveAllAction.setEnabled(index != -1);
            WhileIDE.this.m_undoAction.setEnabled(index != -1);
            WhileIDE.this.m_redoAction.setEnabled(index != -1);
            if (index == -1) {
                this.chnageTitles(null);
                return;
            }
            String framtTitle = null;
            for (int i = 0; i < WhileIDE.this.tabbedPane.getTabCount(); ++i) {
                CodeTextEditor e = WhileIDE.this.editor(i);
                String fName = e.getFile().getName();
                String text = null;
                text = e.isDirty() ? fName + " *" : fName;
                if (i != WhileIDE.this.tabbedPane.getSelectedIndex()) {
                    WhileIDE.this.tabbedPane.setBackgroundAt(i, null);
                    WhileIDE.this.tabbedPane.setTitleAt(i, text);
                    continue;
                }
                WhileIDE.this.tabbedPane.setBackgroundAt(i, new Color(247, 243, 239));
                WhileIDE.this.tabbedPane.setTitleAt(i, "<html><b>" + text + "</b></html>");
                framtTitle = text;
            }
            CodeTextEditor e = (CodeTextEditor)WhileIDE.this.editors2.get(WhileIDE.this.tabbedPane.getSelectedComponent());
            if (e != null) {
                e.txt.requestFocusInWindow();
                e.fixCaretListener(WhileIDE.this.m_statusBar);
                e.updateLineCol(WhileIDE.this.m_statusBar);
                WhileIDE.this.notifyUndoRedo(e);
            }
            this.chnageTitles(framtTitle);
            SwingUtilities.invokeLater(new Runnable(this, e){
                private final /* synthetic */ CodeTextEditor val$e;
                private final /* synthetic */ TitleAndStatusBarUpdater this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    if (this.val$e == null) {
                        return;
                    }
                    if (this.val$e.getExternalChanged()) {
                        String prompt = this.val$e.getFile().getAbsolutePath() + "\n\n" + "This file has been modified since last compilation." + "\n" + "Do you want to reload it ?";
                        int answer = WhileIDE.access$1500(TitleAndStatusBarUpdater.access$1400((TitleAndStatusBarUpdater)this.this$1).frame, prompt, 0);
                        if (answer == 0) {
                            try {
                                this.val$e.txt.setText(WhileIDE.access$1600(this.val$e.getFile()));
                                this.val$e.setDirty(false);
                                this.val$e.clearUndo();
                            }
                            catch (Exception exp) {
                                exp.printStackTrace();
                            }
                        }
                        this.val$e.setExternalChanged(false);
                    }
                }
            });
        }

        private void chnageTitles(String text) {
            if (WhileIDE.this.frame == null) {
                return;
            }
            if (text != null) {
                WhileIDE.this.frame.setTitle("WIDE [" + text + "]");
            } else {
                WhileIDE.this.frame.setTitle("WIDE");
            }
        }

        public void editorDirtyChanged(CodeTextEditor editor, boolean isDirty) {
            if (editor == null) {
                Frame fr = JOptionPane.getFrameForComponent(WhileIDE.this.tabbedPane);
                fr.setTitle("WIDE");
                return;
            }
            int index = WhileIDE.this.tabbedPane.indexOfComponent(editor.scroller);
            if (index == -1) {
                return;
            }
            String fName = editor.getFile().getName();
            String text = null;
            text = isDirty ? fName + " *" : fName;
            if (editor == WhileIDE.this.editor()) {
                Frame fr = JOptionPane.getFrameForComponent(WhileIDE.this.tabbedPane);
                fr.setTitle("WIDE [" + text + "]");
            }
            if (index == WhileIDE.this.tabbedPane.getSelectedIndex()) {
                text = "<html><b>" + text + "</b></html>";
            }
            WhileIDE.this.tabbedPane.setTitleAt(index, text);
            SwingUtilities.invokeLater(new Runnable(this, editor){
                private final /* synthetic */ CodeTextEditor val$editor;
                private final /* synthetic */ TitleAndStatusBarUpdater this$1;
                {
                    this.this$1 = this$1;
                    this.val$editor = val$editor;
                }

                public void run() {
                    WhileIDE.access$1300(TitleAndStatusBarUpdater.access$1400(this.this$1), this.val$editor);
                }
            });
        }

        public void editorContentChanged(CodeTextEditor ce) {
            if (ce != null) {
                WhileIDE.this.notifyUndoRedo(ce);
            }
        }

        public void undoRedoChanged(CodeTextEditor editor, int type) {
            WhileIDE.this.notifyUndoRedo(editor);
        }

        static /* synthetic */ WhileIDE access$1400(TitleAndStatusBarUpdater x0) {
            return x0.WhileIDE.this;
        }
    }
}

