/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import whilepack.cid.Node;
import whilepack.cid.WhileUtils;
import whilepack.cid.debugger.WatchVariableListener;
import whilepack.gui.ButtonsFisher;
import whilepack.gui.ClipboardMenuHandler;
import whilepack.gui.MyTextArea2;
import whilepack.gui.widgets.sortedtable.SortedTableHandler;
import whilepack.gui.widgets.sortedtable.SortedTableModel;
import widex.utils.Utils;

public class WatchTable
extends JPanel
implements WatchVariableListener {
    private JScrollPane scroller;
    private SortedTableModel model;
    private JTable table;

    public WatchTable() {
        Object[] cns = new String[]{"<html><b>Name</b></html>", "<html><b>Value</b></html>"};
        this.model = new SortedTableModel(cns){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(0).setMaxWidth(150);
        this.table.setAutoResizeMode(3);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ThisCellRenderer());
        SortedTableHandler x = new SortedTableHandler(this.table);
        x.setColumnHeaderTextAlignment(0, 2);
        x.setColumnHeaderTextAlignment(1, 2);
        this.scroller = new JScrollPane(this.table);
        this.scroller.setBorder(null);
        this.scroller.getViewport().setBackground(Color.white);
        this.scroller.setBackground(Color.white);
        this.setLayout(new BorderLayout(1, 1));
        this.table.addMouseListener(new ThisMouseListener());
        this.add(this.scroller);
    }

    private void setWatch(String name, Node value) {
        WatchInfo x = new WatchInfo(name, value);
        this.setWatch(name, x);
    }

    private void setWatch(String var, WatchInfo value) {
        int row = this.findVariableInTable(var);
        if (row != -1) {
            this.model.setValueAt(value, row, 1);
        } else {
            Object[] aRow = new Object[]{var, value};
            this.model.addRow(aRow);
        }
    }

    private int findVariableInTable(String var) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String varName = (String)this.model.getValueAt(i, 0);
            if (!varName.equalsIgnoreCase(var)) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.model.setData((Vector)null);
    }

    public void variableAdded(String name, Node value) {
        this.setWatch(name, value);
    }

    public void variableUpdated(String name, Node newValue) {
        this.setWatch(name, newValue);
    }

    class ThisMouseListener
    extends MouseAdapter {
        ThisMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (e.getClickCount() != 2) {
                return;
            }
            int row = WatchTable.this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            String name = WatchTable.this.model.getValueAt(row, 0).toString();
            WatchInfo value = (WatchInfo)WatchTable.this.model.getValueAt(row, 1);
            MyTextArea2 txt = new MyTextArea2();
            txt.setFont(WatchTable.this.table.getFont());
            txt.setText(value.originalValue, true);
            txt.addMouseListener(new ClipboardMenuHandler());
            txt.setEditable(false);
            JScrollPane scrl = new JScrollPane(txt);
            Dimension dims = scrl.getPreferredSize();
            if (dims.height < 50) {
                dims.height = 50;
            }
            if (dims.width < 100) {
                dims.width = 100;
            }
            if (dims.height > 270) {
                dims.height = 270;
            }
            if (dims.width > 380) {
                dims.width = 380;
            }
            scrl.setPreferredSize(dims);
            JPanel p = new JPanel(new BorderLayout(5, 5));
            p.add((Component)new JLabel("<html>Variable <b>" + name + "</b>:</html>"), "North");
            p.add((Component)scrl, "Center");
            JOptionPane opt = new JOptionPane(p, -1);
            ButtonsFisher.fish(opt);
            JDialog d = opt.createDialog(Utils.windowForComponent((Component)WatchTable.this.table), "Variable Watch");
            d.setResizable(true);
            d.pack();
            d.show();
            d.dispose();
        }
    }

    class ThisCellRenderer
    extends DefaultTableCellRenderer {
        ThisCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object aValue, boolean isSelected, boolean hasFocus, int row, int column) {
            WatchInfo wi = (WatchInfo)aValue;
            super.getTableCellRendererComponent(table, wi.originalValue, isSelected, hasFocus, row, column);
            this.setToolTipText(wi.tooltip);
            return this;
        }
    }

    class WatchInfo {
        String originalValue = "";
        String v = "";
        String tooltip = "";
        String name = "";

        WatchInfo(String name, Node nodeValue) {
            this.name = name;
            this.update(nodeValue);
        }

        private void update(Node nodeValue) {
            this.v = this.originalValue = WhileUtils.toList(nodeValue);
            this.v = this.v.replaceAll("\\\n", " ");
            this.v = this.v.replaceAll("( )+", " ");
            if (this.v.length() > 100) {
                this.v = this.v.substring(0, 99) + "...&nbsp;<br>" + "<b>(Double Click for full view)</b>&nbsp;";
                this.tooltip = "<html><br>&nbsp;" + this.name + " = " + this.v + "&nbsp;<br></html>";
            } else {
                this.tooltip = this.name + " = " + this.v;
            }
        }
    }
}

