/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class UndoMangerWrapper
implements UndoableEditListener {
    private UndoManager undoManager = new UndoManager();
    private UndoAction undoAction = null;
    private RedoAction redoAction = null;

    private UndoMangerWrapper() {
    }

    public static UndoMangerWrapper install(JTextComponent txt) {
        UndoMangerWrapper x = new UndoMangerWrapper();
        x.undoAction = x.createUndoAction();
        x.redoAction = x.createRedoAction();
        txt.getDocument().addUndoableEditListener(x);
        String U = "UndoMangerWrapper.UndoAction";
        String R = "UndoMangerWrapper.RedoAction";
        txt.getInputMap().put(KeyStroke.getKeyStroke("control pressed Z"), U);
        txt.getActionMap().put(U, x.undoAction);
        txt.getInputMap().put(KeyStroke.getKeyStroke("control pressed Y"), R);
        txt.getActionMap().put(R, x.redoAction);
        return x;
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.addEdit(e.getEdit());
    }

    public void clearUndoManager() {
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
    }

    private UndoAction createUndoAction() {
        return new UndoAction();
    }

    private RedoAction createRedoAction() {
        return new RedoAction();
    }

    class RedoAction
    extends AbstractAction {
        RedoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent t = (JTextComponent)e.getSource();
            if (!t.isEnabled()) {
                return;
            }
            if (UndoMangerWrapper.this.undoManager.canRedo()) {
                UndoMangerWrapper.this.undoManager.redo();
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent t = (JTextComponent)e.getSource();
            if (!t.isEnabled()) {
                return;
            }
            if (UndoMangerWrapper.this.undoManager.canUndo()) {
                try {
                    UndoMangerWrapper.this.undoManager.undo();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

