/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import widex.utils.Utils;

public class StatusBar
extends JPanel {
    private JLabel lblHelp = new JLabel("Help");
    private JLabel lblLineCol = new JLabel("Ln 9999, Col 99999");
    private JLabel lblOverwrite = new JLabel("INSOVR");
    private JLabel lblCapsLock = new JLabel("CAP");

    public StatusBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.lblHelp.setBorder(new StatusBarBorder());
        this.lblLineCol.setBorder(new StatusBarBorder());
        this.lblOverwrite.setBorder(new StatusBarBorder());
        this.lblCapsLock.setBorder(new StatusBarBorder());
        Utils.fixCompSize((JComponent)this.lblLineCol, (Dimension)this.lblLineCol.getPreferredSize());
        Utils.fixCompSize((JComponent)this.lblOverwrite, (Dimension)this.lblOverwrite.getPreferredSize());
        Utils.fixCompSize((JComponent)this.lblCapsLock, (Dimension)this.lblCapsLock.getPreferredSize());
        this.lblHelp.setText("");
        this.lblLineCol.setText("");
        this.lblOverwrite.setText("");
        this.lblCapsLock.setText("");
        this.lblHelp.setMaximumSize(new Dimension(1000000, 100));
        this.add(this.lblHelp);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.lblLineCol);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.lblOverwrite);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.lblCapsLock);
    }

    public void setLineCol(int line, int column, int pos) {
        this.lblLineCol.setText("Ln " + line + ", Col " + column);
    }

    class StatusBarBorder
    implements Border {
        StatusBarBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            g.setColor(new Color(128, 128, 128));
            g.drawLine(x, y, x + width - 2, y);
            g.drawLine(x, y, x, y + height - 2);
            g.setColor(table.getColor("Button.highlight"));
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 10, 2, 10);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

