/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.PlainDocument;
import whilepack.cid.Node;
import whilepack.cid.WhileTest;
import whilepack.cid.WhileUtils;
import whilepack.gui.ClipboardMenuHandler;
import whilepack.gui.IDEUtils;
import whilepack.gui.RunDialog;
import whilepack.gui.WhileIDE;
import widex.layout.SpecLayout;
import widex.layout.SpecPanel;
import widex.utils.Utils;

public class RunDialog
extends JPanel {
    private JTextArea txtInput;
    private JTextArea txtOutput;
    private JButton btnOK;
    private File m_workingDirectory;
    private JButton btnCancelInt;
    private static String code;

    private RunDialog(String input, File workingDirectory) {
        this.m_workingDirectory = workingDirectory;
        String prompt = "<html>Enter <b>Input</b> and press <b>Ctrl + Enter</b> to execute program</html>";
        this.btnOK = new JButton("Run");
        JButton btnCancel = new JButton("Cancel");
        JButton btnViewInputAgain = new JButton("View Input");
        this.txtInput = new JTextArea();
        this.txtInput.setMargin(new Insets(2, 2, 2, 2));
        this.txtInput.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke("TAB")));
        this.txtInput.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke("shift TAB")));
        this.txtInput.setDocument(new SpecialEnterKetDoc());
        this.txtInput.setText(input);
        ClipboardMenuHandler.config(this.txtInput);
        this.configSpecial(this.txtInput);
        btnViewInputAgain.setVisible(false);
        JScrollPane scrl = new JScrollPane(this.txtInput);
        scrl.setPreferredSize(new Dimension(46, 210));
        JPanel inputPanel = new JPanel(new BorderLayout(5, 5));
        inputPanel.add((Component)new JLabel(prompt), "North");
        inputPanel.add((Component)scrl, "Center");
        inputPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.txtOutput = new JTextArea();
        this.txtOutput.setMargin(new Insets(2, 2, 2, 2));
        this.txtOutput.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke("TAB")));
        this.txtOutput.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke("shift TAB")));
        ClipboardMenuHandler.config(this.txtOutput);
        String prompt2 = "Output:";
        JScrollPane scrl2 = new JScrollPane(this.txtOutput);
        scrl2.setPreferredSize(new Dimension(46, 210));
        JPanel outputPanel = new JPanel(new BorderLayout(5, 5));
        outputPanel.add((Component)new JLabel(prompt2), "North");
        outputPanel.add((Component)scrl2, "Center");
        outputPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        outputPanel.setBorder(new CompoundBorder(new MatteBorder(1, 0, 0, 0, Color.white), new EmptyBorder(5, 5, 5, 5)));
        JSplitPane sp = new JSplitPane(0, inputPanel, outputPanel);
        sp.setResizeWeight(0.5);
        sp.setBorder(null);
        IDEUtils.removeBinding(sp, "F6");
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)sp, "Center");
        SpecPanel x = new SpecPanel("X");
        x.add("F");
        x.add((Component)this.btnOK, (Object)"M");
        x.add("5");
        x.add((Component)btnCancel, (Object)"M");
        panel.add((Component)x, "South");
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.btnOK.addActionListener(new RunAction());
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Utils.windowForComponent((Component)RunDialog.this).hide();
            }
        });
        this.setLayout(new BorderLayout());
        this.add(panel);
    }

    private JDialog createWaitDialog() {
        this.btnCancelInt = new JButton("Cancel");
        JDialog d = Utils.createDialog((Component)this, (String)"Interpreter", (boolean)true);
        JProgressBar pb = new JProgressBar();
        pb.setIndeterminate(true);
        JPanel panel2 = new JPanel((LayoutManager)new SpecLayout("P2", "P,15,P"));
        JLabel g = new JLabel(new ImageIcon("images/pw.png"));
        JLabel pb2 = new JLabel(new ImageIcon("images/await.gif"));
        panel2.add((Component)g, "0,0, hAlign=Center");
        panel2.add((Component)pb2, "0,2, hAlign=Center");
        JPanel panel = new JPanel((LayoutManager)new SpecLayout("P", "P,15,P"));
        panel.add((Component)panel2, "0,0, hAlign=Center");
        panel.add((Component)this.btnCancelInt, "0,2, hAlign=Center");
        panel.setBorder(new EmptyBorder(12, 12, 11, 11));
        panel.setBackground(Color.white);
        panel2.setBackground(Color.white);
        d.getContentPane().setLayout(new BorderLayout());
        d.getContentPane().add(panel);
        d.pack();
        d.setResizable(false);
        d.setLocationRelativeTo(Utils.windowForComponent((Component)this));
        d.setDefaultCloseOperation(0);
        return d;
    }

    private void configSpecial(JTextArea t) {
        t.getInputMap().put(KeyStroke.getKeyStroke("control COMMA"), "AAAA2");
        t.getActionMap().put("AAAA2", new InsertSpecial("(", true));
        t.getInputMap().put(KeyStroke.getKeyStroke("control PERIOD"), "AAAA1");
        t.getActionMap().put("AAAA1", new InsertSpecial("NIL", true));
        t.getInputMap().put(KeyStroke.getKeyStroke("control SLASH"), "AAAA3");
        t.getActionMap().put("AAAA3", new InsertSpecial(")", false));
        t.getInputMap().put(KeyStroke.getKeyStroke("control L"), "AAA7");
        t.getInputMap().put(KeyStroke.getKeyStroke("control SEMICOLON"), "AAA7");
        t.getActionMap().put("AAA7", new InsertSpecial(".", false));
    }

    private void fixFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunDialog.this.txtInput.requestFocusInWindow();
            }
        });
    }

    public static void showDialog(WhileIDE ide, String _code, File workingDirectory) {
        code = _code;
        String input = ide.editor().getLastUsedInput();
        final RunDialog x = new RunDialog(input, workingDirectory);
        x.btnOK.setDefaultCapable(true);
        JDialog d = Utils.createDialog((Component)ide, (String)("Run " + ide.editor().getFile()), (boolean)true);
        d.getContentPane().setLayout(new BorderLayout());
        d.getContentPane().add(x);
        d.pack();
        d.setSize(470, 450);
        d.setLocationRelativeTo(null);
        d.getRootPane().setDefaultButton(x.btnOK);
        Utils.makeHideOnEscape((JDialog)d);
        d.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                x.fixFocus();
            }
        });
        d.setVisible(true);
        String newInput = x.txtInput.getText();
        ide.editor().setLastUsedInput(newInput);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    class SpecialEnterKetDoc
    extends PlainDocument {
        SpecialEnterKetDoc() {
        }
    }

    class InsertSpecial
    extends AbstractAction {
        String t;
        boolean checkWhitspace;

        InsertSpecial(String t, boolean checkWhitspace) {
            this.t = t;
            this.checkWhitspace = checkWhitspace;
        }

        public void actionPerformed(ActionEvent e) {
            JTextArea txt = (JTextArea)e.getSource();
            String c = null;
            try {
                c = txt.getText().substring(txt.getCaretPosition() - 1, txt.getCaretPosition());
            }
            catch (Exception exp) {
                // empty catch block
            }
            if (c == null) {
                txt.insert(this.t, txt.getCaretPosition());
                return;
            }
            String insert = this.t;
            if (this.t.equals("(")) {
                if (!c.equals("(") && !c.equals(".")) {
                    insert = " " + insert;
                }
            } else if (this.t.equals("NIL") && (c.equals("L") || c.equals(")"))) {
                insert = " " + insert;
            }
            txt.insert(insert, txt.getCaretPosition());
        }
    }

    class RunAction
    implements ActionListener {
        RunAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Node data = null;
            Node program = null;
            try {
                WhileUtils.BASE_DIR = RunDialog.this.m_workingDirectory;
                data = WhileUtils.buildInputTree(RunDialog.this.txtInput.getText());
                WhileUtils.BASE_DIR = null;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                RunDialog.this.txtOutput.setForeground(Color.red);
                RunDialog.this.txtOutput.setText("Erros were found in input expression:\n\n" + exp.getMessage());
                return;
            }
            try {
                program = WhileUtils.buildProgramTree(code);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                RunDialog.this.txtOutput.setForeground(Color.red);
                RunDialog.this.txtOutput.setText("An error occurred while parsing the Input Tree:\n" + exp);
                return;
            }
            WhileTest x = new WhileTest();
            Node fdata = data;
            Node fprogram = program;
            JDialog pwd = RunDialog.this.createWaitDialog();
            pwd.addComponentListener(new ComponentAdapter(this, x, fprogram, fdata, pwd){
                private final /* synthetic */ WhileTest val$x;
                private final /* synthetic */ Node val$fprogram;
                private final /* synthetic */ Node val$fdata;
                private final /* synthetic */ JDialog val$pwd;
                private final /* synthetic */ RunAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$x = val$x;
                    this.val$fprogram = val$fprogram;
                    this.val$fdata = val$fdata;
                    this.val$pwd = val$pwd;
                }

                public void componentShown(ComponentEvent e) {
                    new Thread(new Runnable(this){
                        private final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void run() {
                            try {
                                2.access$700(this.this$2).interpret(2.access$500(this.this$2), 2.access$600(this.this$2));
                                String result = WhileUtils.toList(2.access$700(this.this$2).getResult());
                                SwingUtilities.invokeLater(new Runnable(this, result){
                                    private final /* synthetic */ String val$result;
                                    private final /* synthetic */ 3 this$3;
                                    {
                                        this.this$3 = this$3;
                                        this.val$result = val$result;
                                    }

                                    public void run() {
                                        if (2.access$700(3.access$800(this.this$3)).wasInterpretationCanceled()) {
                                            2.access$900(3.access$800(this.this$3)).hide();
                                        } else {
                                            RunDialog.access$200(RunAction.access$1100(2.access$1000(3.access$800(this.this$3)))).setForeground(Color.blue);
                                            RunDialog.access$200(RunAction.access$1100(2.access$1000(3.access$800(this.this$3)))).setText(this.val$result);
                                            2.access$900(3.access$800(this.this$3)).hide();
                                        }
                                    }
                                });
                            }
                            catch (Exception exp) {
                                exp.printStackTrace();
                                SwingUtilities.invokeLater(new Runnable(this){
                                    private final /* synthetic */ 3 this$3;
                                    {
                                        this.this$3 = this$3;
                                    }

                                    public void run() {
                                        JOptionPane.showMessageDialog(RunAction.access$1100(2.access$1000(3.access$800(this.this$3))), "BYE", "Error", 0);
                                        2.access$900(3.access$800(this.this$3)).hide();
                                    }
                                });
                            }
                        }

                        static /* synthetic */ 2 access$800(3 x0) {
                            return x0.this$2;
                        }
                    }).start();
                }

                static /* synthetic */ Node access$500(2 x0) {
                    return x0.val$fprogram;
                }

                static /* synthetic */ Node access$600(2 x0) {
                    return x0.val$fdata;
                }

                static /* synthetic */ WhileTest access$700(2 x0) {
                    return x0.val$x;
                }

                static /* synthetic */ JDialog access$900(2 x0) {
                    return x0.val$pwd;
                }

                static /* synthetic */ RunAction access$1000(2 x0) {
                    return x0.this$1;
                }
            });
            RunDialog.this.btnCancelInt.addActionListener(new ActionListener(this, x){
                private final /* synthetic */ WhileTest val$x;
                private final /* synthetic */ RunAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$x = val$x;
                }

                public void actionPerformed(ActionEvent e) {
                    this.val$x.breakInterpretation();
                }
            });
            pwd.show();
        }

        static /* synthetic */ RunDialog access$1100(RunAction x0) {
            return x0.RunDialog.this;
        }
    }
}

