/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import whilepack.SysLog;
import whilepack.cid.Node;

public class PSTree
extends JPanel {
    private DefaultMutableTreeNode m_root;
    DefaultMutableTreeNode m_abstractRoot;
    DefaultMutableTreeNode m_concreteRoot;
    private DefaultTreeModel m_model;
    private JTree m_tree;

    public PSTree(Node p) {
        Node body = p.t.h;
        this.m_root = this.process(body, "1");
        this.m_model = new DefaultTreeModel(this.m_root);
        this.m_tree = new JTree(this.m_model);
        this.m_tree.setFont(new Font("Courier New", 0, this.m_tree.getFont().getSize()));
        JScrollPane scroller = new JScrollPane(this.m_tree);
        this.setLayout(new BorderLayout());
        this.add(scroller);
    }

    private DefaultMutableTreeNode process(Node p, String index) {
        DefaultMutableTreeNode root = null;
        index = "";
        if (p.isLeaf()) {
            root = new DefaultMutableTreeNode(index + " " + p + "");
            return root;
        }
        int value = PSTree.toInt(p);
        if (value != -1) {
            root = new DefaultMutableTreeNode(index + " " + value + "");
            return root;
        }
        root = new DefaultMutableTreeNode(new ListHolder(p));
        int i = 1;
        while (p != Node.NIL) {
            root.add(this.process(p.h, index + "." + i));
            ++i;
            p = p.t;
        }
        return root;
    }

    public void lookup(Node node) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.m_model.getRoot();
        SysLog.out.println(node);
        this.lookup_impl(root, node);
    }

    private void lookup_impl(DefaultMutableTreeNode root, Node node) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)root.getChildAt(i);
            if (!(aNode.getUserObject() instanceof ListHolder)) continue;
            if (((ListHolder)aNode.getUserObject()).node == node) {
                SysLog.out.println("root = " + root);
                TreePath tp = new TreePath(aNode.getPath());
                this.m_tree.expandPath(tp);
                this.m_tree.makeVisible(tp);
                this.m_tree.setSelectionPath(tp);
                return;
            }
            this.lookup_impl(aNode, node);
        }
    }

    private static int toInt(Node num) {
        if (num == Node.NIL) {
            return 0;
        }
        int value = 1;
        while (num.t != Node.NIL) {
            if (num.h != Node.NIL) {
                return -1;
            }
            num = num.t;
            ++value;
        }
        return value;
    }

    public void showDialog(Component c) {
        JFrame dialog = new JFrame("PSTree");
        dialog.getContentPane().add(this);
        dialog.pack();
        dialog.setBounds(0, 0, 800, 600);
        dialog.setDefaultCloseOperation(3);
        dialog.show();
    }

    class ListHolder {
        Node node;

        public ListHolder(Node node) {
            this.node = node;
        }

        public String toString() {
            return "(...)";
        }
    }
}

