/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.JTextComponent;
import whilepack.general.AppConsts;
import whilepack.gui.ToolbarUtils;
import widex.layout.SpecLayout;
import widex.layout.SpecPanel;
import widex.utils.BMP;
import widex.utils.Utils;

public class NewFileDialog
extends JPanel {
    private JButton btnWCT;
    private JButton btnWCL;
    private JButton btnOK;
    private JButton btnCancel;
    private JTextField txtFileName;
    private JTextField txtFilePath;

    public NewFileDialog() {
        Image wct = Utils.makeColorTransparent((Image)new BMP("images/wct.bmp").getImage(), (Color)new Color(212, 208, 200));
        Image wcl = Utils.makeColorTransparent((Image)new BMP("images/wcl.bmp").getImage(), (Color)new Color(212, 208, 200));
        this.btnWCT = ToolbarUtils.createToolbarButton("String Notation", new ImageIcon(wct));
        this.btnWCL = ToolbarUtils.createToolbarButton("List Notation", new ImageIcon(wcl));
        this.btnWCT.setVerticalTextPosition(3);
        this.btnWCT.setHorizontalTextPosition(0);
        this.btnWCL.setVerticalTextPosition(3);
        this.btnWCL.setHorizontalTextPosition(0);
        ButtonGroup bf = new ButtonGroup();
        this.btnWCT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewFileDialog.this.btnWCT.setSelected(true);
                NewFileDialog.this.btnWCL.setSelected(false);
            }
        });
        this.btnWCL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewFileDialog.this.btnWCT.setSelected(false);
                NewFileDialog.this.btnWCL.setSelected(true);
            }
        });
        this.btnWCT.setSelected(true);
        this.btnOK = new JButton("OK");
        this.btnCancel = new JButton("Cancel");
        this.txtFileName = new JTextField();
        this.txtFilePath = new JTextField(AppConsts.filesDirectory);
        JPanel form = new JPanel((LayoutManager)new SpecLayout("P2, 5, FILL+50", "PREF, 10, PREF"));
        form.add((Component)new JLabel("File:"), "0,0,vAlign=CENTER");
        form.add((Component)this.txtFileName, "2,0");
        form.add((Component)new JLabel("Path:"), "0,2,vAlign=CENTER");
        form.add((Component)this.txtFilePath, "2,2");
        form.setBorder(new EmptyBorder(12, 5, 0, 11));
        this.btnOK.setDefaultCapable(true);
        JPanel selp = new JPanel(new GridLayout(2, 1));
        selp.add(this.btnWCT);
        selp.add(this.btnWCL);
        Dimension dims = selp.getPreferredSize();
        dims.width = (int)((double)dims.width * 1.5);
        JPanel separ = new JPanel();
        separ.setBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 0, Color.gray), new MatteBorder(0, 1, 0, 0, Color.white)));
        SpecPanel mainP = new SpecPanel("X", "FILL");
        mainP.add((Component)selp, (Object)"P+25");
        mainP.add("5");
        mainP.add((Component)separ, (Object)"2");
        mainP.add("5");
        mainP.add((Component)form, (Object)"FILL");
        mainP.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
        SpecPanel bp = new SpecPanel("X", "P2");
        bp.addFill();
        bp.add((Component)this.btnOK, (Object)"M");
        bp.addGap(5);
        bp.add((Component)this.btnCancel, (Object)"M");
        bp.setBorder((Border)new CompoundBorder(new CompoundBorder(new MatteBorder(1, 0, 0, 0, Color.gray), new MatteBorder(1, 0, 0, 0, Color.white)), new EmptyBorder(5, 5, 5, 5)));
        this.setLayout(new BorderLayout(5, 0));
        this.add((Component)mainP, "Center");
        this.add((Component)bp, "South");
    }

    private boolean validateInput() {
        if (Utils.isTextFieldEmpty((JTextComponent)this.txtFileName, (String)"Please fill File Name")) {
            return false;
        }
        return !Utils.isTextFieldEmpty((JTextComponent)this.txtFilePath, (String)"Please fill File Path");
    }

    private Result createResult() {
        Result res = new Result();
        res.type = this.btnWCL.isSelected() ? 1 : 0;
        res.name = this.txtFilePath.getText() + "\\" + this.txtFileName.getText();
        int pos = res.name.indexOf(".");
        if (pos == -1) {
            res.name = res.name + (this.btnWCL.isSelected() ? ".wcl" : ".while");
        }
        return res;
    }

    public static Result showDialog(Component c) {
        final NewFileDialog nfd = new NewFileDialog();
        final Result[] res = new Result[]{null};
        final JDialog dialog = Utils.createDialog((Component)c, (String)"New File", (boolean)true);
        dialog.getContentPane().add(nfd);
        nfd.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.hide();
            }
        });
        nfd.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!nfd.validateInput()) {
                    return;
                }
                res[0] = nfd.createResult();
                dialog.hide();
            }
        });
        Utils.makeHideOnEscape((JDialog)dialog);
        dialog.pack();
        dialog.setSize(dialog.getSize().width, (int)((double)dialog.getSize().height * 1.25));
        dialog.setLocationRelativeTo(Utils.windowForComponent((Component)c));
        dialog.getRootPane().setDefaultButton(nfd.btnOK);
        dialog.show();
        dialog.setResizable(false);
        dialog.dispose();
        return res[0];
    }

    static class Result {
        String name;
        int type;

        Result() {
        }

        public File getFile() {
            if (this.type == 0 && !this.name.endsWith(".while")) {
                this.name = this.name + ".while";
            }
            if (this.type == 1 && !this.name.endsWith(".wcl")) {
                this.name = this.name + ".wcl";
            }
            return new File(this.name);
        }
    }
}

