/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;
import whilepack.cid.WCCException;
import whilepack.gui.ClipboardMenuHandler;
import whilepack.gui.MyTextArea;
import whilepack.gui.ToolbarUtils;
import whilepack.gui.WhileIDE;
import whilepack.gui.help.ShowHelpTopicAction;
import whilepack.gui.widgets.GradientJLabel;
import widex.layout.SpecPanel;

public class MessagesPanel
extends JPanel {
    public MyTextArea m_txtOutput;
    private JPanel toolBarRun;
    private GradientJLabel lblTitle;
    public WCCException error;
    public File file;

    public MessagesPanel() {
        JButton btnGotoError = ToolbarUtils.createToolbarButton(WhileIDE.ide.m_gotoErrorAction);
        JButton bthHelp = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/help.png"));
        btnGotoError.setFocusable(false);
        btnGotoError.setText("");
        bthHelp.setFocusable(false);
        bthHelp.addActionListener(new ShowHelpTopicAction("id1"));
        btnGotoError.setToolTipText("Goto Error (F4)");
        this.toolBarRun = new SpecPanel("Y", "P2");
        this.toolBarRun.add(btnGotoError);
        this.toolBarRun.add(bthHelp);
        this.m_txtOutput = new MyTextArea();
        this.m_txtOutput.addMouseListener(new ClipboardMenuHandler());
        JScrollPane scroller = new JScrollPane(this.m_txtOutput);
        this.m_txtOutput.setMinimumSize(new Dimension(200, 100));
        scroller.setMinimumSize(new Dimension(200, 0));
        this.m_txtOutput.setFont(new Font("Courier New", 0, 12));
        this.m_txtOutput.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke("TAB")));
        this.m_txtOutput.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke("shift TAB")));
        this.m_txtOutput.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    WhileIDE.ide.transferFocusToEditor();
                }
            }
        });
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.toolBarRun, "West");
        centerPanel.add((Component)scroller, "Center");
        Color color1 = new Color(108, 136, 191);
        Color color2 = new Color(128, 156, 211);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, color1, 0.0f, 8.0f, color2, true);
        this.lblTitle = new GradientJLabel("", paint);
        this.setTitle(null);
        this.lblTitle.setForeground(Color.white);
        this.lblTitle.setOpaque(false);
        this.lblTitle.setPreferredSize(new Dimension(0, this.lblTitle.getPreferredSize().height + 4));
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(1));
        this.lblTitle.setBorder(new MatteBorder(0, 0, 1, 0, Color.white));
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblTitle, "North");
        this.add(centerPanel);
    }

    public static void main(String[] args) {
        MessagesPanel x = new MessagesPanel();
        JFrame fr = new JFrame("Hello");
        fr.getContentPane().setLayout(new GridLayout(1, 1));
        fr.getContentPane().add(x);
        fr.setDefaultCloseOperation(3);
        fr.setBounds(200, 300, 300, 300);
        fr.show();
    }

    public void setTitle(String text) {
        String t = text == null ? "" : " - " + text;
        this.lblTitle.setText("  Messages" + t);
    }

    public void logError(String s) {
        this.m_txtOutput.append(s, Color.red);
    }

    public WCCException getError() {
        return this.error;
    }

    public void setError(File file, WCCException error) {
        this.file = file;
        this.error = error;
    }
}

