/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import whilepack.gui.CardPanel2;
import whilepack.gui.DebugPanel;
import whilepack.gui.ExecutionPanel;
import whilepack.gui.MessagesPanel;
import whilepack.gui.ToolbarUtils;
import whilepack.gui.WhileIDE;
import widex.layout.SpecLayout;

public class LowerPanel
extends JPanel {
    private CardPanel2 cardPanel;
    MessagesPanel m_messagesPanel = new MessagesPanel();
    private ExecutionPanel m_executionPanel = new ExecutionPanel();
    DebugPanel m_debugPanel = new DebugPanel();
    private JButton[] buttons;
    private JButton btnMessages = ToolbarUtils.createToolbarButton("Messages", new ImageIcon("images/tool/toolWindowMessages.png"));
    private JButton btnRun = ToolbarUtils.createToolbarButton("Run", new ImageIcon("images/tool/toolWindowRun.png"));
    private JButton btnDebug = ToolbarUtils.createToolbarButton("Debug", new ImageIcon("images/tool/toolWindowDebugger.png"));

    public LowerPanel() {
        this.btnMessages.setMnemonic('M');
        this.btnRun.setMnemonic('R');
        this.btnDebug.setMnemonic('D');
        this.buttons = new JButton[]{this.btnMessages, this.btnRun, this.btnDebug};
        for (int i = 0; i < this.buttons.length; ++i) {
            JButton b = this.buttons[i];
            b.setFocusable(false);
            b.setMargin(new Insets(2, 2, 2, 2));
            b.setFont(b.getFont().deriveFont((float)(b.getFont().getSize() - 1)));
        }
        this.cardPanel = new CardPanel2();
        this.cardPanel.add("0", this.m_messagesPanel);
        this.cardPanel.add("1", this.m_executionPanel);
        this.cardPanel.add("2", this.m_debugPanel);
        JPanel panel = new JPanel((LayoutManager)new SpecLayout("pref+2,pref+2,pref+2", "20"));
        panel.add((Component)this.btnMessages, "0,0");
        panel.add((Component)this.btnRun, "1,0");
        panel.add((Component)this.btnDebug, "2,0");
        this.btnMessages.addActionListener(new SwitchAction("0"));
        this.btnRun.addActionListener(new SwitchAction("1"));
        this.btnDebug.addActionListener(new SwitchAction("2"));
        this.btnMessages.doClick();
        this.btnRun.doClick();
        this.cardPanel.setMinimumSize(new Dimension(200, 150));
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this.cardPanel, "Center");
        this.add((Component)panel, "South");
    }

    public void clearMessages() {
        this.m_messagesPanel.m_txtOutput.setText("");
    }

    public void msg(String s) {
        this.m_messagesPanel.m_txtOutput.append(s);
    }

    public void msg(String s, Color c) {
        this.m_messagesPanel.m_txtOutput.append(s, c);
    }

    public void compileError(String s) {
        this.m_messagesPanel.logError(s);
    }

    public void run(WhileIDE whileIDE, Component source) {
        this.m_executionPanel.execute(source);
    }

    public void debug(WhileIDE whileIDE, Component source) {
        this.m_debugPanel.execute(source);
    }

    public void suspend(WhileIDE whileIDE) {
        this.m_executionPanel.suspend();
    }

    public void setTitles(String text) {
        this.m_messagesPanel.setTitle(text);
        this.m_executionPanel.setTitle(text);
        this.m_debugPanel.setTitle(text);
    }

    public boolean isRunning() {
        return this.m_executionPanel.isRunning();
    }

    public boolean isRunning2() {
        return this.m_debugPanel.isRunning();
    }

    public void showMsg() {
        this.btnMessages.doClick(0);
    }

    public void showRun() {
        this.btnRun.doClick(0);
    }

    public void showDebug() {
        this.btnDebug.doClick(0);
    }

    public void ideVisible() {
        this.m_debugPanel.ideVisible();
    }

    public int getCard() {
        try {
            return Integer.parseInt(this.cardPanel.getCurrentCard());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void showCard(int card) {
        if (card == 0) {
            this.btnMessages.doClick();
        }
        if (card == 1) {
            this.btnRun.doClick();
        }
        if (card == 2) {
            this.btnDebug.doClick();
        }
    }

    class SwitchAction
    implements ActionListener {
        private String s;

        public SwitchAction(String s) {
            this.s = s;
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < LowerPanel.this.buttons.length; ++i) {
                LowerPanel.this.buttons[i].setSelected(false);
            }
            JButton b = (JButton)e.getSource();
            b.setSelected(true);
            LowerPanel.this.cardPanel.showCard(this.s);
        }
    }
}

