/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import whilepack.gui.ClipboardMenuHandler;
import whilepack.gui.IDEUtils;

public class ListInputTextArea
extends JTextArea {
    public static final String HK_OPEN = "hk_(";
    public static final String HK_CLOSE = "hk_)";
    public static final String HK_NIL = "hk_nil";
    public static final String HK_DOT = "hk_.";
    public static final String HK_SPACE = "hk_ ";
    public static final String HK_BACKSPACE = "hk_<-";

    public ListInputTextArea() {
        this("");
    }

    public ListInputTextArea(String text) {
        super(text);
        this.setCaretPosition(0);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke("TAB")));
        this.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke("shift TAB")));
        ClipboardMenuHandler.config(this);
        this.setFont(new Font("Courier New", 0, 12));
        this.configSpecial(this);
    }

    private void configSpecial(JTextArea t) {
        IDEUtils.removeBinding(t, "ENTER");
        t.getInputMap().put(KeyStroke.getKeyStroke("ctrl ENTER"), "insert-break");
        t.getInputMap().put(KeyStroke.getKeyStroke("control COMMA"), HK_OPEN);
        t.getActionMap().put(HK_OPEN, new InsertSpecial("(", true));
        t.getInputMap().put(KeyStroke.getKeyStroke("control PERIOD"), HK_NIL);
        t.getActionMap().put(HK_NIL, new InsertSpecial("nil", true));
        t.getInputMap().put(KeyStroke.getKeyStroke("control SLASH"), HK_CLOSE);
        t.getActionMap().put(HK_CLOSE, new InsertSpecial(")", false));
        t.getInputMap().put(KeyStroke.getKeyStroke("control L"), HK_DOT);
        t.getInputMap().put(KeyStroke.getKeyStroke("control SEMICOLON"), HK_DOT);
        t.getActionMap().put(HK_DOT, new InsertSpecial(".", false));
        t.getInputMap().put(KeyStroke.getKeyStroke("control K"), HK_SPACE);
        t.getActionMap().put(HK_SPACE, new InsertSpecial(" ", false));
        t.getActionMap().put(HK_BACKSPACE, t.getActionMap().get("delete-previous"));
    }

    class InsertSpecial
    extends AbstractAction {
        String t;
        boolean checkWhitspace;

        InsertSpecial(String t, boolean checkWhitspace) {
            this.t = t;
            this.checkWhitspace = checkWhitspace;
        }

        public void actionPerformed(ActionEvent e) {
            JTextArea txt = (JTextArea)e.getSource();
            String c = null;
            try {
                c = txt.getText().substring(txt.getCaretPosition() - 1, txt.getCaretPosition());
            }
            catch (Exception exp) {
                // empty catch block
            }
            if (c == null) {
                txt.replaceSelection(this.t);
                return;
            }
            String insert = this.t;
            if (this.t.equals("(")) {
                if (!c.equals("(") && !c.equals(".")) {
                    insert = " " + insert;
                }
            } else if (this.t.toUpperCase().equals("NIL") && (c.toUpperCase().equals("L") || c.equals(")"))) {
                insert = " " + insert;
            }
            txt.replaceSelection(insert);
        }
    }
}

