/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import whilepack.cid.WhileUtils;
import whilepack.gui.IDEUtils;
import whilepack.gui.ListInputTextArea;
import whilepack.gui.ToolbarUtils;
import widex.layout.SpecPanel;
import widex.utils.Utils;

public class ListInputDialog
extends JDialog {
    private ListInputTextArea txt;
    private JButton btnOK;
    private JButton btnCancel;
    private boolean canceled;
    private File baseDirectory;
    JCheckBox chkDisplayAgain;
    private JButton hkOpen;
    private JButton hkNil;
    private JButton hkClose;
    private JButton hkDot;
    private JButton hkSpace;
    private JButton hkBackSpace;

    public ListInputDialog(Frame owner, String input, File file, File baseDirectory, boolean askInput) {
        super(owner, "Input for " + file.getName(), true);
        this.baseDirectory = baseDirectory;
        this.txt = new ListInputTextArea(input);
        String prompt = "<html>Enter Input (Press <b>Ctrl + Enter</b> to break line):</html>";
        JLabel lbl = new JLabel(prompt);
        JScrollPane scroller = new JScrollPane(this.txt);
        JPanel hotKeysPanel = this.createHotKeysPanel();
        JPanel hotAndCheck = new JPanel(new BorderLayout());
        this.chkDisplayAgain = new JCheckBox("Always display this dialog before running " + file.getName(), askInput);
        hotAndCheck.add(this.chkDisplayAgain);
        hotAndCheck.add(hotKeysPanel);
        this.btnOK = new JButton("OK");
        this.btnCancel = new JButton("Cancel");
        JPanel okCancel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        okCancel2.add(this.btnOK);
        okCancel2.add(this.btnCancel);
        JPanel okCancel = new JPanel(new BorderLayout());
        okCancel.add((Component)new JPanel(), "Center");
        okCancel.add((Component)okCancel2, "South");
        SpecPanel buttons = new SpecPanel("X", "P2");
        buttons.add((Component)hotKeysPanel);
        buttons.addFill();
        buttons.add((Component)okCancel2);
        JPanel lower = new JPanel(new BorderLayout());
        lower.add((Component)this.chkDisplayAgain, "West");
        lower.add((Component)buttons, "South");
        this.btnOK.addActionListener(new ApproveAction());
        this.btnCancel.addActionListener(new CancelAction());
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        mainPanel.add((Component)lbl, "North");
        mainPanel.add((Component)scroller, "Center");
        mainPanel.add((Component)lower, "South");
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.btnOK.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.btnOK);
        IDEUtils.removeBinding(this.getRootPane(), "ctrl ENTER");
        IDEUtils.removeBinding(this.getRootPane(), "ctrl released ENTER");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(mainPanel);
        this.setDefaultCloseOperation(2);
        this.setSize(450, 250);
        this.setLocationRelativeTo(owner);
        Utils.addEscKeyAction((JComponent)this.getRootPane(), (ActionListener)new CancelAction());
    }

    public void show() {
        this.canceled = true;
        super.show();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public String getText() {
        return this.txt.getText();
    }

    private JPanel createHotKeysPanel() {
        this.hkOpen = this.createHotKeyButton("(", "(", null, "hk_(");
        this.hkNil = this.createHotKeyButton("nil", "nil", null, "hk_nil");
        this.hkClose = this.createHotKeyButton(")", ")", null, "hk_)");
        this.hkDot = this.createHotKeyButton(".", ".", null, "hk_.");
        this.hkSpace = this.createHotKeyButton(" ", " ", null, "hk_ ");
        this.hkBackSpace = this.createHotKeyButton("BckSp", "<-", "Delete previous char", "hk_<-");
        JLabel lbl = new JLabel("Quick Symbols:");
        lbl.setVerticalAlignment(0);
        SpecPanel panel = new SpecPanel("X", "P2");
        panel.add((Component)lbl);
        panel.addGap(4);
        panel.add((Component)this.hkOpen);
        panel.addGap(1);
        panel.add((Component)this.hkNil);
        panel.addGap(1);
        panel.add((Component)this.hkDot);
        panel.addGap(1);
        panel.add((Component)this.hkSpace);
        panel.addGap(1);
        panel.add((Component)this.hkClose);
        return panel;
    }

    private JButton createHotKeyButton(String text, String instext, String tooltip, String actionStr) {
        JButton b = ToolbarUtils.createToolbarButton(text);
        b.setFocusable(false);
        b.setMargin(new Insets(2, 2, 2, 2));
        if (tooltip != null) {
            b.setToolTipText(tooltip);
        }
        final Action action = this.txt.getActionMap().get(actionStr);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                e.setSource(ListInputDialog.this.txt);
                action.actionPerformed(e);
            }
        });
        b.setFont(b.getFont().deriveFont(1));
        b.setSelected(true);
        return b;
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ListInputDialog.this.hide();
        }
    }

    class ApproveAction
    implements ActionListener {
        ApproveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                WhileUtils.BASE_DIR = ListInputDialog.this.baseDirectory;
                WhileUtils.buildInputTree(ListInputDialog.this.txt.getText());
                WhileUtils.BASE_DIR = null;
            }
            catch (Exception e1) {
                String p = "Input is not a legal list, please fix input\n\nError:\n" + e1.getMessage() + "";
                JOptionPane.showMessageDialog(ListInputDialog.this, p, "Error", 0);
                return;
            }
            ListInputDialog.this.canceled = false;
            ListInputDialog.this.hide();
        }
    }
}

