/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class FileNode {
    public static final int WCT = 0;
    public static final int WCL = 1;
    private Collection breakPoints = new ArrayList();
    private String fileName = null;
    File file = null;
    private int type = 0;
    private boolean asksInput = true;
    private boolean manualyEditedList = false;

    public FileNode(File file) {
        this(file, "");
    }

    public FileNode(File file, String bpts) {
        this.setFile(file);
        boolean isConcrete = file.getName().endsWith(".wcl");
        this.setType(isConcrete ? 1 : 0);
        this.parseBreakPoints(bpts);
    }

    public int getType() {
        return this.type;
    }

    private void setType(int type) {
        this.type = type;
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(File file) {
        this.file = file;
        this.fileName = file.getName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Collection getBreakPoints() {
        return this.breakPoints;
    }

    public void setBreakPoints(String breakPoints) {
        this.parseBreakPoints(breakPoints);
    }

    public void setBreakPoints(Collection breakPoints) {
        this.breakPoints = breakPoints;
    }

    public String toString() {
        return this.fileName;
    }

    private void parseBreakPoints(String bpts) {
        this.breakPoints = new ArrayList();
        bpts = " " + bpts + " ";
        StringTokenizer tok = new StringTokenizer(bpts, " ");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            if (token.length() == 0) continue;
            try {
                int line = Integer.parseInt(token);
                this.breakPoints.add(new Integer(line));
            }
            catch (Exception e) {}
        }
    }

    public String getBreakPointsAsString() {
        String str = "";
        Iterator iterator = this.breakPoints.iterator();
        while (iterator.hasNext()) {
            Integer integer = (Integer)iterator.next();
            str = str + integer + " ";
        }
        return str.trim();
    }

    public String getFileRelativeTo(File parentFile) {
        File file = this.file;
        String fileName = file.getName();
        for (file = file.getParentFile(); file != null && !file.equals(parentFile); file = file.getParentFile()) {
            fileName = file.getName() + "/" + fileName;
        }
        return fileName;
    }

    public boolean getAsksInput() {
        return this.asksInput;
    }

    public void setAsksInput(boolean asksInput) {
        this.asksInput = asksInput;
    }

    public boolean isManualyEditedList() {
        return this.manualyEditedList;
    }

    public void setManualyEditedList(boolean manualyEditedList) {
        this.manualyEditedList = manualyEditedList;
    }
}

