/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import whilepack.SysLog;
import whilepack.cid.Node;
import whilepack.cid.WhileTest;
import whilepack.cid.WhileUtils;
import whilepack.gui.ClipboardMenuHandler;
import whilepack.gui.CodeTextEditor;
import whilepack.gui.MyTextArea;
import whilepack.gui.ToolbarUtils;
import whilepack.gui.WhileIDE;
import whilepack.gui.help.ShowHelpTopicAction;
import whilepack.gui.widgets.GradientJLabel;
import widex.layout.SpecPanel;

public class ExecutionPanel
extends JPanel {
    private MyTextArea m_txtOutput;
    private JPanel toolBarRun;
    private WhileTest interpreter = null;
    private JLabel lblTitle;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy ; hh:mm:ss");
    private String EXECUTING = null;
    private int dots = 0;
    private Timer timer = new Timer(100, new DotListener());
    private int dotAppendCounter = 0;
    private int imgCounter = 0;

    public ExecutionPanel() {
        WhileIDE ide = WhileIDE.ide;
        JButton execute = ToolbarUtils.createToolbarButton(ide.m_runAction);
        JButton input = ToolbarUtils.createToolbarButton(ide.m_inputAction);
        JButton suspend = ToolbarUtils.createToolbarButton(ide.m_suspendAction);
        JButton cancel = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/cancel.png "));
        JButton help = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/help.png   "));
        help.addActionListener(new ShowHelpTopicAction("id2"));
        JButton[] buttons = new JButton[]{execute, input, suspend, cancel, help};
        for (int i = 0; i < buttons.length; ++i) {
            JButton button = buttons[i];
            button.setFocusable(false);
            button.setText("");
        }
        this.toolBarRun = new SpecPanel("Y", "P2");
        this.toolBarRun.add(execute);
        this.toolBarRun.add(input);
        this.toolBarRun.add(suspend);
        this.toolBarRun.add(help);
        this.m_txtOutput = new MyTextArea();
        this.m_txtOutput.addMouseListener(new ClipboardMenuHandler());
        this.m_txtOutput.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.m_txtOutput);
        this.m_txtOutput.setMinimumSize(new Dimension(200, 100));
        scroller.setMinimumSize(new Dimension(200, 0));
        this.m_txtOutput.setFont(new Font("Courier New", 0, 12));
        this.m_txtOutput.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke("TAB")));
        this.m_txtOutput.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke("shift TAB")));
        this.m_txtOutput.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    WhileIDE.ide.transferFocusToEditor();
                }
            }
        });
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.toolBarRun, "West");
        centerPanel.add((Component)scroller, "Center");
        Color color1 = new Color(108, 136, 191);
        Color color2 = new Color(128, 156, 211);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, color1, 0.0f, 8.0f, color2, true);
        this.lblTitle = new GradientJLabel("", paint);
        this.setTitle(null);
        this.lblTitle.setBackground(new Color(108, 136, 191));
        this.lblTitle.setForeground(Color.white);
        this.lblTitle.setPreferredSize(new Dimension(0, this.lblTitle.getPreferredSize().height + 4));
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(1));
        this.lblTitle.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.white), new EmptyBorder(0, 5, 0, 0)));
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblTitle, "North");
        this.add(centerPanel);
    }

    public void suspend() {
        if (this.interpreter == null) {
            return;
        }
        this.interpreter.breakInterpretation();
    }

    public void execute(Component source) {
        WhileIDE ide = WhileIDE.ide;
        String code = ide.m_compAction.compile();
        SysLog.out.println("CODE: " + code);
        if (code == null) {
            return;
        }
        CodeTextEditor editor = ide.editor();
        String input = ide.editor().getLastUsedInput();
        ide.lowerPanel.showRun();
        this.executeImpl(source, code, input, editor.getFile());
    }

    private void executeImpl(Component source, String code, String input, File file) {
        WhileIDE ide = WhileIDE.ide;
        this.setTitle(file.getName());
        this.m_txtOutput.setText("");
        this.m_txtOutput.append("Time      : " + this.sdf.format(new Date()) + "\n", Color.blue);
        this.m_txtOutput.append("Executing : " + file.getAbsolutePath() + "\n", Color.blue);
        this.m_txtOutput.append("Directory : " + file.getParent() + "\n", Color.blue);
        this.m_txtOutput.append("Input:\n", Color.blue);
        input = ide.m_inputAction.getInput(source);
        if (input == null) {
            this.m_txtOutput.append("Executing Canceled.", Color.blue);
            return;
        }
        this.m_txtOutput.append(input);
        WhileUtils.BASE_DIR = file.getParentFile();
        Node[] pd = this.getPD(code, input);
        WhileUtils.BASE_DIR = null;
        if (pd == null) {
            return;
        }
        ide.prepareGuiForRunExecution();
        Node program = pd[0];
        Node data = pd[1];
        this.interpreter = new WhileTest();
        this.m_txtOutput.append("\n");
        this.EXECUTING = "Executing, please wait";
        this.m_txtOutput.append(this.EXECUTING, Color.blue);
        this.timer.start();
        new Thread(new ExecutionRunnable(this.interpreter, program, data)).start();
    }

    private void handleStopTimer() {
        this.m_txtOutput.removeFromEnd(this.dots);
        this.m_txtOutput.removeFromEnd(this.EXECUTING.length());
        this.dots = 0;
        this.dotAppendCounter = 0;
        this.imgCounter = 0;
    }

    private Node[] getPD(String code, String input) {
        Node program = null;
        Node data = null;
        try {
            SysLog.out.println("CODE CODE: " + code);
            program = WhileUtils.buildProgramTree(code);
            SysLog.out.println("PRG PRG: " + WhileUtils.toList(program));
        }
        catch (Exception e) {
            e.printStackTrace();
            WhileIDE.okDialog("Cannot build program tree\n\n" + e.getMessage(), true);
            return null;
        }
        try {
            data = WhileUtils.buildInputTree(input);
        }
        catch (Exception e) {
            e.printStackTrace();
            WhileIDE.okDialog("Cannot build input tree\n\n" + e.getMessage(), true);
            return null;
        }
        return new Node[]{program, data};
    }

    public void setTitle(String text) {
        String t = text == null ? "" : " - " + text;
        this.lblTitle.setText("Run" + t);
    }

    public boolean isRunning() {
        return this.interpreter != null;
    }

    static /* synthetic */ void access$700(ExecutionPanel x0) {
        x0.handleStopTimer();
    }

    class ExecutionRunnable
    implements Runnable {
        WhileTest interpreter;
        Node program;
        Node data;

        public ExecutionRunnable(WhileTest interpreter, Node program, Node data) {
            this.interpreter = interpreter;
            this.program = program;
            this.data = data;
        }

        public void run() {
            Exception error = null;
            SysLog.out.println("============================-----===========----------=======");
            SysLog.out.println(WhileUtils.toList(this.program));
            try {
                this.interpreter.interpret(this.program, this.data);
            }
            catch (Exception e) {
                WhileIDE.okDialog("Encountered while executing program");
                e.printStackTrace();
                error = e;
            }
            ExecutionPanel.this.timer.stop();
            Exception error1 = error;
            SwingUtilities.invokeLater(new Runnable(this, error1){
                private final /* synthetic */ Exception val$error1;
                private final /* synthetic */ ExecutionRunnable this$1;
                {
                    this.this$1 = this$1;
                    this.val$error1 = val$error1;
                }

                public void run() {
                    ExecutionPanel.access$700(ExecutionRunnable.access$600(this.this$1));
                    ExecutionPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("\n", Color.blue);
                    if (this.this$1.interpreter.wasInterpretationCanceled()) {
                        ExecutionPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("Execution halted by user.", Color.red);
                        ExecutionPanel.access$100(ExecutionRunnable.access$600(this.this$1)).setIcon(new ImageIcon("images/execution/testTerminated.png"));
                    } else if (this.val$error1 == null) {
                        ExecutionPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("Execution completed, Result: ", Color.blue);
                        ExecutionPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("\n");
                        Node result = this.this$1.interpreter.getResult();
                        String asList = WhileUtils.toList(result);
                        ExecutionPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append(asList.toLowerCase());
                        ExecutionPanel.access$100(ExecutionRunnable.access$600(this.this$1)).setIcon(new ImageIcon("images/execution/testPassed.png"));
                    } else {
                        ExecutionPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("Execution halted, Reason: ", Color.blue);
                        ExecutionPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("\n");
                        ExecutionPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append(this.val$error1.getMessage(), Color.red);
                        ExecutionPanel.access$100(ExecutionRunnable.access$600(this.this$1)).setIcon(new ImageIcon("images/execution/testError.png"));
                    }
                    WhileIDE.ide.prepareGuiForRunTermination();
                }
            });
        }

        static /* synthetic */ ExecutionPanel access$600(ExecutionRunnable x0) {
            return x0.ExecutionPanel.this;
        }
    }

    class DotListener
    implements ActionListener {
        private Icon[] executionIcons = new Icon[8];

        DotListener() {
            this.executionIcons[0] = new ImageIcon("images/execution/testInProgress1.png");
            this.executionIcons[1] = new ImageIcon("images/execution/testInProgress2.png");
            this.executionIcons[2] = new ImageIcon("images/execution/testInProgress3.png");
            this.executionIcons[3] = new ImageIcon("images/execution/testInProgress4.png");
            this.executionIcons[4] = new ImageIcon("images/execution/testInProgress5.png");
            this.executionIcons[5] = new ImageIcon("images/execution/testInProgress6.png");
            this.executionIcons[6] = new ImageIcon("images/execution/testInProgress7.png");
            this.executionIcons[7] = new ImageIcon("images/execution/testInProgress8.png");
        }

        public void actionPerformed(ActionEvent e) {
            ExecutionPanel.this.imgCounter++;
            if (ExecutionPanel.this.imgCounter == this.executionIcons.length) {
                ExecutionPanel.this.imgCounter = 0;
            }
            ExecutionPanel.this.lblTitle.setIcon(this.executionIcons[ExecutionPanel.this.imgCounter]);
            ExecutionPanel.this.dotAppendCounter++;
            if (ExecutionPanel.this.dotAppendCounter == 5) {
                ExecutionPanel.this.dotAppendCounter = 0;
            }
        }

        void appendDot() {
            if (ExecutionPanel.this.dots == 3) {
                ExecutionPanel.this.dots = 0;
                ExecutionPanel.this.m_txtOutput.removeFromEnd(3);
                return;
            }
            ExecutionPanel.this.dots++;
            ExecutionPanel.this.m_txtOutput.append(".", Color.blue);
        }
    }
}

