/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.MatteBorder;
import whilepack.SysLog;
import whilepack.cid.DebugMediator;
import whilepack.cid.Node;
import whilepack.cid.WhileDebugger;
import whilepack.cid.WhileUtils;
import whilepack.gui.ClipboardMenuHandler;
import whilepack.gui.CodeTextEditor;
import whilepack.gui.DebugActions;
import whilepack.gui.IDEUtils;
import whilepack.gui.MyTextArea;
import whilepack.gui.ToolbarUtils;
import whilepack.gui.WatchTable;
import whilepack.gui.WhileIDE;
import whilepack.gui.help.ShowHelpTopicAction;
import whilepack.gui.widgets.GradientJLabel;
import widex.layout.SpecLayout;

public class DebugPanel
extends JPanel
implements DebugMediator {
    private MyTextArea m_txtOutput;
    private WatchTable watchTable;
    private JPanel toolBarDebug;
    private JLabel lblTitle;
    private JSplitPane splitter;
    private WhileDebugger interpreter = null;
    private int runToCursorLine = -1;
    private CodeTextEditor editor;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy ; hh:mm:ss");
    private String EXECUTING = null;
    private int dots = 0;
    private DotListener timerAction = new DotListener();
    private Timer timer = new Timer(100, this.timerAction);
    private int dotAppendCounter = 0;
    private int imgCounter = 0;
    private Object highlightTag = null;
    private Object waitingObject = new Object();
    private int currentLine = -1;
    private Object wo = new Object();

    public DebugPanel() {
        JButton debug = ToolbarUtils.createToolbarButton(DebugActions.debugAction);
        JButton resume = ToolbarUtils.createToolbarButton(DebugActions.resumeAction);
        JButton suspend2 = ToolbarUtils.createToolbarButton(DebugActions.suspendAction);
        JButton pause2 = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/pause.png"));
        JButton cancel2 = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/cancel.png"));
        JButton help2 = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/help.png"));
        JButton stepOver = ToolbarUtils.createToolbarButton(DebugActions.stepOverAction);
        JButton stepInto = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/traceInto.png"));
        JButton stepOut = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/stepOut.png"));
        JButton runToCursor = ToolbarUtils.createToolbarButton(DebugActions.runToCursorAction);
        JButton showExePoint = ToolbarUtils.createToolbarButton(DebugActions.showExePointAction);
        JButton help = ToolbarUtils.createToolbarButton(new ImageIcon("images/action/help.png"));
        help.addActionListener(new ShowHelpTopicAction("id3"));
        JButton[] cs = new JButton[]{debug, resume, pause2, suspend2, cancel2, help2, stepOver, stepInto, stepOut, runToCursor, showExePoint, help};
        for (int i = 0; i < cs.length; ++i) {
            JButton button = cs[i];
            button.setFocusable(false);
            button.setText("");
        }
        this.toolBarDebug = new JPanel((LayoutManager)new SpecLayout("P,P", "P,P,P,P"));
        this.toolBarDebug.add((Component)debug, "0, 0");
        this.toolBarDebug.add((Component)resume, "0, 1");
        this.toolBarDebug.add((Component)suspend2, "0, 2");
        this.toolBarDebug.add((Component)help, "0, 3");
        this.toolBarDebug.add((Component)stepOver, "1, 0");
        this.toolBarDebug.add((Component)runToCursor, "1, 1");
        this.toolBarDebug.add((Component)showExePoint, "1, 2");
        this.m_txtOutput = new MyTextArea();
        this.m_txtOutput.addMouseListener(new ClipboardMenuHandler());
        this.m_txtOutput.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.m_txtOutput);
        this.m_txtOutput.setMinimumSize(new Dimension(0, 100));
        scroller.setMinimumSize(new Dimension(0, 0));
        this.m_txtOutput.setFont(new Font("Courier New", 0, 12));
        this.m_txtOutput.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke("TAB")));
        this.m_txtOutput.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke("shift TAB")));
        this.m_txtOutput.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    WhileIDE.ide.transferFocusToEditor();
                }
            }
        });
        this.watchTable = new WatchTable();
        this.splitter = new JSplitPane(1, scroller, this.watchTable);
        this.splitter.setDividerLocation(0.8);
        this.splitter.setResizeWeight(1.0);
        this.splitter.setBorder(null);
        IDEUtils.removeBinding(this.splitter, "F6");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.toolBarDebug, "West");
        centerPanel.add((Component)this.splitter, "Center");
        Color color1 = new Color(108, 136, 191);
        Color color2 = new Color(128, 156, 211);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, color1, 0.0f, 8.0f, color2, true);
        this.lblTitle = new GradientJLabel("", paint);
        this.setTitle(null);
        this.lblTitle.setBackground(new Color(108, 136, 191));
        this.lblTitle.setForeground(Color.white);
        this.lblTitle.setPreferredSize(new Dimension(0, this.lblTitle.getPreferredSize().height + 4));
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(1));
        this.lblTitle.setBorder(new MatteBorder(0, 0, 1, 0, Color.white));
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblTitle, "North");
        this.add(centerPanel);
    }

    public void setTitle(String text) {
        String t = text == null ? "" : " - " + text;
        this.lblTitle.setText("  Debug" + t);
    }

    public void suspend() {
        if (this.interpreter == null) {
            return;
        }
        this.interpreter.breakInterpretation();
        this.notifyInterpretter();
    }

    public void execute(Component source) {
        WhileIDE ide = WhileIDE.ide;
        ArrayList code = ide.m_compAction.compileForDebug();
        if (code == null) {
            return;
        }
        this.editor = ide.editor();
        String input = this.editor.getLastUsedInput();
        ide.lowerPanel.showDebug();
        this.executeImpl(source, code, input, this.editor.getFile());
    }

    private void executeImpl(Component source, ArrayList code, String input, File file) {
        WhileIDE ide = WhileIDE.ide;
        this.setTitle(file.getName());
        this.m_txtOutput.setText("");
        this.m_txtOutput.append("Time      : " + this.sdf.format(new Date()) + "\n", Color.blue);
        this.m_txtOutput.append("Executing : " + file.getAbsolutePath() + "\n", Color.blue);
        this.m_txtOutput.append("Directory : " + file.getParent() + "\n", Color.blue);
        this.m_txtOutput.append("Input:\n", Color.blue);
        input = ide.m_inputAction.getInput(source);
        if (input == null) {
            this.m_txtOutput.append("Debugging Canceled.", Color.blue);
            return;
        }
        this.m_txtOutput.append(input);
        WhileUtils.BASE_DIR = file.getParentFile();
        Object[] pd = this.getPD(code, input);
        WhileUtils.BASE_DIR = null;
        if (pd == null) {
            return;
        }
        ArrayList program = (ArrayList)pd[0];
        Node data = (Node)pd[1];
        this.interpreter = new WhileDebugger(this);
        this.interpreter.addWatchVariableListener(this.watchTable);
        this.m_txtOutput.append("\n");
        this.debugStarting();
        this.EXECUTING = "Executing, please wait";
        this.m_txtOutput.append(this.EXECUTING, Color.blue);
        this.timerAction.doTick();
        this.timer.start();
        new Thread(new ExecutionRunnable(this.interpreter, program, data)).start();
    }

    private void debugStarting() {
        if (this.editor.getFileType() == 1) {
            SysLog.out.println("AAAAAAAAA");
        }
        this.editor.txt.setReadOnly(true);
        this.watchTable.clear();
        DebugActions.initDebug();
    }

    private void debugFinished() {
        this.editor.txt.setReadOnly(false);
        DebugActions.finishDebug();
    }

    private void handleStopTimer() {
        this.m_txtOutput.removeFromEnd(this.dots);
        this.m_txtOutput.removeFromEnd(this.EXECUTING.length());
        this.dots = 0;
        this.dotAppendCounter = 0;
        this.imgCounter = 0;
    }

    private Object[] getPD(ArrayList code, String input) {
        Node data = null;
        try {
            data = WhileUtils.buildInputTree(input);
        }
        catch (Exception e) {
            WhileIDE.okDialog("Cannot build input tree\n\n" + e.getMessage(), true);
            return null;
        }
        return new Object[]{code, data};
    }

    public boolean isRunning() {
        return this.interpreter != null;
    }

    public boolean isBreakPoint(int line) {
        if (line == this.runToCursorLine) {
            this.runToCursorLine = -1;
            return true;
        }
        return this.editor.hasBreakPoint(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnLine(final int line) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = DebugPanel.this.wo;
                synchronized (object) {
                    DebugPanel.this.currentLine = line;
                    Object obj = DebugPanel.this.editor.markLine(DebugPanel.this.currentLine);
                    for (int i = 0; i < 1000; ++i) {
                        if (DebugPanel.this.highlightTag != null) continue;
                        DebugPanel.this.highlightTag = obj;
                        break;
                    }
                }
                DebugPanel.this.editor.gotoLocation(line, 1, DebugPanel.this.editor.getFileType());
                DebugPanel.this.timer.stop();
                DebugActions.executionPaused();
            }
        });
        try {
            Object object = this.waitingObject;
            synchronized (object) {
                this.waitingObject.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        SysLog.out.println("Wait");
    }

    public void runToCursor() {
        this.runToCursorLine = this.editor.getCurrentLine() + 1;
        this.resumeProgram();
    }

    public void resumeProgram() {
        this.interpreter.setWaitingEachStep(false);
        this.notifyInterpretter();
    }

    public void stepOver() {
        this.interpreter.setWaitingEachStep(true);
        this.notifyInterpretter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showExecutionPoint() {
        Object object = this.wo;
        synchronized (object) {
            if (this.currentLine != -1) {
                this.editor.gotoLocation(this.currentLine, 1, this.editor.getFileType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterpretter() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = DebugPanel.this.wo;
                synchronized (object) {
                    DebugPanel.this.currentLine = -1;
                    DebugPanel.this.timerAction.doTick();
                    DebugPanel.this.editor.clearMark(DebugPanel.this.highlightTag);
                    DebugPanel.this.highlightTag = null;
                }
                if (!DebugPanel.this.interpreter.wasInterpretationCanceled() && !DebugPanel.this.interpreter.isWaitingEachStep()) {
                    DebugPanel.this.timer.start();
                    DebugActions.executionResumed();
                }
            }
        });
        Object object = this.waitingObject;
        synchronized (object) {
            this.waitingObject.notifyAll();
        }
    }

    public JSplitPane getSplitter() {
        return this.splitter;
    }

    public void ideVisible() {
    }

    static /* synthetic */ void access$700(DebugPanel x0) {
        x0.debugFinished();
    }

    static /* synthetic */ void access$800(DebugPanel x0) {
        x0.handleStopTimer();
    }

    class ExecutionRunnable
    implements Runnable {
        WhileDebugger interpreter;
        ArrayList program;
        Node data;

        public ExecutionRunnable(WhileDebugger interpreter, ArrayList program, Node data) {
            this.interpreter = interpreter;
            this.program = program;
            this.data = data;
        }

        public void run() {
            Exception error = null;
            try {
                this.interpreter.interpret(this.program, this.data);
            }
            catch (Exception e) {
                WhileIDE.okDialog("Encountered while debugging program");
                e.printStackTrace();
                error = e;
            }
            DebugPanel.this.timer.stop();
            Exception error1 = error;
            SwingUtilities.invokeLater(new Runnable(this, error1){
                private final /* synthetic */ Exception val$error1;
                private final /* synthetic */ ExecutionRunnable this$1;
                {
                    this.this$1 = this$1;
                    this.val$error1 = val$error1;
                }

                public void run() {
                    DebugPanel.access$700(ExecutionRunnable.access$600(this.this$1));
                    DebugPanel.access$800(ExecutionRunnable.access$600(this.this$1));
                    DebugPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("\n", Color.blue);
                    if (this.this$1.interpreter.wasInterpretationCanceled()) {
                        DebugPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("Execution halted by user.", Color.red);
                        DebugPanel.access$100(ExecutionRunnable.access$600(this.this$1)).setIcon(new ImageIcon("images/execution/testTerminated.png"));
                    } else if (this.val$error1 == null) {
                        DebugPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("Execution completed, Result: ", Color.blue);
                        DebugPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("\n");
                        DebugPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append(WhileUtils.toList(this.this$1.interpreter.getResult()).toLowerCase());
                        DebugPanel.access$100(ExecutionRunnable.access$600(this.this$1)).setIcon(new ImageIcon("images/execution/testPassed.png"));
                    } else {
                        DebugPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("Execution halted, Reason: ", Color.blue);
                        DebugPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append("\n");
                        DebugPanel.access$400(ExecutionRunnable.access$600(this.this$1)).append(this.val$error1.getMessage(), Color.red);
                        DebugPanel.access$100(ExecutionRunnable.access$600(this.this$1)).setIcon(new ImageIcon("images/execution/testError.png"));
                    }
                }
            });
        }

        static /* synthetic */ DebugPanel access$600(ExecutionRunnable x0) {
            return x0.DebugPanel.this;
        }
    }

    class DotListener
    implements ActionListener {
        private Icon[] executionIcons = new Icon[8];

        DotListener() {
            this.executionIcons[0] = new ImageIcon("images/execution/testInProgress1.png");
            this.executionIcons[1] = new ImageIcon("images/execution/testInProgress2.png");
            this.executionIcons[2] = new ImageIcon("images/execution/testInProgress3.png");
            this.executionIcons[3] = new ImageIcon("images/execution/testInProgress4.png");
            this.executionIcons[4] = new ImageIcon("images/execution/testInProgress5.png");
            this.executionIcons[5] = new ImageIcon("images/execution/testInProgress6.png");
            this.executionIcons[6] = new ImageIcon("images/execution/testInProgress7.png");
            this.executionIcons[7] = new ImageIcon("images/execution/testInProgress8.png");
        }

        public void actionPerformed(ActionEvent e) {
            this.doTick();
        }

        public void doTick() {
            DebugPanel.this.imgCounter++;
            if (DebugPanel.this.imgCounter == this.executionIcons.length) {
                DebugPanel.this.imgCounter = 0;
            }
            DebugPanel.this.lblTitle.setIcon(this.executionIcons[DebugPanel.this.imgCounter]);
            DebugPanel.this.dotAppendCounter++;
            if (DebugPanel.this.dotAppendCounter == 5) {
                DebugPanel.this.dotAppendCounter = 0;
            }
        }

        void appendDot() {
            if (DebugPanel.this.dots == 3) {
                DebugPanel.this.dots = 0;
                DebugPanel.this.m_txtOutput.removeFromEnd(3);
                return;
            }
            DebugPanel.this.dots++;
            DebugPanel.this.m_txtOutput.append(".", Color.blue);
        }
    }
}

