/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import whilepack.gui.AbstractAction2;
import whilepack.gui.WhileIDE;

public class DebugActions {
    public static final DebugAction debugAction = new DebugAction();
    public static final ResumeAction resumeAction = new ResumeAction();
    public static final RunToCursorAction runToCursorAction = new RunToCursorAction();
    public static final ShowExePointAction showExePointAction = new ShowExePointAction();
    public static final StepOverAction stepOverAction = new StepOverAction();
    public static final SuspendAction suspendAction = new SuspendAction();

    private static void setEnabled(boolean e) {
        debugAction.setEnabled(e);
        resumeAction.setEnabled(e);
        runToCursorAction.setEnabled(e);
        showExePointAction.setEnabled(e);
        stepOverAction.setEnabled(e);
        suspendAction.setEnabled(e);
    }

    public static void initDebug() {
        debugAction.setEnabled(false);
        suspendAction.setEnabled(true);
        WhileIDE.ide.prepareGuiForDebugExecution();
        resumeAction.setEnabled(false);
        runToCursorAction.setEnabled(false);
        showExePointAction.setEnabled(false);
        stepOverAction.setEnabled(false);
    }

    public static void executionPaused() {
        resumeAction.setEnabled(true);
        runToCursorAction.setEnabled(true);
        showExePointAction.setEnabled(true);
        stepOverAction.setEnabled(true);
    }

    public static void executionResumed() {
        resumeAction.setEnabled(false);
        runToCursorAction.setEnabled(false);
        showExePointAction.setEnabled(false);
        stepOverAction.setEnabled(false);
    }

    public static void finishDebug() {
        debugAction.setEnabled(true);
        WhileIDE.ide.prepareGuiForDebugTermination();
        resumeAction.setEnabled(false);
        suspendAction.setEnabled(false);
        runToCursorAction.setEnabled(false);
        showExePointAction.setEnabled(false);
        stepOverAction.setEnabled(false);
    }

    static {
        DebugActions.setEnabled(false);
    }

    public static class RunToCursorAction
    extends AbstractAction2 {
        public RunToCursorAction() {
            super("Run to Cursor", new ImageIcon("images/action/runToCursor.png"));
            this.putValue("ShortDescription", "Run to Cursor");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F10"));
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE.ide.getDebugPanel().runToCursor();
        }
    }

    public static class ShowExePointAction
    extends AbstractAction2 {
        public ShowExePointAction() {
            super("Go to Execution Point", new ImageIcon("images/action/showCurrentFrame.png"));
            this.putValue("ShortDescription", "Go to Execution Point");
            this.putValue("MnemonicKey", new Integer(120));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE.ide.getDebugPanel().showExecutionPoint();
        }
    }

    public static class StepOverAction
    extends AbstractAction2 {
        public StepOverAction() {
            super("Step Over", new ImageIcon("images/action/traceOver.png"));
            this.putValue("ShortDescription", "Step Over");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F10"));
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE.ide.getDebugPanel().stepOver();
        }
    }

    public static class ResumeAction
    extends AbstractAction2 {
        public ResumeAction() {
            super("Resume Program", new ImageIcon("images/action/resume.png"));
            this.putValue("ShortDescription", "Resume Program");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift F10"));
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE.ide.getDebugPanel().resumeProgram();
        }
    }

    public static class SuspendAction
    extends AbstractAction2 {
        public SuspendAction() {
            super("Suspend Debug", new ImageIcon("images/action/suspend.png"));
            this.putValue("ShortDescription", "Suspend Debug");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F6"));
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            WhileIDE.ide.getDebugPanel().suspend();
        }
    }

    public static class DebugAction
    extends AbstractAction2
    implements Runnable {
        Component source;

        public DebugAction() {
            super("Debug", new ImageIcon("images/action/startDebugger.png"));
            this.putValue("ShortDescription", "Debug");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F6"));
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent e) {
            this.source = (Component)e.getSource();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            WhileIDE.ide.getDebugPanel().execute(this.source);
        }
    }
}

