/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import novaworx.syntax.SyntaxFactory;
import novaworx.textpane.SyntaxDocument;
import novaworx.textpane.SyntaxStyle;
import novaworx.textpane.SyntaxTextPane;
import whilepack.SysLog;
import whilepack.cid.WCCException;
import whilepack.cid.WhileCompiler3;
import whilepack.cid.WhileUtils;
import whilepack.general.SugarHandler;
import whilepack.gui.ClipboardMenuHandler;
import whilepack.gui.DirtyListener;
import whilepack.gui.StatusBar;
import whilepack.gui.UndoRedoListener;
import whilepack.gui.aa2;
import whilepack.gui.syntaxutils.WideSyntaxHandler;
import whilepack.gui.texteditor.MarginMouseListener;

public class CodeTextEditor {
    public static final int WHILE_TEXT = 0;
    public static final int WHILE_LIST = 1;
    public SyntaxTextPane txt;
    JScrollPane scroller;
    private boolean m_isDirty = false;
    File m_file = null;
    private int m_fileType;
    private String m_lastUsedInput = "";
    private boolean externalChanged = false;
    private ArrayList lines = new ArrayList();
    private ThisDocumentListener documentListener;
    private MyUndoableEditListener myUndoableEditListener;
    private boolean overwriteText = false;
    private JLabel2 l;
    private StyledDoc doc;
    private CaretListener caretListener = null;
    private static final int INCREASE_INDENT = 0;
    private static final int DECREASE_INDENT = 1;
    private static final int INCREASE_COMMENT_INDENT = 2;
    private static final int DECREASE_COMMENT_INDENT = 3;
    DirtyListener m_dirtyListener;
    private UndoRedoListener undoRedoListener;
    private static Cursor mirrorCursor = null;
    private UndoManager undoManager = new UndoManager();

    public CodeTextEditor(File file, int fileType) {
        this.m_file = file;
        if (this.m_file != null) {
            this.loadLastUsedInput();
        }
        this.m_isDirty = false;
        WideSyntaxHandler.init();
        this.txt = new SyntaxTextPane();
        this.txt.setTabSize(4);
        this.doc = new StyledDoc();
        this.documentListener = new ThisDocumentListener();
        this.doc.addDocumentListener(this.documentListener);
        this.myUndoableEditListener = new MyUndoableEditListener();
        this.doc.addUndoableEditListener(this.myUndoableEditListener);
        if (fileType == 1) {
            this.doc.setSyntax(SyntaxFactory.getSyntax((String)"wcl"));
        } else if (fileType == 0) {
            this.doc.setSyntax(SyntaxFactory.getSyntax((String)"wct"));
        }
        this.m_fileType = fileType;
        SyntaxStyle[] style = this.txt.getSyntaxStyles();
        style[7].setFontStyle(1);
        style[8].setFontStyle(1);
        style[2].setForeground(new Color(100, 0, 100));
        style[8].setForeground(new Color(110, 10, 110));
        style[7].setForeground(new Color(0, 0, 128));
        style[5].setForeground(new Color(0, 128, 0));
        style[2] = style[5];
        this.txt.setDocument((Document)((Object)this.doc));
        this.txt.setFont(new Font("Courier New", 0, 12));
        this.txt.setLineHighlight(true);
        this.txt.setBracketHighlight(true);
        this.txt.setSelectedTextColor(Color.white);
        this.txt.setCaretColor(Color.blue.darker());
        ClipboardMenuHandler.config((JTextComponent)this.txt);
        this.installKeyboardFeatures();
        this.installGutter();
        JPanel pp = new JPanel(new BorderLayout());
        pp.add((Component)this.l, "West");
        pp.add((Component)this.txt, "Center");
        pp.setBackground(Color.white);
        this.scroller = new JScrollPane(pp);
        this.scroller.getHorizontalScrollBar().setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setFocusable(false);
        this.scroller.getViewport().setBackground(Color.white);
        this.scroller.setBackground(Color.white);
        this.scroller.getVerticalScrollBar().setUnitIncrement(24);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(10);
        this.scroller.setBackground(Color.white);
        this.scroller.getViewport().setOpaque(false);
        this.scroller.getViewport().setBackground(Color.white);
    }

    private void installGutter() {
        this.l = new JLabel2();
        this.l.setOpaque(true);
        this.l.setBorder(new MatteBorder(0, 0, 0, 1, new Color(197, 197, 197)));
        this.l.setPreferredSize(new Dimension(20, 0));
        MarginMouseListener ll1 = new MarginMouseListener(this);
        ToggleBreakPointMouseListener ll = new ToggleBreakPointMouseListener();
        this.l.addMouseListener(ll);
        this.l.addMouseListener(ll1);
        this.l.addMouseMotionListener(ll1);
    }

    private void installKeyboardFeatures() {
        this.txt.setFocusTraversalKeysEnabled(false);
        this.txt.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke("shift ENTER"), new DefaultEditorKit.InsertBreakAction());
        this.txt.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke("shift DELETE"), new DefaultEditorKit.CutAction());
        String U = "UndoMangerWrapper.UndoAction";
        String R = "UndoMangerWrapper.RedoAction";
        this.txt.getInputMap().put(KeyStroke.getKeyStroke("control pressed Z"), U);
        this.txt.getActionMap().put(U, new UndoAction());
        this.txt.getInputMap().put(KeyStroke.getKeyStroke("control pressed Y"), R);
        this.txt.getActionMap().put(R, new RedoAction());
        this.txt.getInputMap().put(KeyStroke.getKeyStroke("control pressed DELETE"), "DELETE-NEXT-WORD");
        this.txt.getActionMap().put("DELETE-NEXT-WORD", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int bb = CodeTextEditor.this.txt.getCaretPosition();
                    int ee = Utilities.getNextWord((JTextComponent)CodeTextEditor.this.txt, bb);
                    CodeTextEditor.this.txt.getDocument().remove(bb, ee - bb);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.txt.getInputMap().put(KeyStroke.getKeyStroke("control pressed BACK_SPACE"), "DELETE-PREV-WORD");
        this.txt.getActionMap().put("DELETE-PREV-WORD", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int bb = CodeTextEditor.this.txt.getCaretPosition();
                    int ee = Utilities.getPreviousWord((JTextComponent)CodeTextEditor.this.txt, bb);
                    CodeTextEditor.this.txt.getDocument().remove(ee, bb - ee);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.txt.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "TOGGLE-OVERWRITEMODE");
        this.txt.getActionMap().put("TOGGLE-OVERWRITEMODE", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CodeTextEditor.this.overwriteText = !CodeTextEditor.this.overwriteText;
                CodeTextEditor.this.txt.setBlockCaret(CodeTextEditor.this.overwriteText);
                CodeTextEditor.this.txt.setBlockSelect(CodeTextEditor.this.overwriteText);
                if (CodeTextEditor.this.overwriteText) {
                    CodeTextEditor.this.txt.setCaretColor(Color.orange);
                    CodeTextEditor.this.txt.setBlockCaretHighlight(CodeTextEditor.this.txt.getCaretPosition());
                } else {
                    CodeTextEditor.this.txt.setCaretColor(Color.blue.darker());
                }
                CodeTextEditor.this.txt.repaint();
            }
        });
        this.registerReplceAction("TAB", "INCREASE_INDENT", 0);
        this.registerReplceAction("shift TAB", "DECREASE_INDENT", 1);
        this.registerReplceAction("control M", "INCREASE_COMMENT", 2);
        this.registerReplceAction("control shift M", "DECREASE_COMMENT", 3);
    }

    private void registerReplceAction(String keyStroke, String actionName, final int type) {
        this.txt.getInputMap().put(KeyStroke.getKeyStroke(keyStroke), actionName);
        this.txt.getActionMap().put(actionName, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CodeTextEditor.this.replaceSelection(type);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    void fixCaretListener(final StatusBar sb) {
        if (this.caretListener == null) {
            this.caretListener = new CaretListener(){

                public void caretUpdate(CaretEvent ev) {
                    CodeTextEditor.this.updateLineCol(sb);
                }
            };
        }
        this.txt.addCaretListener(this.caretListener);
    }

    void updateLineCol(StatusBar sb) {
        int pos = this.txt.getCaretPosition();
        Element map = this.txt.getDocument().getDefaultRootElement();
        int row = map.getElementIndex(pos);
        Element lineElem = map.getElement(row);
        int col = pos - lineElem.getStartOffset();
        sb.setLineCol(row + 1, col + 1, pos);
    }

    private void replaceSelection(int type) throws BadLocationException {
        int startLine;
        String text = this.txt.getSelectedText();
        if (text == null) {
            if (type == 0) {
                this.doc.insertString(this.txt.getCaretPosition(), "\t", null);
            }
            return;
        }
        int selectionStart = this.txt.getSelectionStart();
        if (selectionStart - (startLine = this.posToStartEndLine(selectionStart)[0]) > 0) {
            text = this.txt.getText(startLine, selectionStart - startLine) + text;
        }
        if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        StringBuffer buffer = new StringBuffer(text);
        if (type == 0) {
            this.increaseIndent(buffer);
        } else if (type == 2) {
            this.increaseCommentIndent(buffer);
        } else if (type == 1) {
            this.decreaseBuffer(buffer, type);
        } else if (type == 3) {
            this.decreaseBuffer(buffer, type);
        } else {
            throw new IllegalArgumentException("Illegal type");
        }
        this.myUndoableEditListener.startStop();
        this.doc.replace(startLine, text.length(), buffer.toString(), null);
        this.myUndoableEditListener.startStop();
        this.txt.setSelectionStart(startLine);
        this.txt.setSelectionEnd(startLine + buffer.length());
    }

    private void increaseIndent(StringBuffer buffer) {
        buffer.insert(0, "\t");
        int pos = buffer.indexOf("\n");
        while (pos != -1) {
            buffer.insert(pos + 1, "\t");
            pos = buffer.indexOf("\n", pos + 5);
        }
    }

    private void increaseCommentIndent(StringBuffer buffer) {
        buffer.insert(0, "//");
        int pos = buffer.indexOf("\n");
        while (pos != -1) {
            buffer.insert(pos + 1, "//");
            pos = buffer.indexOf("\n", pos + 5);
        }
    }

    private void decreaseBuffer(StringBuffer buffer, int type) {
        String lineSep = "\n";
        try {
            BufferedReader in = new BufferedReader(new StringReader(buffer.toString()));
            String line = in.readLine();
            buffer.delete(0, buffer.length());
            while (line != null) {
                if (type == 1) {
                    line = this.removeIndentFromLine(line);
                } else if (type == 3) {
                    line = this.removeCommentIndentFromLine(line);
                } else {
                    throw new IllegalArgumentException("Illegal type");
                }
                buffer.append(line).append(lineSep);
                line = in.readLine();
                if (line != null) continue;
                for (int i = 0; i < lineSep.length(); ++i) {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String removeIndentFromLine(String aLine) {
        StringBuffer line = new StringBuffer(aLine);
        int whitespaces = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == ' ') {
                ++whitespaces;
                continue;
            }
            if (c != '\t') break;
            line.deleteCharAt(i);
            return line.toString();
        }
        int deleteCount = Math.min(whitespaces, 4);
        line.delete(0, deleteCount);
        return line.toString();
    }

    private String removeCommentIndentFromLine(String line) {
        int pos = line.indexOf("//");
        if (pos != -1) {
            return line.substring(0, pos) + line.substring(pos + 2);
        }
        return line;
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setDirty(boolean isDirty) {
        if (this.m_isDirty == isDirty) {
            return;
        }
        this.m_isDirty = isDirty;
        if (this.m_dirtyListener != null) {
            this.m_dirtyListener.editorDirtyChanged(this, isDirty);
        }
    }

    public DirtyListener getDirtyListener() {
        return this.m_dirtyListener;
    }

    public void setDirtyListener(DirtyListener dirtyListener) {
        this.m_dirtyListener = dirtyListener;
    }

    public UndoRedoListener getUndoRedoListener() {
        return this.undoRedoListener;
    }

    public void setUndoRedoListener(UndoRedoListener undoRedoListener) {
        this.undoRedoListener = undoRedoListener;
    }

    public boolean getExternalChanged() {
        return this.externalChanged;
    }

    public void setExternalChanged(boolean externalChanged) {
        this.externalChanged = externalChanged;
    }

    public File getFile() {
        return this.m_file;
    }

    public void setFile(File file) {
        this.m_file = file;
    }

    public int getFileType() {
        return this.m_fileType;
    }

    public void setFileType(int fileType) {
        this.m_fileType = fileType;
    }

    public void setLastUsedInput(String lastUsedInput) {
        this.m_lastUsedInput = lastUsedInput != null ? lastUsedInput : "";
        this.saveLastUsedInput(this.m_lastUsedInput);
    }

    private void saveLastUsedInput(String lastUsedInput) {
        File historyDir = new File("input_history/");
        historyDir.mkdirs();
        File historyFile = new File(historyDir, "ih_" + this.m_file.getName());
        try {
            PrintWriter out = new PrintWriter(new FileWriter(historyFile));
            out.print(lastUsedInput);
            out.close();
        }
        catch (Exception exp) {
            // empty catch block
        }
    }

    private void loadLastUsedInput() {
        this.m_lastUsedInput = "";
        File historyDir = new File("input_history/");
        historyDir.mkdirs();
        File historyFile = new File(historyDir, "ih_" + this.m_file.getName());
        try {
            this.m_lastUsedInput = WhileUtils.readFile(historyFile);
        }
        catch (Exception exp) {
            this.m_lastUsedInput = "";
        }
    }

    public static void deleteLastUsedInput(File file) {
        File historyDir = new File("input_history/");
        historyDir.mkdirs();
        File historyFile = new File(historyDir, "ih_" + file.getName());
        historyFile.delete();
    }

    public String getLastUsedInput() {
        return this.m_lastUsedInput;
    }

    static Cursor getMirrorCursor() {
        if (mirrorCursor != null) {
            return mirrorCursor;
        }
        Image im = new ImageIcon("images/mirror_cursor.gif").getImage();
        mirrorCursor = Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(12, 0), "MirrorCursor");
        return mirrorCursor;
    }

    private int lineToPos(int line) {
        Element rowElement = this.txt.getDocument().getDefaultRootElement().getElement(line - 1);
        return rowElement.getStartOffset();
    }

    public void gotoErrorLine(WCCException error) {
        if (error == null) {
            return;
        }
        this.gotoLocation(error.line, error.col, error.fileType);
    }

    public void gotoLocation(int line, int col, int fileType) {
        if (line < 1) {
            line = 1;
        }
        if (col < 1) {
            col = 1;
        }
        Element rowElement = this.txt.getDocument().getDefaultRootElement().getElement(line - 1);
        int pos = 0;
        if (fileType == 1) {
            pos = rowElement.getStartOffset() + col - 1;
        } else {
            pos = rowElement.getStartOffset();
            try {
                String line2 = this.txt.getDocument().getText(rowElement.getStartOffset(), rowElement.getEndOffset() - rowElement.getStartOffset());
                pos += this.countLeadingWhiteSpaces(line2);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        this.txt.setCaretPosition(pos);
        this.txt.requestFocusInWindow();
    }

    private int posToRow(int pos) {
        Element map = this.txt.getDocument().getDefaultRootElement();
        int row = map.getElementIndex(pos);
        return row;
    }

    int posToCol(int pos) {
        Element map = this.txt.getDocument().getDefaultRootElement();
        int row = map.getElementIndex(pos);
        Element lineElem = map.getElement(row);
        int col = pos - lineElem.getStartOffset();
        return col;
    }

    Point posToView(int pos) {
        Element map = this.txt.getDocument().getDefaultRootElement();
        int row = map.getElementIndex(pos);
        Element lineElem = map.getElement(row);
        int col = pos - lineElem.getStartOffset();
        return new Point(row, col);
    }

    public int[] posToStartEndLine(int pos) {
        Element map = this.txt.getDocument().getDefaultRootElement();
        int row = map.getElementIndex(pos);
        Element lineElem = map.getElement(row);
        int s = lineElem.getStartOffset();
        int e = lineElem.getEndOffset();
        return new int[]{s, e};
    }

    public boolean hasBreakPoint(int line) {
        return this.lines.contains(new BreakPoint(line - 1));
    }

    public synchronized void toggleBreakPoint(int row) {
        if (row == -1) {
            row = this.posToRow(this.txt.getCaretPosition());
        }
        if (row == -1) {
            return;
        }
        int pos = this.lines.indexOf(new BreakPoint(row));
        if (pos == -1) {
            this.lines.add(new BreakPoint(row));
        } else {
            this.lines.remove(pos);
        }
        this.l.repaint();
    }

    void clearUndo() {
        this.undoManager.discardAllEdits();
    }

    public boolean hasUndo() {
        return this.undoManager.canUndo();
    }

    public boolean hasRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        try {
            this.undoManager.undo();
            if (this.undoRedoListener != null) {
                this.undoRedoListener.undoRedoChanged(this, 0);
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            this.undoManager.redo();
            if (this.undoRedoListener != null) {
                this.undoRedoListener.undoRedoChanged(this, 1);
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    private int countLeadingWhiteSpaces(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') continue;
            return i;
        }
        return line.length();
    }

    public void reloadSyntax() {
        this.doc.removeDocumentListener(this.documentListener);
        this.doc.setSyntax(this.doc.getSyntax());
        this.doc.addDocumentListener(this.documentListener);
        this.txt.repaint();
    }

    public Object markLine(int line) {
        try {
            Element rowElement = this.txt.getDocument().getDefaultRootElement().getElement(line - 1);
            int pos = rowElement.getStartOffset();
            int len = pos + rowElement.getEndOffset() - pos;
            return this.txt.getHighlighter().addHighlight(this.lineToPos(line), len, new aa2());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void clearMark(Object highlightTag) {
        if (highlightTag != null) {
            this.txt.getHighlighter().removeHighlight(highlightTag);
        }
    }

    public int getCurrentLine() {
        return this.posToRow(this.txt.getCaretPosition());
    }

    public String getBreakPoints() {
        String str = "";
        for (int i = 0; i < this.lines.size(); ++i) {
            BreakPoint bp = (BreakPoint)this.lines.get(i);
            str = str + bp.line + " ";
        }
        return str.trim();
    }

    public String getFileRelativeTo(File parentFile) {
        File file = this.m_file;
        String fileName = file.getName();
        for (file = file.getParentFile(); file != null && !file.equals(parentFile); file = file.getParentFile()) {
            fileName = file.getName() + "/" + fileName;
        }
        return fileName;
    }

    public void setBreakPoints(Collection breakPoints) {
        int maxRow = this.posToRow(this.doc.getLength());
        if (breakPoints != null) {
            Iterator iterator = breakPoints.iterator();
            while (iterator.hasNext()) {
                Integer line = (Integer)iterator.next();
                if (line > maxRow) continue;
                this.lines.add(new BreakPoint(line));
            }
        }
        this.l.repaint();
    }

    public static void main(String[] args) throws Exception {
        final CodeTextEditor txt = new CodeTextEditor(null, 0);
        txt.txt.setText(WhileUtils.readFile(new File("Study/Casing.while")));
        txt.clearUndo();
        JFrame fr = new JFrame("Hello");
        fr.getContentPane().setLayout(new BorderLayout());
        fr.getContentPane().add(txt.scroller);
        JButton btn = new JButton("Compile");
        btn.setMnemonic('c');
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    new WhileCompiler3(txt.txt.getText()).compile();
                    SysLog.out.println("No Errors");
                }
                catch (WCCException exp) {
                    SysLog.out.println("Location " + exp.line + ", " + exp.col + ": " + exp.getMessage());
                }
                txt.txt.requestFocusInWindow();
            }
        });
        fr.getContentPane().add((Component)btn, "South");
        fr.setDefaultCloseOperation(3);
        fr.setBounds(200, 100, 800, 400);
        fr.show();
    }

    class RedoAction
    extends AbstractAction {
        RedoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CodeTextEditor.this.redo();
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CodeTextEditor.this.undo();
        }
    }

    class MyUndoableEditListener
    implements UndoableEditListener {
        boolean compounding;
        private CompoundEdit compoundEdit;

        MyUndoableEditListener() {
        }

        public void setCompoundEdit(boolean value) {
            this.compounding = value;
        }

        public void startStop() {
            if (this.isCompoundEdit()) {
                this.compoundEdit.end();
                CodeTextEditor.this.undoManager.addEdit(this.compoundEdit);
                this.setCompoundEdit(false);
            } else {
                this.compoundEdit = new CompoundEdit();
                this.setCompoundEdit(true);
            }
        }

        public boolean isCompoundEdit() {
            return this.compounding;
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            if (this.isCompoundEdit()) {
                this.compoundEdit.addEdit(e.getEdit());
            } else {
                CodeTextEditor.this.undoManager.addEdit(e.getEdit());
            }
        }
    }

    class BreakPoint {
        int line = 0;

        BreakPoint(int l) {
            this.line = l;
        }

        public boolean equals(Object o) {
            return ((BreakPoint)o).line == this.line;
        }
    }

    class ToggleBreakPointMouseListener
    extends MouseAdapter {
        ToggleBreakPointMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int pos;
            int row;
            if (SwingUtilities.isLeftMouseButton(e) && (row = CodeTextEditor.this.posToRow(pos = CodeTextEditor.this.txt.viewToModel(e.getPoint()))) != -1) {
                CodeTextEditor.this.toggleBreakPoint(row);
            }
        }
    }

    class ThisDocumentListener
    implements DocumentListener {
        ThisDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateDirty();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateDirty();
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateDirty();
        }

        void updateDirty() {
            CodeTextEditor.this.setDirty(true);
        }
    }

    class StyledDoc
    extends SyntaxDocument {
        StyledDoc() {
        }

        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (super.isReadOnly()) {
                return;
            }
            super.replace(offset, length, text, attrs);
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (super.isReadOnly()) {
                return;
            }
            boolean handled = false;
            handled = this.handleSingleNewLineChar(offs, str, a);
            if (handled) {
                return;
            }
            handled = this.handleOverwriteMode(str, offs, a);
            if (handled) {
                return;
            }
            handled = this.handleNewLines(str, offs, a);
            if (handled) {
                return;
            }
            handled = this.handleTabs(str, offs, a);
            if (handled) {
                return;
            }
            handled = this.handleWhiteSpaces(str, offs, a);
            if (handled) {
                return;
            }
            super.insertString(offs, str, a);
        }

        private boolean handleSingleNewLineChar(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str.equals("\n")) {
                int pos = CodeTextEditor.this.txt.getCaretPosition();
                Element root = CodeTextEditor.this.txt.getDocument().getDefaultRootElement();
                int row = root.getElementIndex(pos);
                Element rowElement = root.getElement(row);
                int rowStartOffset = rowElement.getStartOffset();
                int rowEndOffset = rowElement.getEndOffset();
                int col = pos - rowStartOffset;
                String curLine = this.getText(rowStartOffset, rowEndOffset - rowStartOffset - 1);
                String autoIndentString = this.getAutoIndentString(curLine, col);
                super.insertString(offs, str + autoIndentString, a);
                boolean includeStartRow = pos != rowEndOffset - 1;
                this.advanceBreakPoints(row, includeStartRow);
                return true;
            }
            return false;
        }

        private boolean handleWhiteSpaces(String str, int offs, AttributeSet a) throws BadLocationException {
            if (str.matches(" +")) {
                SysLog.out.println(str.length());
                boolean spacesAreBeforeTabChar = this.checkIfAnyTabCharExistsAfterCurrentColumn();
                if (spacesAreBeforeTabChar) {
                    str = "\t";
                    super.insertString(offs, str, a);
                    return true;
                }
            }
            return false;
        }

        private boolean handleTabs(String str, int offs, AttributeSet a) throws BadLocationException {
            if (str.equals("\t")) {
                str = this.checkIfTabShouldBeReplaceWithChars();
                super.insertString(offs, str, a);
                return true;
            }
            return false;
        }

        private boolean handleNewLines(String str, int offs, AttributeSet a) throws BadLocationException {
            int pos = str.indexOf(10);
            if (pos != -1) {
                this.handleAdvanceBreakPointsForString(str, pos);
                super.insertString(offs, str, a);
                return true;
            }
            return false;
        }

        private boolean handleOverwriteMode(String str, int offs, AttributeSet a) throws BadLocationException {
            String removedText;
            boolean overwritting;
            boolean noSelection = CodeTextEditor.this.txt.getSelectedText() == null;
            boolean bl = overwritting = CodeTextEditor.this.overwriteText && str.length() == 1 && !str.equals("\t") && noSelection;
            if (overwritting && !(removedText = this.getText(offs, 1)).equals("\n")) {
                CodeTextEditor.this.myUndoableEditListener.startStop();
                super.remove(offs, 1);
                super.insertString(offs, str, a);
                CodeTextEditor.this.myUndoableEditListener.startStop();
                return true;
            }
            return false;
        }

        private boolean checkIfAnyTabCharExistsAfterCurrentColumn() {
            int pos = CodeTextEditor.this.txt.getCaretPosition();
            Element root = CodeTextEditor.this.txt.getDocument().getDefaultRootElement();
            int row = root.getElementIndex(pos);
            Element rowElement = root.getElement(row);
            int rowStartOffset = rowElement.getStartOffset();
            int rowEndOffset = rowElement.getEndOffset();
            int col = pos - rowStartOffset;
            try {
                String line = this.getText(rowStartOffset, rowEndOffset - rowStartOffset - 1);
                for (int i = col; i < line.length(); ++i) {
                    if (line.charAt(i) != '\t') continue;
                    return true;
                }
                return false;
            }
            catch (BadLocationException e) {
                return false;
            }
        }

        private String checkIfTabShouldBeReplaceWithChars() {
            int pos = CodeTextEditor.this.txt.getCaretPosition();
            Element root = CodeTextEditor.this.txt.getDocument().getDefaultRootElement();
            int row = root.getElementIndex(pos);
            Element rowElement = root.getElement(row);
            int rowStartOffset = rowElement.getStartOffset();
            int rowEndOffset = rowElement.getEndOffset();
            int col = pos - rowStartOffset;
            try {
                String line = this.getText(rowStartOffset, rowEndOffset - rowStartOffset - 1);
                for (int i = 0; i < col; ++i) {
                    if (line.charAt(i) == ' ' || line.charAt(i) == '\t') continue;
                    return " ";
                }
                return "\t";
            }
            catch (BadLocationException e) {
                return "\t";
            }
        }

        private void handleAdvanceBreakPointsForString(String str, int pos) {
            Element map = CodeTextEditor.this.txt.getDocument().getDefaultRootElement();
            int row = map.getElementIndex(CodeTextEditor.this.txt.getCaretPosition());
            Element lineElem = map.getElement(row);
            int e = lineElem.getEndOffset();
            boolean includeStartRow = CodeTextEditor.this.txt.getCaretPosition() != e - 1;
            this.advanceBreakPoints(row, includeStartRow);
            pos = str.indexOf(10, pos + 1);
            while (pos != -1) {
                this.advanceBreakPoints(row, false);
                pos = str.indexOf(10, pos + 1);
            }
        }

        private String getAutoIndentString(String curLine, int col) {
            String autoIndentString = null;
            int nonWhiteSpace = this.findNonWhiteSpace(curLine);
            autoIndentString = col >= nonWhiteSpace ? curLine.substring(0, nonWhiteSpace) : curLine.substring(0, col);
            if (col > this.findNonWhiteSpaceReverse(curLine)) {
                autoIndentString = this.checkAutoIndent(autoIndentString, curLine);
            }
            return autoIndentString;
        }

        private int findNonWhiteSpace(String curLine) {
            for (int i = 0; i < curLine.length(); ++i) {
                char c = curLine.charAt(i);
                if (c == ' ' || c == '\t') continue;
                return i;
            }
            return curLine.length();
        }

        private int findNonWhiteSpaceReverse(String curLine) {
            for (int i = curLine.length() - 1; i >= 0; --i) {
                char c = curLine.charAt(i);
                if (c == ' ' || c == '\t') continue;
                return i;
            }
            return 0;
        }

        private String checkAutoIndent(String autoIndentString, String curLine) {
            String trimmedLine = this.trim2(curLine);
            String moreIndent = this.shouldIndent(trimmedLine);
            if (moreIndent != null) {
                autoIndentString = autoIndentString + moreIndent;
            }
            return autoIndentString;
        }

        private String shouldIndent(String trimmedLine) {
            if (trimmedLine.endsWith(" do")) {
                return "\t";
            }
            if (trimmedLine.endsWith(" then")) {
                return "\t";
            }
            if (trimmedLine.equals("else")) {
                return "\t";
            }
            if (trimmedLine.startsWith("read ")) {
                return "\t";
            }
            if (!SugarHandler.isCaseSugarActive()) {
                return null;
            }
            if (trimmedLine.endsWith(" of")) {
                return "\t";
            }
            int pos = trimmedLine.indexOf("=>");
            if (pos == -1) {
                return null;
            }
            String after = trimmedLine.substring(pos + 2);
            int whitspacePrefix = this.findNonWhiteSpace(after);
            char[] x = new char[pos + 2 + whitspacePrefix];
            Arrays.fill(x, ' ');
            return new String(x).replaceAll("    ", "\t");
        }

        private String trim2(String curLine) {
            if ((curLine = curLine.trim()).length() == 0) {
                return curLine;
            }
            StringBuffer x = new StringBuffer(curLine);
            while (x.length() > 0 && x.charAt(0) == '\t') {
                x.deleteCharAt(0);
            }
            while (x.length() > 0 && x.charAt(x.length() - 1) == '\t') {
                x.deleteCharAt(x.length() - 1);
            }
            return x.toString();
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (super.isReadOnly()) {
                return;
            }
            this.removeBreakPoints(offs, len);
            super.remove(offs, len);
        }

        void advanceBreakPoints(int startRow, boolean includeStartRow) {
            boolean needsRepaint = false;
            for (int i = 0; i < CodeTextEditor.this.lines.size(); ++i) {
                BreakPoint bp = (BreakPoint)CodeTextEditor.this.lines.get(i);
                if (bp.line > startRow) {
                    ++bp.line;
                    needsRepaint = true;
                    continue;
                }
                if (bp.line != startRow) continue;
                if (includeStartRow) {
                    ++bp.line;
                }
                needsRepaint = true;
            }
            if (needsRepaint) {
                CodeTextEditor.this.l.repaint();
            }
        }

        void removeBreakPoints(int offs, int len) {
            BreakPoint bp;
            int i;
            int row1 = CodeTextEditor.this.posToRow(offs);
            int row2 = CodeTextEditor.this.posToRow(offs + len);
            int s = this.getDefaultRootElement().getElement(row1).getStartOffset();
            int rlen = 0;
            try {
                String str = CodeTextEditor.this.txt.getText(offs, len);
                int pos = -1;
                while ((pos = str.indexOf(10, pos + 1)) != -1) {
                    ++rlen;
                }
            }
            catch (Exception exp) {
                // empty catch block
            }
            boolean needRepaint = false;
            if (rlen == 0) {
                return;
            }
            for (i = CodeTextEditor.this.lines.size() - 1; i >= 0; --i) {
                bp = (BreakPoint)CodeTextEditor.this.lines.get(i);
                if (bp.line >= row2) {
                    bp.line -= rlen;
                } else {
                    if (bp.line < row1 || bp.line == row1 && CodeTextEditor.this.txt.getCaretPosition() != s) continue;
                    CodeTextEditor.this.lines.remove(bp);
                }
                needRepaint = true;
            }
            if (!needRepaint) {
                return;
            }
            block4: for (i = CodeTextEditor.this.lines.size() - 1; i >= 0; --i) {
                bp = (BreakPoint)CodeTextEditor.this.lines.get(i);
                for (int j = 0; j < CodeTextEditor.this.lines.size(); ++j) {
                    BreakPoint bp2 = (BreakPoint)CodeTextEditor.this.lines.get(j);
                    if (bp2 == bp || bp2.line != bp.line) continue;
                    CodeTextEditor.this.lines.remove(bp);
                    continue block4;
                }
            }
            CodeTextEditor.this.l.repaint();
        }

        public void silentRemove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
        }
    }

    class JLabel2
    extends JLabel {
        ImageIcon img;
        private final Color COLOR_1 = Color.white;
        private final Color COLOR_2 = new Color(234, 234, 234);

        public JLabel2() {
            this.img = new ImageIcon("images/bp.png");
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.COLOR_1, this.getWidth(), 0.0f, this.COLOR_2);
            g2d.setPaint(gradientPaint);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setPaint(oldPaint);
            for (int i = 0; i < CodeTextEditor.this.lines.size(); ++i) {
                BreakPoint bp = (BreakPoint)CodeTextEditor.this.lines.get(i);
                g.drawImage(this.img.getImage(), 2, bp.line * 14 - 2, this);
            }
        }
    }
}

