/*
 * Decompiled with CFR 0.152.
 */
package whilepack.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class ClipboardMenuHandler
implements MouseListener,
ActionListener {
    private JTextComponent txt = null;
    private JPopupMenu popup;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem delete;
    private JMenuItem selAll;

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        boolean anySelection;
        if (!e.isPopupTrigger()) {
            return;
        }
        if (this.popup == null) {
            this.createPopup();
        }
        this.txt = (JTextComponent)e.getSource();
        this.txt.requestFocusInWindow();
        boolean bl = anySelection = this.txt.getSelectionStart() != this.txt.getSelectionEnd();
        if (!this.txt.isEditable()) {
            this.cut.setEnabled(false);
            this.delete.setEnabled(false);
            this.paste.setEnabled(false);
            this.copy.setEnabled(anySelection);
        } else {
            this.cut.setEnabled(anySelection);
            this.copy.setEnabled(anySelection);
            this.delete.setEnabled(anySelection);
            boolean isTextClip = false;
            Clipboard clipboard = this.txt.getToolkit().getSystemClipboard();
            if (clipboard.getContents(null) != null) {
                isTextClip = clipboard.getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
            }
            this.paste.setEnabled(isTextClip);
        }
        this.selAll.setEnabled(this.txt.getDocument().getLength() > 0);
        this.popup.show(this.txt, e.getX(), e.getY());
    }

    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        if (ac.equals("cut")) {
            this.txt.cut();
        }
        if (ac.equals("copy")) {
            this.txt.copy();
        }
        if (ac.equals("paste")) {
            this.txt.paste();
        }
        if (ac.equals("delete")) {
            this.txt.replaceSelection("");
        }
        if (ac.equals("select_all")) {
            this.txt.selectAll();
        }
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        this.cut = this.popup.add("Cut");
        this.copy = this.popup.add("Copy");
        this.paste = this.popup.add("Paste");
        this.delete = this.popup.add("Delete");
        this.popup.addSeparator();
        this.selAll = this.popup.add("Select All");
        this.cut.setActionCommand("cut");
        this.copy.setActionCommand("copy");
        this.paste.setActionCommand("paste");
        this.delete.setActionCommand("delete");
        this.selAll.setActionCommand("select_all");
        this.cut.addActionListener(this);
        this.copy.addActionListener(this);
        this.paste.addActionListener(this);
        this.delete.addActionListener(this);
        this.selAll.addActionListener(this);
    }

    public static void config(JTextComponent t) {
        if (t != null) {
            t.addMouseListener(new ClipboardMenuHandler());
        }
    }
}

